/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.IllegalFieldValueException;

public class FieldUtils {
    private FieldUtils() {
    }

    public static boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static int getWrappedValue(int n2, int n3, int n4) {
        if (n3 >= n4) {
            throw new IllegalArgumentException("MIN > MAX");
        }
        int n5 = 1 + (n4 - n3);
        int n6 = n2 - n3;
        if (n6 >= 0) {
            return n3 + n6 % n5;
        }
        int n7 = -n6 % n5;
        if (n7 == 0) {
            return n3 + 0;
        }
        return n3 + (n5 - n7);
    }

    public static int getWrappedValue(int n2, int n3, int n4, int n5) {
        return FieldUtils.getWrappedValue(n2 + n3, n4, n5);
    }

    public static int safeAdd(int n2, int n3) {
        int n4 = n2 + n3;
        if ((n2 ^ n4) < 0 && (n2 ^ n3) >= 0) {
            throw new ArithmeticException("The calculation caused an overflow: " + n2 + " + " + n3);
        }
        return n4;
    }

    public static long safeAdd(long l2, long l3) {
        long l4 = l2 + l3;
        if ((l2 ^ l4) < 0L && (l2 ^ l3) >= 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + l2 + " + " + l3);
        }
        return l4;
    }

    public static int safeMultiply(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Multiplication overflows an int: " + n2 + " * " + n3);
        }
        return (int)l2;
    }

    public static long safeMultiply(long l2, int n2) {
        long l3;
        switch (n2) {
            default: {
                l3 = l2 * (long)n2;
                if (l3 / (long)n2 == l2) break;
                throw new ArithmeticException("Multiplication overflows a long: " + l2 + " * " + n2);
            }
            case -1: {
                if (l2 == Long.MIN_VALUE) {
                    throw new ArithmeticException("Multiplication overflows a long: " + l2 + " * " + n2);
                }
                l2 = -l2;
            }
            case 1: {
                return l2;
            }
            case 0: {
                return 0L;
            }
        }
        return l3;
    }

    public static long safeMultiply(long l2, long l3) {
        if (l3 == 1L) {
            return l2;
        }
        if (l2 == 1L) {
            return l3;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l4 = l2 * l3;
        if (l4 / l3 != l2 || l2 == Long.MIN_VALUE && l3 == -1L || l3 == Long.MIN_VALUE && l2 == -1L) {
            throw new ArithmeticException("Multiplication overflows a long: " + l2 + " * " + l3);
        }
        return l4;
    }

    public static int safeMultiplyToInt(long l2, long l3) {
        return FieldUtils.safeToInt(FieldUtils.safeMultiply(l2, l3));
    }

    public static int safeNegate(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            throw new ArithmeticException("Integer.MIN_VALUE cannot be negated");
        }
        return -n2;
    }

    public static long safeSubtract(long l2, long l3) {
        long l4 = l2 - l3;
        if ((l2 ^ l4) < 0L && (l2 ^ l3) < 0L) {
            throw new ArithmeticException("The calculation caused an overflow: " + l2 + " - " + l3);
        }
        return l4;
    }

    public static int safeToInt(long l2) {
        if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            return (int)l2;
        }
        throw new ArithmeticException("Value cannot fit in an int: " + l2);
    }

    public static void verifyValueBounds(String string2, int n2, int n3, int n4) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalFieldValueException(string2, (Number)n2, (Number)n3, (Number)n4);
        }
    }

    public static void verifyValueBounds(DateTimeField dateTimeField, int n2, int n3, int n4) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n2, (Number)n3, (Number)n4);
        }
    }

    public static void verifyValueBounds(DateTimeFieldType dateTimeFieldType, int n2, int n3, int n4) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalFieldValueException(dateTimeFieldType, (Number)n2, (Number)n3, (Number)n4);
        }
    }
}

