/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ScaledDurationField;

public class DividedDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 8318475124230605365L;
    final int iDivisor;
    final DurationField iDurationField;
    private final int iMax;
    private final int iMin;

    /*
     * Enabled aggressive block sorting
     */
    public DividedDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2) {
        super(dateTimeField, dateTimeFieldType);
        if (n2 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField = dateTimeField.getDurationField();
        this.iDurationField = durationField == null ? null : new ScaledDurationField(durationField, dateTimeFieldType.getDurationType(), n2);
        this.iDivisor = n2;
        int n3 = dateTimeField.getMinimumValue();
        int n4 = n3 >= 0 ? n3 / n2 : -1 + (n3 + 1) / n2;
        int n5 = dateTimeField.getMaximumValue();
        int n6 = n5 >= 0 ? n5 / n2 : -1 + (n5 + 1) / n2;
        this.iMin = n4;
        this.iMax = n6;
    }

    /*
     * Enabled aggressive block sorting
     */
    public DividedDateTimeField(RemainderDateTimeField remainderDateTimeField, DateTimeFieldType dateTimeFieldType) {
        super(remainderDateTimeField.getWrappedField(), dateTimeFieldType);
        int n2;
        this.iDivisor = n2 = remainderDateTimeField.iDivisor;
        this.iDurationField = remainderDateTimeField.iRangeField;
        DateTimeField dateTimeField = this.getWrappedField();
        int n3 = dateTimeField.getMinimumValue();
        int n4 = n3 >= 0 ? n3 / n2 : -1 + (n3 + 1) / n2;
        int n5 = dateTimeField.getMaximumValue();
        int n6 = n5 >= 0 ? n5 / n2 : -1 + (n5 + 1) / n2;
        this.iMin = n4;
        this.iMax = n6;
    }

    private int getRemainder(int n2) {
        if (n2 >= 0) {
            return n2 % this.iDivisor;
        }
        return -1 + this.iDivisor + (n2 + 1) % this.iDivisor;
    }

    @Override
    public long add(long l2, int n2) {
        return this.getWrappedField().add(l2, n2 * this.iDivisor);
    }

    @Override
    public long add(long l2, long l3) {
        return this.getWrappedField().add(l2, l3 * (long)this.iDivisor);
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, this.iMin, this.iMax));
    }

    @Override
    public int get(long l2) {
        int n2 = this.getWrappedField().get(l2);
        if (n2 >= 0) {
            return n2 / this.iDivisor;
        }
        return -1 + (n2 + 1) / this.iDivisor;
    }

    @Override
    public int getDifference(long l2, long l3) {
        return this.getWrappedField().getDifference(l2, l3) / this.iDivisor;
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        return this.getWrappedField().getDifferenceAsLong(l2, l3) / (long)this.iDivisor;
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public int getMinimumValue() {
        return this.iMin;
    }

    @Override
    public long remainder(long l2) {
        return this.set(l2, this.get(this.getWrappedField().remainder(l2)));
    }

    @Override
    public long roundFloor(long l2) {
        DateTimeField dateTimeField = this.getWrappedField();
        return dateTimeField.roundFloor(dateTimeField.set(l2, this.get(l2) * this.iDivisor));
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMin, this.iMax);
        int n3 = this.getRemainder(this.getWrappedField().get(l2));
        return this.getWrappedField().set(l2, n3 + n2 * this.iDivisor);
    }
}

