/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = dateTimeFieldType;
    }

    @Override
    public long add(long l2, int n2) {
        return this.getDurationField().add(l2, n2);
    }

    @Override
    public long add(long l2, long l3) {
        return this.getDurationField().add(l2, l3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        int n4;
        int n5;
        if (n3 == 0) {
            return nArray;
        }
        DateTimeField dateTimeField = null;
        int[] nArray2 = nArray;
        for (n4 = n3; n4 > 0; n4 -= n5 + 1 - nArray2[n2]) {
            long l2 = n4 + nArray2[n2];
            n5 = this.getMaximumValue(readablePartial, nArray2);
            if (l2 <= (long)n5) {
                nArray2[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            nArray2 = dateTimeField.add(readablePartial, n2 - 1, nArray2, 1);
            nArray2[n2] = this.getMinimumValue(readablePartial, nArray2);
        }
        while (true) {
            int n6;
            block14: {
                block13: {
                    if (n4 >= 0) break block13;
                    long l3 = n4 + nArray2[n2];
                    n6 = this.getMinimumValue(readablePartial, nArray2);
                    if (l3 < (long)n6) break block14;
                    nArray2[n2] = (int)l3;
                }
                return this.set(readablePartial, n2, nArray2, nArray2[n2]);
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n4 -= n6 - 1 - nArray2[n2];
            nArray2 = dateTimeField.add(readablePartial, n2 - 1, nArray2, -1);
            nArray2[n2] = this.getMaximumValue(readablePartial, nArray2);
        }
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, this.getMinimumValue(l2), this.getMaximumValue(l2)));
    }

    @Override
    public int[] addWrapField(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        return this.set(readablePartial, n2, nArray, FieldUtils.getWrappedValue(nArray[n2], n3, this.getMinimumValue(readablePartial), this.getMaximumValue(readablePartial)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int[] addWrapPartial(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray;
        }
        DateTimeField dateTimeField = null;
        int n4 = n3;
        int[] nArray2 = nArray;
        while (n4 > 0) {
            long l2 = n4 + nArray2[n2];
            int n5 = this.getMaximumValue(readablePartial, nArray2);
            if (l2 <= (long)n5) {
                nArray2[n2] = (int)l2;
                break;
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    n4 -= n5 + 1 - nArray2[n2];
                    nArray2[n2] = this.getMinimumValue(readablePartial, nArray2);
                    continue;
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n4 -= n5 + 1 - nArray2[n2];
            nArray2 = dateTimeField.addWrapPartial(readablePartial, n2 - 1, nArray2, 1);
            nArray2[n2] = this.getMinimumValue(readablePartial, nArray2);
        }
        while (true) {
            int n6;
            block14: {
                block13: {
                    if (n4 >= 0) break block13;
                    long l3 = n4 + nArray2[n2];
                    n6 = this.getMinimumValue(readablePartial, nArray2);
                    if (l3 < (long)n6) break block14;
                    nArray2[n2] = (int)l3;
                }
                return this.set(readablePartial, n2, nArray2, nArray2[n2]);
            }
            if (dateTimeField == null) {
                if (n2 == 0) {
                    n4 -= n6 - 1 - nArray2[n2];
                    nArray2[n2] = this.getMaximumValue(readablePartial, nArray2);
                    continue;
                }
                dateTimeField = readablePartial.getField(n2 - 1);
                if (this.getRangeDurationField().getType() != dateTimeField.getDurationField().getType()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            n4 -= n6 - 1 - nArray2[n2];
            nArray2 = dateTimeField.addWrapPartial(readablePartial, n2 - 1, nArray2, -1);
            nArray2[n2] = this.getMaximumValue(readablePartial, nArray2);
        }
    }

    protected int convertText(String string2, Locale locale) {
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalFieldValueException(this.getType(), string2);
        }
    }

    @Override
    public abstract int get(long var1);

    @Override
    public String getAsShortText(int n2, Locale locale) {
        return this.getAsText(n2, locale);
    }

    @Override
    public final String getAsShortText(long l2) {
        return this.getAsShortText(l2, null);
    }

    @Override
    public String getAsShortText(long l2, Locale locale) {
        return this.getAsShortText(this.get(l2), locale);
    }

    @Override
    public String getAsShortText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.getAsShortText(n2, locale);
    }

    @Override
    public final String getAsShortText(ReadablePartial readablePartial, Locale locale) {
        return this.getAsShortText(readablePartial, readablePartial.get(this.getType()), locale);
    }

    @Override
    public String getAsText(int n2, Locale locale) {
        return Integer.toString(n2);
    }

    @Override
    public final String getAsText(long l2) {
        return this.getAsText(l2, null);
    }

    @Override
    public String getAsText(long l2, Locale locale) {
        return this.getAsText(this.get(l2), locale);
    }

    @Override
    public String getAsText(ReadablePartial readablePartial, int n2, Locale locale) {
        return this.getAsText(n2, locale);
    }

    @Override
    public final String getAsText(ReadablePartial readablePartial, Locale locale) {
        return this.getAsText(readablePartial, readablePartial.get(this.getType()), locale);
    }

    @Override
    public int getDifference(long l2, long l3) {
        return this.getDurationField().getDifference(l2, l3);
    }

    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        return this.getDurationField().getDifferenceAsLong(l2, l3);
    }

    @Override
    public abstract DurationField getDurationField();

    @Override
    public int getLeapAmount(long l2) {
        return 0;
    }

    @Override
    public DurationField getLeapDurationField() {
        return null;
    }

    @Override
    public int getMaximumShortTextLength(Locale locale) {
        return this.getMaximumTextLength(locale);
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        int n2 = this.getMaximumValue();
        if (n2 >= 0) {
            if (n2 < 10) {
                return 1;
            }
            if (n2 < 100) {
                return 2;
            }
            if (n2 < 1000) {
                return 3;
            }
        }
        return Integer.toString(n2).length();
    }

    @Override
    public abstract int getMaximumValue();

    @Override
    public int getMaximumValue(long l2) {
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.getMaximumValue(readablePartial);
    }

    @Override
    public abstract int getMinimumValue();

    @Override
    public int getMinimumValue(long l2) {
        return this.getMinimumValue();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial) {
        return this.getMinimumValue();
    }

    @Override
    public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
        return this.getMinimumValue(readablePartial);
    }

    @Override
    public final String getName() {
        return this.iType.getName();
    }

    @Override
    public abstract DurationField getRangeDurationField();

    @Override
    public final DateTimeFieldType getType() {
        return this.iType;
    }

    @Override
    public boolean isLeap(long l2) {
        return false;
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    @Override
    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    @Override
    public long roundCeiling(long l2) {
        long l3 = this.roundFloor(l2);
        if (l3 != l2) {
            l2 = this.add(l3, 1);
        }
        return l2;
    }

    @Override
    public abstract long roundFloor(long var1);

    @Override
    public long roundHalfCeiling(long l2) {
        long l3;
        long l4 = this.roundFloor(l2);
        long l5 = this.roundCeiling(l2);
        if (l5 - l2 <= (l3 = l2 - l4)) {
            return l5;
        }
        return l4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long roundHalfEven(long l2) {
        long l3;
        block5: {
            long l4;
            block4: {
                long l5;
                l4 = this.roundFloor(l2);
                long l6 = l2 - l4;
                if (l6 < (l5 = (l3 = this.roundCeiling(l2)) - l2)) break block4;
                if (l5 < l6) {
                    return l3;
                }
                if ((1 & this.get(l3)) == 0) break block5;
            }
            return l4;
        }
        return l3;
    }

    @Override
    public long roundHalfFloor(long l2) {
        long l3;
        long l4 = this.roundFloor(l2);
        if (l2 - l4 <= (l3 = this.roundCeiling(l2)) - l2) {
            return l4;
        }
        return l3;
    }

    @Override
    public abstract long set(long var1, int var3);

    @Override
    public final long set(long l2, String string2) {
        return this.set(l2, string2, null);
    }

    @Override
    public long set(long l2, String string2, Locale locale) {
        return this.set(l2, this.convertText(string2, locale));
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        FieldUtils.verifyValueBounds(this, n3, this.getMinimumValue(readablePartial, nArray), this.getMaximumValue(readablePartial, nArray));
        nArray[n2] = n3;
        for (int i2 = n2 + 1; i2 < readablePartial.size(); ++i2) {
            DateTimeField dateTimeField = readablePartial.getField(i2);
            if (nArray[i2] > dateTimeField.getMaximumValue(readablePartial, nArray)) {
                nArray[i2] = dateTimeField.getMaximumValue(readablePartial, nArray);
            }
            if (nArray[i2] >= dateTimeField.getMinimumValue(readablePartial, nArray)) continue;
            nArray[i2] = dateTimeField.getMinimumValue(readablePartial, nArray);
        }
        return nArray;
    }

    @Override
    public int[] set(ReadablePartial readablePartial, int n2, int[] nArray, String string2, Locale locale) {
        return this.set(readablePartial, n2, nArray, this.convertText(string2, locale));
    }

    @Override
    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

