/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePartial;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();

    protected StringConverter() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getDurationMillis(Object object) {
        long l2;
        long l3;
        int n2;
        int n3;
        String string2;
        int n4 = 1;
        String string3 = (String)object;
        int n5 = string3.length();
        if (!(n5 < 4 || string3.charAt(0) != 'P' && string3.charAt(0) != 'p' || string3.charAt(n4) != 'T' && string3.charAt(n4) != 't' || string3.charAt(n5 - 1) != 'S' && string3.charAt(n5 - 1) != 's')) {
            string2 = string3.substring(2, n5 - 1);
            n3 = 0;
            n2 = -1;
        } else {
            throw new IllegalArgumentException("Invalid format: \"" + string3 + '\"');
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) >= '0' && string2.charAt(i2) <= '9') continue;
            if (i2 == 0 && string2.charAt(0) == '-') {
                n3 = n4;
                continue;
            }
            int n6 = n3 != 0 ? n4 : 0;
            if (i2 > n6 && string2.charAt(i2) == '.' && n2 == -1) {
                n2 = i2;
                continue;
            }
            throw new IllegalArgumentException("Invalid format: \"" + string3 + '\"');
        }
        if (n3 == 0) {
            n4 = 0;
        }
        if (n2 > 0) {
            long l4 = Long.parseLong(string2.substring(n4, n2));
            String string4 = string2.substring(n2 + 1);
            if (string4.length() != 3) {
                string4 = (string4 + "000").substring(0, 3);
            }
            l3 = Integer.parseInt(string4);
            l2 = l4;
        } else if (n3 != 0) {
            l2 = Long.parseLong(string2.substring(n4, string2.length()));
            l3 = 0L;
        } else {
            l2 = Long.parseLong(string2);
            l3 = 0L;
        }
        if (n3 != 0) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(-l2, 1000), -l3);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(l2, 1000), l3);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        String string2 = (String)object;
        return ISODateTimeFormat.dateTimeParser().withChronology(chronology).parseMillis(string2);
    }

    @Override
    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter.getZone() != null) {
            chronology = chronology.withZone(dateTimeFormatter.getZone());
        }
        return chronology.get(readablePartial, dateTimeFormatter.withChronology(chronology).parseMillis((String)object));
    }

    @Override
    public Class<?> getSupportedType() {
        return String.class;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        long l2;
        char c2;
        Chronology chronology2;
        Period period;
        String string2 = (String)object;
        int n2 = string2.indexOf(47);
        if (n2 < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + string2);
        }
        String string3 = string2.substring(0, n2);
        if (string3.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string2);
        }
        String string4 = string2.substring(n2 + 1);
        if (string4.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + string2);
        }
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser().withChronology(chronology);
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        long l3 = 0L;
        char c3 = string3.charAt(0);
        if (c3 == 'P' || c3 == 'p') {
            period = periodFormatter.withParseType(this.getPeriodType(string3)).parsePeriod(string3);
            chronology2 = null;
        } else {
            DateTime dateTime = dateTimeFormatter.parseDateTime(string3);
            l3 = dateTime.getMillis();
            chronology2 = dateTime.getChronology();
            period = null;
        }
        if ((c2 = string4.charAt(0)) == 'P' || c2 == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + string2);
            }
            Period period2 = periodFormatter.withParseType(this.getPeriodType(string4)).parsePeriod(string4);
            if (chronology == null) {
                chronology = chronology2;
            }
            l2 = chronology.add(period2, l3, 1);
        } else {
            DateTime dateTime = dateTimeFormatter.parseDateTime(string4);
            long l4 = dateTime.getMillis();
            if (chronology2 == null) {
                chronology2 = dateTime.getChronology();
            }
            if (chronology == null) {
                chronology = chronology2;
            }
            if (period != null) {
                l3 = chronology.add(period, l4, -1);
                l2 = l4;
            } else {
                l2 = l4;
            }
        }
        readWritableInterval.setInterval(l3, l2);
        readWritableInterval.setChronology(chronology);
    }

    @Override
    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        String string2 = (String)object;
        PeriodFormatter periodFormatter = ISOPeriodFormat.standard();
        readWritablePeriod.clear();
        int n2 = periodFormatter.parseInto(readWritablePeriod, string2, 0);
        if (n2 < string2.length()) {
            if (n2 < 0) {
                periodFormatter.withParseType(readWritablePeriod.getPeriodType()).parseMutablePeriod(string2);
            }
            throw new IllegalArgumentException("Invalid format: \"" + string2 + '\"');
        }
    }
}

