/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadableInterval;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PeriodConverter;

class ReadableIntervalConverter
extends AbstractConverter
implements IntervalConverter,
DurationConverter,
PeriodConverter {
    static final ReadableIntervalConverter INSTANCE = new ReadableIntervalConverter();

    protected ReadableIntervalConverter() {
    }

    @Override
    public long getDurationMillis(Object object) {
        return ((ReadableInterval)object).toDurationMillis();
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInterval.class;
    }

    @Override
    public boolean isReadableInterval(Object object, Chronology chronology) {
        return true;
    }

    @Override
    public void setInto(ReadWritableInterval readWritableInterval, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        readWritableInterval.setInterval(readableInterval);
        if (chronology != null) {
            readWritableInterval.setChronology(chronology);
            return;
        }
        readWritableInterval.setChronology(readableInterval.getChronology());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setInto(ReadWritablePeriod readWritablePeriod, Object object, Chronology chronology) {
        ReadableInterval readableInterval = (ReadableInterval)object;
        Chronology chronology2 = chronology != null ? chronology : DateTimeUtils.getIntervalChronology(readableInterval);
        int[] nArray = chronology2.get(readWritablePeriod, readableInterval.getStartMillis(), readableInterval.getEndMillis());
        int n2 = 0;
        while (n2 < nArray.length) {
            readWritablePeriod.setValue(n2, nArray[n2]);
            ++n2;
        }
        return;
    }
}

