/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.PartialConverter;

class ReadableInstantConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final ReadableInstantConverter INSTANCE = new ReadableInstantConverter();

    protected ReadableInstantConverter() {
    }

    @Override
    public Chronology getChronology(Object object, Chronology chronology) {
        if (chronology == null) {
            chronology = DateTimeUtils.getChronology(((ReadableInstant)object).getChronology());
        }
        return chronology;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        Chronology chronology = ((ReadableInstant)object).getChronology();
        if (chronology == null) {
            return ISOChronology.getInstance(dateTimeZone);
        }
        if (chronology.getZone() == dateTimeZone) return chronology;
        if ((chronology = chronology.withZone(dateTimeZone)) != null) return chronology;
        return ISOChronology.getInstance(dateTimeZone);
    }

    @Override
    public long getInstantMillis(Object object, Chronology chronology) {
        return ((ReadableInstant)object).getMillis();
    }

    @Override
    public Class<?> getSupportedType() {
        return ReadableInstant.class;
    }
}

