/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.convert.Converter;

class ConverterSet {
    private final Converter[] iConverters;
    private Entry[] iSelectEntries;

    ConverterSet(Converter[] converterArray) {
        this.iConverters = converterArray;
        this.iSelectEntries = new Entry[16];
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Converter selectSlow(ConverterSet converterSet, Class<?> clazz) {
        int n2;
        int n3;
        int n4;
        Converter[] converterArray = converterSet.iConverters;
        int n5 = n4 = converterArray.length;
        ConverterSet converterSet2 = converterSet;
        while ((n3 = n5 - 1) >= 0) {
            Converter converter = converterArray[n3];
            Class<?> clazz2 = converter.getSupportedType();
            if (clazz2 == clazz) {
                return converter;
            }
            if (clazz2 == null || clazz != null && !clazz2.isAssignableFrom(clazz)) {
                converterSet2 = converterSet2.remove(n3, null);
                converterArray = converterSet2.iConverters;
                n4 = converterArray.length;
            }
            n5 = n3;
        }
        Converter converter = null;
        if (clazz == null) return converter;
        converter = null;
        if (n4 == 0) return converter;
        if (n4 == 1) {
            return converterArray[0];
        }
        Converter[] converterArray2 = converterArray;
        ConverterSet converterSet3 = converterSet2;
        int n6 = n4;
        while ((n2 = n4 - 1) >= 0) {
            Class<?> clazz3 = converterArray2[n2].getSupportedType();
            ConverterSet converterSet4 = converterSet3;
            int n7 = n2;
            int n8 = n6;
            while (--n8 >= 0) {
                if (n8 == n7 || !converterArray2[n8].getSupportedType().isAssignableFrom(clazz3)) continue;
                converterSet4 = converterSet4.remove(n8, null);
                converterArray2 = converterSet4.iConverters;
                n6 = converterArray2.length;
                n7 = n6 - 1;
            }
            n4 = n7;
            converterSet3 = converterSet4;
        }
        if (n6 == 1) {
            return converterArray2[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to find best converter for type \"");
        stringBuilder.append(clazz.getName());
        stringBuilder.append("\" from remaining set: ");
        int n9 = 0;
        while (true) {
            if (n9 >= n6) {
                throw new IllegalStateException(stringBuilder.toString());
            }
            Converter converter2 = converterArray2[n9];
            Class<?> clazz4 = converter2.getSupportedType();
            stringBuilder.append(converter2.getClass().getName());
            stringBuilder.append('[');
            String string2 = clazz4 == null ? null : clazz4.getName();
            stringBuilder.append(string2);
            stringBuilder.append("], ");
            ++n9;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ConverterSet add(Converter converter, Converter[] converterArray) {
        Converter[] converterArray2;
        Converter converter2;
        int n2;
        int n3;
        Converter[] converterArray3;
        block6: {
            converterArray3 = this.iConverters;
            n3 = converterArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                converter2 = converterArray3[n2];
                if (converter.equals(converter2)) {
                    if (converterArray != null) {
                        converterArray[0] = null;
                    }
                    return this;
                }
                if (converter.getSupportedType() != converter2.getSupportedType()) continue;
                converterArray2 = new Converter[n3];
                break block6;
            }
            Converter[] converterArray4 = new Converter[n3 + 1];
            System.arraycopy(converterArray3, 0, converterArray4, 0, n3);
            converterArray4[n3] = converter;
            if (converterArray != null) {
                converterArray[0] = null;
            }
            return new ConverterSet(converterArray4);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            converterArray2[i2] = i2 != n2 ? converterArray3[i2] : converter;
        }
        if (converterArray != null) {
            converterArray[0] = converter2;
        }
        return new ConverterSet(converterArray2);
    }

    void copyInto(Converter[] converterArray) {
        System.arraycopy(this.iConverters, 0, converterArray, 0, this.iConverters.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    ConverterSet remove(int n2, Converter[] converterArray) {
        Converter[] converterArray2 = this.iConverters;
        int n3 = converterArray2.length;
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException();
        }
        if (converterArray != null) {
            converterArray[0] = converterArray2[n2];
        }
        Converter[] converterArray3 = new Converter[n3 - 1];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6;
            if (n4 != n2) {
                n6 = n5 + 1;
                converterArray3[n5] = converterArray2[n4];
            } else {
                n6 = n5;
            }
            ++n4;
            n5 = n6;
        }
        return new ConverterSet(converterArray3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ConverterSet remove(Converter converter, Converter[] converterArray) {
        Converter[] converterArray2 = this.iConverters;
        int n2 = converterArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!converter.equals(converterArray2[i2])) continue;
            return this.remove(i2, converterArray);
        }
        if (converterArray == null) return this;
        converterArray[0] = null;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    Converter select(Class<?> clazz) throws IllegalStateException {
        Entry[] entryArray;
        Converter converter;
        Entry[] entryArray2 = this.iSelectEntries;
        int n2 = entryArray2.length;
        int n3 = clazz == null ? 0 : clazz.hashCode() & n2 - 1;
        int n4 = n3;
        while (true) {
            int n5;
            Entry entry;
            if ((entry = entryArray2[n4]) != null) {
                if (entry.iType == clazz) {
                    return entry.iConverter;
                }
                n5 = n4 + 1;
                if (n5 >= n2) {
                    n4 = 0;
                    continue;
                }
            } else {
                converter = ConverterSet.selectSlow(this, clazz);
                Entry entry2 = new Entry(clazz, converter);
                entryArray = (Entry[])entryArray2.clone();
                entryArray[n4] = entry2;
                break;
            }
            n4 = n5;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (entryArray[i2] != null) continue;
            this.iSelectEntries = entryArray;
            return converter;
        }
        int n6 = n2 << 1;
        Entry[] entryArray3 = new Entry[n6];
        int n7 = 0;
        while (true) {
            if (n7 >= n2) {
                this.iSelectEntries = entryArray3;
                return converter;
            }
            Entry entry = entryArray[n7];
            Class<?> clazz2 = entry.iType;
            int n8 = clazz2 == null ? 0 : clazz2.hashCode() & n6 - 1;
            while (entryArray3[n8] != null) {
                if (++n8 < n6) continue;
                n8 = 0;
            }
            entryArray3[n8] = entry;
            ++n7;
        }
    }

    int size() {
        return this.iConverters.length;
    }

    static class Entry {
        final Converter iConverter;
        final Class<?> iType;

        Entry(Class<?> clazz, Converter converter) {
            this.iType = clazz;
            this.iConverter = converter;
        }
    }
}

