/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.JodaTimePermission;
import org.joda.time.convert.CalendarConverter;
import org.joda.time.convert.Converter;
import org.joda.time.convert.ConverterSet;
import org.joda.time.convert.DateConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.LongConverter;
import org.joda.time.convert.NullConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.convert.ReadableDurationConverter;
import org.joda.time.convert.ReadableInstantConverter;
import org.joda.time.convert.ReadableIntervalConverter;
import org.joda.time.convert.ReadablePartialConverter;
import org.joda.time.convert.ReadablePeriodConverter;
import org.joda.time.convert.StringConverter;

public final class ConverterManager {
    private static ConverterManager INSTANCE;
    private ConverterSet iDurationConverters;
    private ConverterSet iInstantConverters;
    private ConverterSet iIntervalConverters;
    private ConverterSet iPartialConverters;
    private ConverterSet iPeriodConverters;

    protected ConverterManager() {
        Converter[] converterArray = new Converter[]{ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE};
        this.iInstantConverters = new ConverterSet(converterArray);
        Converter[] converterArray2 = new Converter[]{ReadablePartialConverter.INSTANCE, ReadableInstantConverter.INSTANCE, StringConverter.INSTANCE, CalendarConverter.INSTANCE, DateConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE};
        this.iPartialConverters = new ConverterSet(converterArray2);
        Converter[] converterArray3 = new Converter[]{ReadableDurationConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, LongConverter.INSTANCE, NullConverter.INSTANCE};
        this.iDurationConverters = new ConverterSet(converterArray3);
        Converter[] converterArray4 = new Converter[]{ReadableDurationConverter.INSTANCE, ReadablePeriodConverter.INSTANCE, ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE};
        this.iPeriodConverters = new ConverterSet(converterArray4);
        Converter[] converterArray5 = new Converter[]{ReadableIntervalConverter.INSTANCE, StringConverter.INSTANCE, NullConverter.INSTANCE};
        this.iIntervalConverters = new ConverterSet(converterArray5);
    }

    private void checkAlterDurationConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterDurationConverters"));
        }
    }

    private void checkAlterInstantConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterInstantConverters"));
        }
    }

    private void checkAlterIntervalConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterIntervalConverters"));
        }
    }

    private void checkAlterPartialConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterPartialConverters"));
        }
    }

    private void checkAlterPeriodConverters() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("ConverterManager.alterPeriodConverters"));
        }
    }

    public static ConverterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterManager();
        }
        return INSTANCE;
    }

    public DurationConverter addDurationConverter(DurationConverter durationConverter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (durationConverter == null) {
            return null;
        }
        Converter[] converterArray = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.add(durationConverter, converterArray);
        return converterArray[0];
    }

    public InstantConverter addInstantConverter(InstantConverter instantConverter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (instantConverter == null) {
            return null;
        }
        Converter[] converterArray = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.add(instantConverter, converterArray);
        return converterArray[0];
    }

    public IntervalConverter addIntervalConverter(IntervalConverter intervalConverter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (intervalConverter == null) {
            return null;
        }
        Converter[] converterArray = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.add(intervalConverter, converterArray);
        return converterArray[0];
    }

    public PartialConverter addPartialConverter(PartialConverter partialConverter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (partialConverter == null) {
            return null;
        }
        Converter[] converterArray = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.add(partialConverter, converterArray);
        return converterArray[0];
    }

    public PeriodConverter addPeriodConverter(PeriodConverter periodConverter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (periodConverter == null) {
            return null;
        }
        Converter[] converterArray = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.add(periodConverter, converterArray);
        return converterArray[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    public DurationConverter getDurationConverter(Object object) {
        String string2;
        ConverterSet converterSet = this.iDurationConverters;
        Class<?> clazz = object == null ? null : object.getClass();
        DurationConverter durationConverter = (DurationConverter)converterSet.select(clazz);
        if (durationConverter != null) {
            return durationConverter;
        }
        StringBuilder stringBuilder = new StringBuilder().append("No duration converter found for type: ");
        if (object == null) {
            string2 = "null";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public DurationConverter[] getDurationConverters() {
        ConverterSet converterSet = this.iDurationConverters;
        Converter[] converterArray = new DurationConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InstantConverter getInstantConverter(Object object) {
        String string2;
        ConverterSet converterSet = this.iInstantConverters;
        Class<?> clazz = object == null ? null : object.getClass();
        InstantConverter instantConverter = (InstantConverter)converterSet.select(clazz);
        if (instantConverter != null) {
            return instantConverter;
        }
        StringBuilder stringBuilder = new StringBuilder().append("No instant converter found for type: ");
        if (object == null) {
            string2 = "null";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public InstantConverter[] getInstantConverters() {
        ConverterSet converterSet = this.iInstantConverters;
        Converter[] converterArray = new InstantConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public IntervalConverter getIntervalConverter(Object object) {
        String string2;
        ConverterSet converterSet = this.iIntervalConverters;
        Class<?> clazz = object == null ? null : object.getClass();
        IntervalConverter intervalConverter = (IntervalConverter)converterSet.select(clazz);
        if (intervalConverter != null) {
            return intervalConverter;
        }
        StringBuilder stringBuilder = new StringBuilder().append("No interval converter found for type: ");
        if (object == null) {
            string2 = "null";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public IntervalConverter[] getIntervalConverters() {
        ConverterSet converterSet = this.iIntervalConverters;
        Converter[] converterArray = new IntervalConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PartialConverter getPartialConverter(Object object) {
        String string2;
        ConverterSet converterSet = this.iPartialConverters;
        Class<?> clazz = object == null ? null : object.getClass();
        PartialConverter partialConverter = (PartialConverter)converterSet.select(clazz);
        if (partialConverter != null) {
            return partialConverter;
        }
        StringBuilder stringBuilder = new StringBuilder().append("No partial converter found for type: ");
        if (object == null) {
            string2 = "null";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public PartialConverter[] getPartialConverters() {
        ConverterSet converterSet = this.iPartialConverters;
        Converter[] converterArray = new PartialConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public PeriodConverter getPeriodConverter(Object object) {
        String string2;
        ConverterSet converterSet = this.iPeriodConverters;
        Class<?> clazz = object == null ? null : object.getClass();
        PeriodConverter periodConverter = (PeriodConverter)converterSet.select(clazz);
        if (periodConverter != null) {
            return periodConverter;
        }
        StringBuilder stringBuilder = new StringBuilder().append("No period converter found for type: ");
        if (object == null) {
            string2 = "null";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public PeriodConverter[] getPeriodConverters() {
        ConverterSet converterSet = this.iPeriodConverters;
        Converter[] converterArray = new PeriodConverter[converterSet.size()];
        converterSet.copyInto(converterArray);
        return converterArray;
    }

    public DurationConverter removeDurationConverter(DurationConverter durationConverter) throws SecurityException {
        this.checkAlterDurationConverters();
        if (durationConverter == null) {
            return null;
        }
        Converter[] converterArray = new DurationConverter[1];
        this.iDurationConverters = this.iDurationConverters.remove(durationConverter, converterArray);
        return converterArray[0];
    }

    public InstantConverter removeInstantConverter(InstantConverter instantConverter) throws SecurityException {
        this.checkAlterInstantConverters();
        if (instantConverter == null) {
            return null;
        }
        Converter[] converterArray = new InstantConverter[1];
        this.iInstantConverters = this.iInstantConverters.remove(instantConverter, converterArray);
        return converterArray[0];
    }

    public IntervalConverter removeIntervalConverter(IntervalConverter intervalConverter) throws SecurityException {
        this.checkAlterIntervalConverters();
        if (intervalConverter == null) {
            return null;
        }
        Converter[] converterArray = new IntervalConverter[1];
        this.iIntervalConverters = this.iIntervalConverters.remove(intervalConverter, converterArray);
        return converterArray[0];
    }

    public PartialConverter removePartialConverter(PartialConverter partialConverter) throws SecurityException {
        this.checkAlterPartialConverters();
        if (partialConverter == null) {
            return null;
        }
        Converter[] converterArray = new PartialConverter[1];
        this.iPartialConverters = this.iPartialConverters.remove(partialConverter, converterArray);
        return converterArray[0];
    }

    public PeriodConverter removePeriodConverter(PeriodConverter periodConverter) throws SecurityException {
        this.checkAlterPeriodConverters();
        if (periodConverter == null) {
            return null;
        }
        Converter[] converterArray = new PeriodConverter[1];
        this.iPeriodConverters = this.iPeriodConverters.remove(periodConverter, converterArray);
        return converterArray[0];
    }

    public String toString() {
        return "ConverterManager[" + this.iInstantConverters.size() + " instant," + this.iPartialConverters.size() + " partial," + this.iDurationConverters.size() + " duration," + this.iPeriodConverters.size() + " period," + this.iIntervalConverters.size() + " interval]";
    }
}

