/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.Converter;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractConverter
implements Converter {
    protected AbstractConverter() {
    }

    public Chronology getChronology(Object object, Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    public Chronology getChronology(Object object, DateTimeZone dateTimeZone) {
        return ISOChronology.getInstance(dateTimeZone);
    }

    public long getInstantMillis(Object object, Chronology chronology) {
        return DateTimeUtils.currentTimeMillis();
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology) {
        return chronology.get(readablePartial, this.getInstantMillis(object, chronology));
    }

    public int[] getPartialValues(ReadablePartial readablePartial, Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        return this.getPartialValues(readablePartial, object, chronology);
    }

    public PeriodType getPeriodType(Object object) {
        return PeriodType.standard();
    }

    public boolean isReadableInterval(Object object, Chronology chronology) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("Converter[");
        if (this.getSupportedType() == null) {
            string2 = "null";
            return stringBuilder.append(string2).append("]").toString();
        }
        string2 = this.getSupportedType().getName();
        return stringBuilder.append(string2).append("]").toString();
    }
}

