/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.IllegalInstantException;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.BaseDurationField;

public final class ZonedChronology
extends AssembledChronology {
    private static final long serialVersionUID = -1079258847191166848L;

    private ZonedChronology(Chronology chronology, DateTimeZone dateTimeZone) {
        super(chronology, dateTimeZone);
    }

    private DateTimeField convertField(DateTimeField dateTimeField, HashMap<Object, Object> hashMap) {
        if (dateTimeField == null || !dateTimeField.isSupported()) {
            return dateTimeField;
        }
        if (hashMap.containsKey(dateTimeField)) {
            return (DateTimeField)hashMap.get(dateTimeField);
        }
        ZonedDateTimeField zonedDateTimeField = new ZonedDateTimeField(dateTimeField, this.getZone(), this.convertField(dateTimeField.getDurationField(), hashMap), this.convertField(dateTimeField.getRangeDurationField(), hashMap), this.convertField(dateTimeField.getLeapDurationField(), hashMap));
        hashMap.put(dateTimeField, zonedDateTimeField);
        return zonedDateTimeField;
    }

    private DurationField convertField(DurationField durationField, HashMap<Object, Object> hashMap) {
        if (durationField == null || !durationField.isSupported()) {
            return durationField;
        }
        if (hashMap.containsKey(durationField)) {
            return (DurationField)hashMap.get(durationField);
        }
        ZonedDurationField zonedDurationField = new ZonedDurationField(durationField, this.getZone());
        hashMap.put(durationField, zonedDurationField);
        return zonedDurationField;
    }

    public static ZonedChronology getInstance(Chronology chronology, DateTimeZone dateTimeZone) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        Chronology chronology2 = chronology.withUTC();
        if (chronology2 == null) {
            throw new IllegalArgumentException("UTC chronology must not be null");
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("DateTimeZone must not be null");
        }
        return new ZonedChronology(chronology2, dateTimeZone);
    }

    private long localToUTC(long l2) {
        long l3;
        DateTimeZone dateTimeZone = this.getZone();
        int n2 = dateTimeZone.getOffsetFromLocal(l2);
        if (n2 != dateTimeZone.getOffset(l3 = l2 - (long)n2)) {
            throw new IllegalInstantException(l3, dateTimeZone.getID());
        }
        return l3;
    }

    static boolean useTimeArithmetic(DurationField durationField) {
        return durationField != null && durationField.getUnitMillis() < 43200000L;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, hashMap);
        fields.centuries = this.convertField(fields.centuries, hashMap);
        fields.years = this.convertField(fields.years, hashMap);
        fields.months = this.convertField(fields.months, hashMap);
        fields.weekyears = this.convertField(fields.weekyears, hashMap);
        fields.weeks = this.convertField(fields.weeks, hashMap);
        fields.days = this.convertField(fields.days, hashMap);
        fields.halfdays = this.convertField(fields.halfdays, hashMap);
        fields.hours = this.convertField(fields.hours, hashMap);
        fields.minutes = this.convertField(fields.minutes, hashMap);
        fields.seconds = this.convertField(fields.seconds, hashMap);
        fields.millis = this.convertField(fields.millis, hashMap);
        fields.year = this.convertField(fields.year, hashMap);
        fields.yearOfEra = this.convertField(fields.yearOfEra, hashMap);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, hashMap);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, hashMap);
        fields.era = this.convertField(fields.era, hashMap);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, hashMap);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, hashMap);
        fields.dayOfYear = this.convertField(fields.dayOfYear, hashMap);
        fields.monthOfYear = this.convertField(fields.monthOfYear, hashMap);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, hashMap);
        fields.weekyear = this.convertField(fields.weekyear, hashMap);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, hashMap);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, hashMap);
        fields.millisOfDay = this.convertField(fields.millisOfDay, hashMap);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, hashMap);
        fields.secondOfDay = this.convertField(fields.secondOfDay, hashMap);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, hashMap);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, hashMap);
        fields.hourOfDay = this.convertField(fields.hourOfDay, hashMap);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, hashMap);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, hashMap);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, hashMap);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, hashMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof ZonedChronology)) {
                    return false;
                }
                ZonedChronology zonedChronology = (ZonedChronology)object;
                if (!this.getBase().equals(zonedChronology.getBase()) || !this.getZone().equals(zonedChronology.getZone())) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(n2, n3, n4, n5));
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8));
    }

    @Override
    public long getDateTimeMillis(long l2, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        return this.localToUTC(this.getBase().getDateTimeMillis(l2 + (long)this.getZone().getOffset(l2), n2, n3, n4, n5));
    }

    @Override
    public DateTimeZone getZone() {
        return (DateTimeZone)this.getParam();
    }

    public int hashCode() {
        return 326565 + 11 * this.getZone().hashCode() + 7 * this.getBase().hashCode();
    }

    @Override
    public String toString() {
        return "ZonedChronology[" + this.getBase() + ", " + this.getZone().getID() + ']';
    }

    @Override
    public Chronology withUTC() {
        return this.getBase();
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getParam()) {
            return this;
        }
        if (dateTimeZone == DateTimeZone.UTC) {
            return this.getBase();
        }
        return new ZonedChronology(this.getBase(), dateTimeZone);
    }

    static final class ZonedDateTimeField
    extends BaseDateTimeField {
        private static final long serialVersionUID = -3968986277775529794L;
        final DurationField iDurationField;
        final DateTimeField iField;
        final DurationField iLeapDurationField;
        final DurationField iRangeDurationField;
        final boolean iTimeField;
        final DateTimeZone iZone;

        ZonedDateTimeField(DateTimeField dateTimeField, DateTimeZone dateTimeZone, DurationField durationField, DurationField durationField2, DurationField durationField3) {
            super(dateTimeField.getType());
            if (!dateTimeField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = dateTimeField;
            this.iZone = dateTimeZone;
            this.iDurationField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iRangeDurationField = durationField2;
            this.iLeapDurationField = durationField3;
        }

        private int getOffsetToAdd(long l2) {
            int n2 = this.iZone.getOffset(l2);
            if ((l2 ^ l2 + (long)n2) < 0L && (l2 ^ (long)n2) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n2;
        }

        @Override
        public long add(long l2, int n2) {
            if (this.iTimeField) {
                int n3 = this.getOffsetToAdd(l2);
                return this.iField.add(l2 + (long)n3, n2) - (long)n3;
            }
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.add(l3, n2);
            return this.iZone.convertLocalToUTC(l4, false, l2);
        }

        @Override
        public long add(long l2, long l3) {
            if (this.iTimeField) {
                int n2 = this.getOffsetToAdd(l2);
                return this.iField.add(l2 + (long)n2, l3) - (long)n2;
            }
            long l4 = this.iZone.convertUTCToLocal(l2);
            long l5 = this.iField.add(l4, l3);
            return this.iZone.convertLocalToUTC(l5, false, l2);
        }

        @Override
        public long addWrapField(long l2, int n2) {
            if (this.iTimeField) {
                int n3 = this.getOffsetToAdd(l2);
                return this.iField.addWrapField(l2 + (long)n3, n2) - (long)n3;
            }
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.addWrapField(l3, n2);
            return this.iZone.convertLocalToUTC(l4, false, l2);
        }

        @Override
        public int get(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.get(l3);
        }

        @Override
        public String getAsShortText(int n2, Locale locale) {
            return this.iField.getAsShortText(n2, locale);
        }

        @Override
        public String getAsShortText(long l2, Locale locale) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.getAsShortText(l3, locale);
        }

        @Override
        public String getAsText(int n2, Locale locale) {
            return this.iField.getAsText(n2, locale);
        }

        @Override
        public String getAsText(long l2, Locale locale) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.getAsText(l3, locale);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getDifference(long l2, long l3) {
            int n2;
            int n3 = this.getOffsetToAdd(l3);
            DateTimeField dateTimeField = this.iField;
            if (this.iTimeField) {
                n2 = n3;
                return dateTimeField.getDifference(l2 + (long)n2, l3 + (long)n3);
            }
            n2 = this.getOffsetToAdd(l2);
            return dateTimeField.getDifference(l2 + (long)n2, l3 + (long)n3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            int n2;
            int n3 = this.getOffsetToAdd(l3);
            DateTimeField dateTimeField = this.iField;
            if (this.iTimeField) {
                n2 = n3;
                return dateTimeField.getDifferenceAsLong(l2 + (long)n2, l3 + (long)n3);
            }
            n2 = this.getOffsetToAdd(l2);
            return dateTimeField.getDifferenceAsLong(l2 + (long)n2, l3 + (long)n3);
        }

        @Override
        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        @Override
        public int getLeapAmount(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.getLeapAmount(l3);
        }

        @Override
        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        @Override
        public int getMaximumShortTextLength(Locale locale) {
            return this.iField.getMaximumShortTextLength(locale);
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return this.iField.getMaximumTextLength(locale);
        }

        @Override
        public int getMaximumValue() {
            return this.iField.getMaximumValue();
        }

        @Override
        public int getMaximumValue(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.getMaximumValue(l3);
        }

        @Override
        public int getMaximumValue(ReadablePartial readablePartial) {
            return this.iField.getMaximumValue(readablePartial);
        }

        @Override
        public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
            return this.iField.getMaximumValue(readablePartial, nArray);
        }

        @Override
        public int getMinimumValue() {
            return this.iField.getMinimumValue();
        }

        @Override
        public int getMinimumValue(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.getMinimumValue(l3);
        }

        @Override
        public int getMinimumValue(ReadablePartial readablePartial) {
            return this.iField.getMinimumValue(readablePartial);
        }

        @Override
        public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
            return this.iField.getMinimumValue(readablePartial, nArray);
        }

        @Override
        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        @Override
        public boolean isLeap(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.isLeap(l3);
        }

        @Override
        public boolean isLenient() {
            return this.iField.isLenient();
        }

        @Override
        public long remainder(long l2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            return this.iField.remainder(l3);
        }

        @Override
        public long roundCeiling(long l2) {
            if (this.iTimeField) {
                int n2 = this.getOffsetToAdd(l2);
                return this.iField.roundCeiling(l2 + (long)n2) - (long)n2;
            }
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.roundCeiling(l3);
            return this.iZone.convertLocalToUTC(l4, false, l2);
        }

        @Override
        public long roundFloor(long l2) {
            if (this.iTimeField) {
                int n2 = this.getOffsetToAdd(l2);
                return this.iField.roundFloor(l2 + (long)n2) - (long)n2;
            }
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.roundFloor(l3);
            return this.iZone.convertLocalToUTC(l4, false, l2);
        }

        @Override
        public long set(long l2, int n2) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.set(l3, n2);
            long l5 = this.iZone.convertLocalToUTC(l4, false, l2);
            if (this.get(l5) != n2) {
                IllegalInstantException illegalInstantException = new IllegalInstantException(l4, this.iZone.getID());
                IllegalFieldValueException illegalFieldValueException = new IllegalFieldValueException(this.iField.getType(), n2, illegalInstantException.getMessage());
                illegalFieldValueException.initCause(illegalInstantException);
                throw illegalFieldValueException;
            }
            return l5;
        }

        @Override
        public long set(long l2, String string2, Locale locale) {
            long l3 = this.iZone.convertUTCToLocal(l2);
            long l4 = this.iField.set(l3, string2, locale);
            return this.iZone.convertLocalToUTC(l4, false, l2);
        }
    }

    static class ZonedDurationField
    extends BaseDurationField {
        private static final long serialVersionUID = -485345310999208286L;
        final DurationField iField;
        final boolean iTimeField;
        final DateTimeZone iZone;

        ZonedDurationField(DurationField durationField, DateTimeZone dateTimeZone) {
            super(durationField.getType());
            if (!durationField.isSupported()) {
                throw new IllegalArgumentException();
            }
            this.iField = durationField;
            this.iTimeField = ZonedChronology.useTimeArithmetic(durationField);
            this.iZone = dateTimeZone;
        }

        private long addOffset(long l2) {
            return this.iZone.convertUTCToLocal(l2);
        }

        private int getOffsetFromLocalToSubtract(long l2) {
            int n2 = this.iZone.getOffsetFromLocal(l2);
            if ((l2 ^ l2 - (long)n2) < 0L && (l2 ^ (long)n2) < 0L) {
                throw new ArithmeticException("Subtracting time zone offset caused overflow");
            }
            return n2;
        }

        private int getOffsetToAdd(long l2) {
            int n2 = this.iZone.getOffset(l2);
            if ((l2 ^ l2 + (long)n2) < 0L && (l2 ^ (long)n2) >= 0L) {
                throw new ArithmeticException("Adding time zone offset caused overflow");
            }
            return n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long add(long l2, int n2) {
            int n3 = this.getOffsetToAdd(l2);
            long l3 = this.iField.add(l2 + (long)n3, n2);
            if (this.iTimeField) {
                return l3 - (long)n3;
            }
            n3 = this.getOffsetFromLocalToSubtract(l3);
            return l3 - (long)n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long add(long l2, long l3) {
            int n2 = this.getOffsetToAdd(l2);
            long l4 = this.iField.add(l2 + (long)n2, l3);
            if (this.iTimeField) {
                return l4 - (long)n2;
            }
            n2 = this.getOffsetFromLocalToSubtract(l4);
            return l4 - (long)n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getDifference(long l2, long l3) {
            int n2;
            int n3 = this.getOffsetToAdd(l3);
            DurationField durationField = this.iField;
            if (this.iTimeField) {
                n2 = n3;
                return durationField.getDifference(l2 + (long)n2, l3 + (long)n3);
            }
            n2 = this.getOffsetToAdd(l2);
            return durationField.getDifference(l2 + (long)n2, l3 + (long)n3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            int n2;
            int n3 = this.getOffsetToAdd(l3);
            DurationField durationField = this.iField;
            if (this.iTimeField) {
                n2 = n3;
                return durationField.getDifferenceAsLong(l2 + (long)n2, l3 + (long)n3);
            }
            n2 = this.getOffsetToAdd(l2);
            return durationField.getDifferenceAsLong(l2 + (long)n2, l3 + (long)n3);
        }

        @Override
        public long getMillis(int n2, long l2) {
            return this.iField.getMillis(n2, this.addOffset(l2));
        }

        @Override
        public long getMillis(long l2, long l3) {
            return this.iField.getMillis(l2, this.addOffset(l3));
        }

        @Override
        public long getUnitMillis() {
            return this.iField.getUnitMillis();
        }

        @Override
        public int getValue(long l2, long l3) {
            return this.iField.getValue(l2, this.addOffset(l3));
        }

        @Override
        public long getValueAsLong(long l2, long l3) {
            return this.iField.getValueAsLong(l2, this.addOffset(l3));
        }

        @Override
        public boolean isPrecise() {
            if (this.iTimeField) {
                return this.iField.isPrecise();
            }
            return this.iField.isPrecise() && this.iZone.isFixed();
        }
    }
}

