/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LimitChronology
extends AssembledChronology {
    private static final long serialVersionUID = 7670866536893052522L;
    final DateTime iLowerLimit;
    final DateTime iUpperLimit;
    private transient LimitChronology iWithUTC;

    private LimitChronology(Chronology chronology, DateTime dateTime, DateTime dateTime2) {
        super(chronology, null);
        this.iLowerLimit = dateTime;
        this.iUpperLimit = dateTime2;
    }

    private DateTimeField convertField(DateTimeField dateTimeField, HashMap<Object, Object> hashMap) {
        if (dateTimeField == null || !dateTimeField.isSupported()) {
            return dateTimeField;
        }
        if (hashMap.containsKey(dateTimeField)) {
            return (DateTimeField)hashMap.get(dateTimeField);
        }
        LimitDateTimeField limitDateTimeField = new LimitDateTimeField(dateTimeField, this.convertField(dateTimeField.getDurationField(), hashMap), this.convertField(dateTimeField.getRangeDurationField(), hashMap), this.convertField(dateTimeField.getLeapDurationField(), hashMap));
        hashMap.put(dateTimeField, limitDateTimeField);
        return limitDateTimeField;
    }

    private DurationField convertField(DurationField durationField, HashMap<Object, Object> hashMap) {
        if (durationField == null || !durationField.isSupported()) {
            return durationField;
        }
        if (hashMap.containsKey(durationField)) {
            return (DurationField)hashMap.get(durationField);
        }
        LimitDurationField limitDurationField = new LimitDurationField(durationField);
        hashMap.put(durationField, limitDurationField);
        return limitDurationField;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LimitChronology getInstance(Chronology chronology, ReadableDateTime readableDateTime, ReadableDateTime readableDateTime2) {
        if (chronology == null) {
            throw new IllegalArgumentException("Must supply a chronology");
        }
        DateTime dateTime = readableDateTime == null ? null : readableDateTime.toDateTime();
        DateTime dateTime2 = null;
        if (readableDateTime2 != null) {
            dateTime2 = readableDateTime2.toDateTime();
        }
        if (dateTime != null && dateTime2 != null && !dateTime.isBefore(dateTime2)) {
            throw new IllegalArgumentException("The lower limit must be come before than the upper limit");
        }
        return new LimitChronology(chronology, dateTime, dateTime2);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        fields.eras = this.convertField(fields.eras, hashMap);
        fields.centuries = this.convertField(fields.centuries, hashMap);
        fields.years = this.convertField(fields.years, hashMap);
        fields.months = this.convertField(fields.months, hashMap);
        fields.weekyears = this.convertField(fields.weekyears, hashMap);
        fields.weeks = this.convertField(fields.weeks, hashMap);
        fields.days = this.convertField(fields.days, hashMap);
        fields.halfdays = this.convertField(fields.halfdays, hashMap);
        fields.hours = this.convertField(fields.hours, hashMap);
        fields.minutes = this.convertField(fields.minutes, hashMap);
        fields.seconds = this.convertField(fields.seconds, hashMap);
        fields.millis = this.convertField(fields.millis, hashMap);
        fields.year = this.convertField(fields.year, hashMap);
        fields.yearOfEra = this.convertField(fields.yearOfEra, hashMap);
        fields.yearOfCentury = this.convertField(fields.yearOfCentury, hashMap);
        fields.centuryOfEra = this.convertField(fields.centuryOfEra, hashMap);
        fields.era = this.convertField(fields.era, hashMap);
        fields.dayOfWeek = this.convertField(fields.dayOfWeek, hashMap);
        fields.dayOfMonth = this.convertField(fields.dayOfMonth, hashMap);
        fields.dayOfYear = this.convertField(fields.dayOfYear, hashMap);
        fields.monthOfYear = this.convertField(fields.monthOfYear, hashMap);
        fields.weekOfWeekyear = this.convertField(fields.weekOfWeekyear, hashMap);
        fields.weekyear = this.convertField(fields.weekyear, hashMap);
        fields.weekyearOfCentury = this.convertField(fields.weekyearOfCentury, hashMap);
        fields.millisOfSecond = this.convertField(fields.millisOfSecond, hashMap);
        fields.millisOfDay = this.convertField(fields.millisOfDay, hashMap);
        fields.secondOfMinute = this.convertField(fields.secondOfMinute, hashMap);
        fields.secondOfDay = this.convertField(fields.secondOfDay, hashMap);
        fields.minuteOfHour = this.convertField(fields.minuteOfHour, hashMap);
        fields.minuteOfDay = this.convertField(fields.minuteOfDay, hashMap);
        fields.hourOfDay = this.convertField(fields.hourOfDay, hashMap);
        fields.hourOfHalfday = this.convertField(fields.hourOfHalfday, hashMap);
        fields.clockhourOfDay = this.convertField(fields.clockhourOfDay, hashMap);
        fields.clockhourOfHalfday = this.convertField(fields.clockhourOfHalfday, hashMap);
        fields.halfdayOfDay = this.convertField(fields.halfdayOfDay, hashMap);
    }

    void checkLimits(long l2, String string2) {
        DateTime dateTime = this.iLowerLimit;
        if (dateTime != null && l2 < dateTime.getMillis()) {
            throw new LimitException(string2, true);
        }
        DateTime dateTime2 = this.iUpperLimit;
        if (dateTime2 != null && l2 >= dateTime2.getMillis()) {
            throw new LimitException(string2, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof LimitChronology)) {
                    return false;
                }
                LimitChronology limitChronology = (LimitChronology)object;
                if (!this.getBase().equals(limitChronology.getBase()) || !FieldUtils.equals(this.getLowerLimit(), limitChronology.getLowerLimit()) || !FieldUtils.equals(this.getUpperLimit(), limitChronology.getUpperLimit())) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        long l2 = this.getBase().getDateTimeMillis(n2, n3, n4, n5);
        this.checkLimits(l2, "resulting");
        return l2;
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        long l2 = this.getBase().getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
        this.checkLimits(l2, "resulting");
        return l2;
    }

    @Override
    public long getDateTimeMillis(long l2, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        this.checkLimits(l2, null);
        long l3 = this.getBase().getDateTimeMillis(l2, n2, n3, n4, n5);
        this.checkLimits(l3, "resulting");
        return l3;
    }

    public DateTime getLowerLimit() {
        return this.iLowerLimit;
    }

    public DateTime getUpperLimit() {
        return this.iUpperLimit;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = this.getLowerLimit() != null ? this.getLowerLimit().hashCode() : 0;
        int n3 = n2 + 317351877;
        DateTime dateTime = this.getUpperLimit();
        int n4 = 0;
        if (dateTime != null) {
            n4 = this.getUpperLimit().hashCode();
        }
        return n3 + n4 + 7 * this.getBase().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder().append("LimitChronology[").append(this.getBase().toString()).append(", ");
        String string3 = this.getLowerLimit() == null ? "NoLimit" : this.getLowerLimit().toString();
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append(", ");
        if (this.getUpperLimit() == null) {
            string2 = "NoLimit";
            return stringBuilder2.append(string2).append(']').toString();
        }
        string2 = this.getUpperLimit().toString();
        return stringBuilder2.append(string2).append(']').toString();
    }

    @Override
    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        DateTime dateTime;
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        if (dateTimeZone == DateTimeZone.UTC && this.iWithUTC != null) {
            return this.iWithUTC;
        }
        DateTime dateTime2 = this.iLowerLimit;
        if (dateTime2 != null) {
            MutableDateTime mutableDateTime = dateTime2.toMutableDateTime();
            mutableDateTime.setZoneRetainFields(dateTimeZone);
            dateTime2 = mutableDateTime.toDateTime();
        }
        if ((dateTime = this.iUpperLimit) != null) {
            MutableDateTime mutableDateTime = dateTime.toMutableDateTime();
            mutableDateTime.setZoneRetainFields(dateTimeZone);
            dateTime = mutableDateTime.toDateTime();
        }
        LimitChronology limitChronology = LimitChronology.getInstance(this.getBase().withZone(dateTimeZone), dateTime2, dateTime);
        if (dateTimeZone == DateTimeZone.UTC) {
            this.iWithUTC = limitChronology;
        }
        return limitChronology;
    }

    private class LimitDateTimeField
    extends DecoratedDateTimeField {
        private static final long serialVersionUID = -2435306746995699312L;
        private final DurationField iDurationField;
        private final DurationField iLeapDurationField;
        private final DurationField iRangeDurationField;

        LimitDateTimeField(DateTimeField dateTimeField, DurationField durationField, DurationField durationField2, DurationField durationField3) {
            super(dateTimeField, dateTimeField.getType());
            this.iDurationField = durationField;
            this.iRangeDurationField = durationField2;
            this.iLeapDurationField = durationField3;
        }

        @Override
        public long add(long l2, int n2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().add(l2, n2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long add(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, null);
            long l4 = this.getWrappedField().add(l2, l3);
            LimitChronology.this.checkLimits(l4, "resulting");
            return l4;
        }

        @Override
        public long addWrapField(long l2, int n2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().addWrapField(l2, n2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public int get(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().get(l2);
        }

        @Override
        public String getAsShortText(long l2, Locale locale) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getAsShortText(l2, locale);
        }

        @Override
        public String getAsText(long l2, Locale locale) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getAsText(l2, locale);
        }

        @Override
        public int getDifference(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, "minuend");
            LimitChronology.this.checkLimits(l3, "subtrahend");
            return this.getWrappedField().getDifference(l2, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, "minuend");
            LimitChronology.this.checkLimits(l3, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(l2, l3);
        }

        @Override
        public final DurationField getDurationField() {
            return this.iDurationField;
        }

        @Override
        public int getLeapAmount(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getLeapAmount(l2);
        }

        @Override
        public final DurationField getLeapDurationField() {
            return this.iLeapDurationField;
        }

        @Override
        public int getMaximumShortTextLength(Locale locale) {
            return this.getWrappedField().getMaximumShortTextLength(locale);
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return this.getWrappedField().getMaximumTextLength(locale);
        }

        @Override
        public int getMaximumValue(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getMaximumValue(l2);
        }

        @Override
        public int getMinimumValue(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getMinimumValue(l2);
        }

        @Override
        public final DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        @Override
        public boolean isLeap(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().isLeap(l2);
        }

        @Override
        public long remainder(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().remainder(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long roundCeiling(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().roundCeiling(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long roundFloor(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().roundFloor(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long roundHalfCeiling(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().roundHalfCeiling(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long roundHalfEven(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().roundHalfEven(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long roundHalfFloor(long l2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().roundHalfFloor(l2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long set(long l2, int n2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().set(l2, n2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long set(long l2, String string2, Locale locale) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().set(l2, string2, locale);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }
    }

    private class LimitDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 8049297699408782284L;

        LimitDurationField(DurationField durationField) {
            super(durationField, durationField.getType());
        }

        @Override
        public long add(long l2, int n2) {
            LimitChronology.this.checkLimits(l2, null);
            long l3 = this.getWrappedField().add(l2, n2);
            LimitChronology.this.checkLimits(l3, "resulting");
            return l3;
        }

        @Override
        public long add(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, null);
            long l4 = this.getWrappedField().add(l2, l3);
            LimitChronology.this.checkLimits(l4, "resulting");
            return l4;
        }

        @Override
        public int getDifference(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, "minuend");
            LimitChronology.this.checkLimits(l3, "subtrahend");
            return this.getWrappedField().getDifference(l2, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            LimitChronology.this.checkLimits(l2, "minuend");
            LimitChronology.this.checkLimits(l3, "subtrahend");
            return this.getWrappedField().getDifferenceAsLong(l2, l3);
        }

        @Override
        public long getMillis(int n2, long l2) {
            LimitChronology.this.checkLimits(l2, null);
            return this.getWrappedField().getMillis(n2, l2);
        }

        @Override
        public long getMillis(long l2, long l3) {
            LimitChronology.this.checkLimits(l3, null);
            return this.getWrappedField().getMillis(l2, l3);
        }

        @Override
        public int getValue(long l2, long l3) {
            LimitChronology.this.checkLimits(l3, null);
            return this.getWrappedField().getValue(l2, l3);
        }

        @Override
        public long getValueAsLong(long l2, long l3) {
            LimitChronology.this.checkLimits(l3, null);
            return this.getWrappedField().getValueAsLong(l2, l3);
        }
    }

    private class LimitException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -5924689995607498581L;
        private final boolean iIsLow;

        LimitException(String string2, boolean bl2) {
            super(string2);
            this.iIsLow = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer(85);
            stringBuffer.append("The");
            String string2 = super.getMessage();
            if (string2 != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string2);
            }
            stringBuffer.append(" instant is ");
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withChronology(LimitChronology.this.getBase());
            if (this.iIsLow) {
                stringBuffer.append("below the supported minimum of ");
                dateTimeFormatter.printTo(stringBuffer, LimitChronology.this.getLowerLimit().getMillis());
            } else {
                stringBuffer.append("above the supported maximum of ");
                dateTimeFormatter.printTo(stringBuffer, LimitChronology.this.getUpperLimit().getMillis());
            }
            stringBuffer.append(" (");
            stringBuffer.append(LimitChronology.this.getBase());
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        @Override
        public String toString() {
            return "IllegalArgumentException: " + this.getMessage();
        }
    }
}

