/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class JulianChronology
extends BasicGJChronology {
    private static final JulianChronology INSTANCE_UTC;
    private static final int MAX_YEAR = 292272992;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final int MIN_YEAR = -292269054;
    private static final Map<DateTimeZone, JulianChronology[]> cCache;
    private static final long serialVersionUID = -8731039522547897247L;

    static {
        cCache = new HashMap<DateTimeZone, JulianChronology[]>();
        INSTANCE_UTC = JulianChronology.getInstance(DateTimeZone.UTC);
    }

    JulianChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    static int adjustYearForSet(int n2) {
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IllegalFieldValueException(DateTimeFieldType.year(), (Number)n2, null, null);
            }
            ++n2;
        }
        return n2;
    }

    public static JulianChronology getInstance() {
        return JulianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static JulianChronology getInstance(DateTimeZone dateTimeZone) {
        return JulianChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JulianChronology getInstance(DateTimeZone dateTimeZone, int n2) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, JulianChronology[]> map = cCache;
        synchronized (map) {
            JulianChronology julianChronology;
            block9: {
                JulianChronology[] julianChronologyArray = cCache.get(dateTimeZone);
                if (julianChronologyArray == null) {
                    julianChronologyArray = new JulianChronology[7];
                    cCache.put(dateTimeZone, julianChronologyArray);
                }
                JulianChronology[] julianChronologyArray2 = julianChronologyArray;
                int n3 = n2 - 1;
                try {
                    julianChronology = julianChronologyArray2[n3];
                    if (julianChronology == null) {
                        julianChronology = dateTimeZone == DateTimeZone.UTC ? new JulianChronology(null, null, n2) : new JulianChronology(ZonedChronology.getInstance(JulianChronology.getInstance(DateTimeZone.UTC, n2), dateTimeZone), null, n2);
                    }
                    break block9;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid min days in first week: " + n2);
                }
                julianChronologyArray2[n2 - 1] = julianChronology;
            }
            return julianChronology;
        }
    }

    public static JulianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        int n2 = this.getMinimumDaysInFirstWeek();
        if (n2 == 0) {
            n2 = 4;
        }
        if (chronology == null) {
            return JulianChronology.getInstance(DateTimeZone.UTC, n2);
        }
        return JulianChronology.getInstance(chronology.getZone(), n2);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long calculateFirstDayOfYearMillis(int n2) {
        int n3;
        int n4 = n2 - 1968;
        if (n4 <= 0) {
            n3 = n4 + 3 >> 2;
            return 86400000L * (365L * (long)n4 + (long)n3) - 62035200000L;
        }
        n3 = n4 >> 2;
        if (this.isLeapYear(n2)) return 86400000L * (365L * (long)n4 + (long)n3) - 62035200000L;
        return 86400000L * (365L * (long)n4 + (long)(++n3)) - 62035200000L;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 31083663600000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    @Override
    long getDateMidnightMillis(int n2, int n3, int n4) throws IllegalArgumentException {
        return super.getDateMidnightMillis(JulianChronology.adjustYearForSet(n2), n3, n4);
    }

    @Override
    int getMaxYear() {
        return 292272992;
    }

    @Override
    int getMinYear() {
        return -292269054;
    }

    @Override
    boolean isLeapYear(int n2) {
        return (n2 & 3) == 0;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return JulianChronology.getInstance(dateTimeZone);
    }
}

