/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;

public final class IslamicChronology
extends BasicChronology {
    public static final int AH = 1;
    private static final int CYCLE = 30;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("AH");
    private static final IslamicChronology INSTANCE_UTC;
    public static final LeapYearPatternType LEAP_YEAR_15_BASED;
    public static final LeapYearPatternType LEAP_YEAR_16_BASED;
    public static final LeapYearPatternType LEAP_YEAR_HABASH_AL_HASIB;
    public static final LeapYearPatternType LEAP_YEAR_INDIAN;
    private static final int LONG_MONTH_LENGTH = 30;
    private static final int MAX_YEAR = 292271022;
    private static final long MILLIS_PER_CYCLE = 918518400000L;
    private static final long MILLIS_PER_LONG_MONTH = 2592000000L;
    private static final long MILLIS_PER_LONG_YEAR = 30672000000L;
    private static final long MILLIS_PER_MONTH = 2551440384L;
    private static final long MILLIS_PER_MONTH_PAIR = 5097600000L;
    private static final long MILLIS_PER_SHORT_YEAR = 30585600000L;
    private static final long MILLIS_PER_YEAR = 30617280288L;
    private static final long MILLIS_YEAR_1 = -42521587200000L;
    private static final int MIN_YEAR = -292269337;
    private static final int MONTH_PAIR_LENGTH = 59;
    private static final int SHORT_MONTH_LENGTH = 29;
    private static final Map<DateTimeZone, IslamicChronology[]> cCache;
    private static final long serialVersionUID = -3663823829888L;
    private final LeapYearPatternType iLeapYears;

    static {
        LEAP_YEAR_15_BASED = new LeapYearPatternType(0, 623158436);
        LEAP_YEAR_16_BASED = new LeapYearPatternType(1, 623191204);
        LEAP_YEAR_INDIAN = new LeapYearPatternType(2, 690562340);
        LEAP_YEAR_HABASH_AL_HASIB = new LeapYearPatternType(3, 0x9292925);
        cCache = new HashMap<DateTimeZone, IslamicChronology[]>();
        INSTANCE_UTC = IslamicChronology.getInstance(DateTimeZone.UTC);
    }

    IslamicChronology(Chronology chronology, Object object, LeapYearPatternType leapYearPatternType) {
        super(chronology, object, 4);
        this.iLeapYears = leapYearPatternType;
    }

    public static IslamicChronology getInstance() {
        return IslamicChronology.getInstance(DateTimeZone.getDefault(), LEAP_YEAR_16_BASED);
    }

    public static IslamicChronology getInstance(DateTimeZone dateTimeZone) {
        return IslamicChronology.getInstance(dateTimeZone, LEAP_YEAR_16_BASED);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IslamicChronology getInstance(DateTimeZone dateTimeZone, LeapYearPatternType leapYearPatternType) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, IslamicChronology[]> map = cCache;
        synchronized (map) {
            IslamicChronology[] islamicChronologyArray;
            IslamicChronology islamicChronology;
            IslamicChronology[] islamicChronologyArray2 = cCache.get(dateTimeZone);
            if (islamicChronologyArray2 == null) {
                islamicChronologyArray2 = new IslamicChronology[4];
                cCache.put(dateTimeZone, islamicChronologyArray2);
            }
            if ((islamicChronology = (islamicChronologyArray = islamicChronologyArray2)[leapYearPatternType.index]) == null) {
                if (dateTimeZone == DateTimeZone.UTC) {
                    IslamicChronology islamicChronology2 = new IslamicChronology(null, null, leapYearPatternType);
                    islamicChronology = new IslamicChronology((Chronology)LimitChronology.getInstance(islamicChronology2, new DateTime(1, 1, 1, 0, 0, 0, 0, islamicChronology2), null), null, leapYearPatternType);
                } else {
                    islamicChronology = new IslamicChronology((Chronology)ZonedChronology.getInstance(IslamicChronology.getInstance(DateTimeZone.UTC, leapYearPatternType), dateTimeZone), null, leapYearPatternType);
                }
                islamicChronologyArray[leapYearPatternType.index] = islamicChronology;
            }
            return islamicChronology;
        }
    }

    public static IslamicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        if (chronology == null) {
            return IslamicChronology.getInstanceUTC();
        }
        return IslamicChronology.getInstance(chronology.getZone());
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 12);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long calculateFirstDayOfYearMillis(int n2) {
        if (n2 > 292271022) {
            throw new ArithmeticException("Year is too large: " + n2 + " > " + 292271022);
        }
        if (n2 < -292269337) {
            throw new ArithmeticException("Year is too small: " + n2 + " < " + -292269337);
        }
        int n3 = n2 - 1;
        long l2 = -42521587200000L + 918518400000L * (long)(n3 / 30);
        int n4 = 1 + n3 % 30;
        long l3 = l2;
        int n5 = 1;
        while (n5 < n4) {
            long l4 = this.isLeapYear(n5) ? 30672000000L : 30585600000L;
            l3 += l4;
            ++n5;
        }
        return l3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IslamicChronology)) return false;
        IslamicChronology islamicChronology = (IslamicChronology)object;
        if (this.getLeapYearPatternType().index != islamicChronology.getLeapYearPatternType().index) return false;
        if (!super.equals(object)) return false;
        return true;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 21260793600000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2551440384L;
    }

    @Override
    long getAverageMillisPerYear() {
        return 30617280288L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15308640144L;
    }

    @Override
    int getDayOfMonth(long l2) {
        int n2 = -1 + this.getDayOfYear(l2);
        if (n2 == 354) {
            return 30;
        }
        return 1 + n2 % 59 % 30;
    }

    @Override
    int getDaysInMonthMax() {
        return 30;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int getDaysInMonthMax(int n2) {
        if (n2 == 12 || (n2 - 1) % 2 == 0) {
            return 30;
        }
        return 29;
    }

    @Override
    int getDaysInYear(int n2) {
        if (this.isLeapYear(n2)) {
            return 355;
        }
        return 354;
    }

    @Override
    int getDaysInYearMax() {
        return 355;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int getDaysInYearMonth(int n2, int n3) {
        if (n3 == 12 && this.isLeapYear(n2) || (n3 - 1) % 2 == 0) {
            return 30;
        }
        return 29;
    }

    public LeapYearPatternType getLeapYearPatternType() {
        return this.iLeapYears;
    }

    @Override
    int getMaxYear() {
        return 292271022;
    }

    @Override
    int getMinYear() {
        return 1;
    }

    @Override
    int getMonthOfYear(long l2, int n2) {
        int n3 = (int)((l2 - this.getYearMillis(n2)) / 86400000L);
        if (n3 == 354) {
            return 12;
        }
        return 1 + n3 * 2 / 59;
    }

    @Override
    long getTotalMillisByYearMonth(int n2, int n3) {
        int n4 = n3 - 1;
        if (n4 % 2 == 1) {
            return 2592000000L + 5097600000L * (long)(n4 / 2);
        }
        return 5097600000L * (long)(n4 / 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int getYear(long l2) {
        long l3 = l2 + 42521587200000L;
        long l4 = l3 / 918518400000L;
        long l5 = l3 % 918518400000L;
        int n2 = (int)(1L + 30L * l4);
        long l6 = this.isLeapYear(n2) ? 30672000000L : 30585600000L;
        while (l5 >= l6) {
            l5 -= l6;
            if (this.isLeapYear(++n2)) {
                l6 = 30672000000L;
                continue;
            }
            l6 = 30585600000L;
        }
        return n2;
    }

    @Override
    long getYearDifference(long l2, long l3) {
        int n2 = this.getYear(l2);
        int n3 = this.getYear(l3);
        long l4 = l2 - this.getYearMillis(n2);
        long l5 = l3 - this.getYearMillis(n3);
        int n4 = n2 - n3;
        if (l4 < l5) {
            --n4;
        }
        return n4;
    }

    @Override
    public int hashCode() {
        return 13 * super.hashCode() + this.getLeapYearPatternType().hashCode();
    }

    @Override
    boolean isLeapYear(int n2) {
        return this.iLeapYears.isLeapYear(n2);
    }

    @Override
    long setYear(long l2, int n2) {
        int n3 = this.getDayOfYear(l2, this.getYear(l2));
        int n4 = this.getMillisOfDay(l2);
        if (n3 > 354 && !this.isLeapYear(n2)) {
            --n3;
        }
        return this.getYearMonthDayMillis(n2, 1, n3) + (long)n4;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return IslamicChronology.getInstance(dateTimeZone);
    }

    public static class LeapYearPatternType
    implements Serializable {
        private static final long serialVersionUID = 26581275372698L;
        final byte index;
        final int pattern;

        LeapYearPatternType(int n2, int n3) {
            this.index = (byte)n2;
            this.pattern = n3;
        }

        private Object readResolve() {
            switch (this.index) {
                default: {
                    return this;
                }
                case 0: {
                    return LEAP_YEAR_15_BASED;
                }
                case 1: {
                    return LEAP_YEAR_16_BASED;
                }
                case 2: {
                    return LEAP_YEAR_INDIAN;
                }
                case 3: 
            }
            return LEAP_YEAR_HABASH_AL_HASIB;
        }

        public boolean equals(Object object) {
            boolean bl2 = object instanceof LeapYearPatternType;
            boolean bl3 = false;
            if (bl2) {
                byte by2 = this.index;
                byte by3 = ((LeapYearPatternType)object).index;
                bl3 = false;
                if (by2 == by3) {
                    bl3 = true;
                }
            }
            return bl3;
        }

        public int hashCode() {
            return this.index;
        }

        boolean isLeapYear(int n2) {
            return (1 << n2 % 30 & this.pattern) > 0;
        }
    }
}

