/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicGJChronology;
import org.joda.time.chrono.ZonedChronology;

public final class GregorianChronology
extends BasicGJChronology {
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final GregorianChronology INSTANCE_UTC;
    private static final int MAX_YEAR = 292278993;
    private static final long MILLIS_PER_MONTH = 2629746000L;
    private static final long MILLIS_PER_YEAR = 31556952000L;
    private static final int MIN_YEAR = -292275054;
    private static final Map<DateTimeZone, GregorianChronology[]> cCache;
    private static final long serialVersionUID = -861407383323710522L;

    static {
        cCache = new HashMap<DateTimeZone, GregorianChronology[]>();
        INSTANCE_UTC = GregorianChronology.getInstance(DateTimeZone.UTC);
    }

    private GregorianChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    public static GregorianChronology getInstance() {
        return GregorianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static GregorianChronology getInstance(DateTimeZone dateTimeZone) {
        return GregorianChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GregorianChronology getInstance(DateTimeZone dateTimeZone, int n2) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, GregorianChronology[]> map = cCache;
        synchronized (map) {
            GregorianChronology gregorianChronology;
            block9: {
                GregorianChronology[] gregorianChronologyArray = cCache.get(dateTimeZone);
                if (gregorianChronologyArray == null) {
                    gregorianChronologyArray = new GregorianChronology[7];
                    cCache.put(dateTimeZone, gregorianChronologyArray);
                }
                GregorianChronology[] gregorianChronologyArray2 = gregorianChronologyArray;
                int n3 = n2 - 1;
                try {
                    gregorianChronology = gregorianChronologyArray2[n3];
                    if (gregorianChronology == null) {
                        gregorianChronology = dateTimeZone == DateTimeZone.UTC ? new GregorianChronology(null, null, n2) : new GregorianChronology(ZonedChronology.getInstance(GregorianChronology.getInstance(DateTimeZone.UTC, n2), dateTimeZone), null, n2);
                    }
                    break block9;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid min days in first week: " + n2);
                }
                gregorianChronologyArray2[n2 - 1] = gregorianChronology;
            }
            return gregorianChronology;
        }
    }

    public static GregorianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        int n2 = this.getMinimumDaysInFirstWeek();
        if (n2 == 0) {
            n2 = 4;
        }
        if (chronology == null) {
            return GregorianChronology.getInstance(DateTimeZone.UTC, n2);
        }
        return GregorianChronology.getInstance(chronology.getZone(), n2);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long calculateFirstDayOfYearMillis(int n2) {
        int n3;
        int n4 = n2 / 100;
        if (n2 < 0) {
            n3 = -1 + ((n2 + 3 >> 2) - n4 + (n4 + 3 >> 2));
            return 86400000L * (365L * (long)n2 + (long)(n3 - 719527));
        }
        n3 = (n2 >> 2) - n4 + (n4 >> 2);
        if (!this.isLeapYear(n2)) return 86400000L * (365L * (long)n2 + (long)(n3 - 719527));
        return 86400000L * (365L * (long)n2 + (long)(--n3 - 719527));
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 31083597720000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2629746000L;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31556952000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778476000L;
    }

    @Override
    int getMaxYear() {
        return 292278993;
    }

    @Override
    int getMinYear() {
        return -292275054;
    }

    @Override
    boolean isLeapYear(int n2) {
        return (n2 & 3) == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return GregorianChronology.getInstance(dateTimeZone);
    }
}

