/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.lang.ref.WeakReference;
import java.text.DateFormatSymbols;
import java.util.Locale;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalFieldValueException;

class GJLocaleSymbols {
    private static final int FAST_CACHE_SIZE = 64;
    private static WeakHashMap<Locale, GJLocaleSymbols> cCache;
    private static final GJLocaleSymbols[] cFastCache;
    private final String[] iDaysOfWeek;
    private final String[] iEras;
    private final String[] iHalfday;
    private final WeakReference<Locale> iLocale;
    private final int iMaxDayOfWeekLength;
    private final int iMaxEraLength;
    private final int iMaxHalfdayLength;
    private final int iMaxMonthLength;
    private final int iMaxShortDayOfWeekLength;
    private final int iMaxShortMonthLength;
    private final String[] iMonths;
    private final TreeMap<String, Integer> iParseDaysOfWeek;
    private final TreeMap<String, Integer> iParseEras;
    private final TreeMap<String, Integer> iParseMonths;
    private final String[] iShortDaysOfWeek;
    private final String[] iShortMonths;

    static {
        cFastCache = new GJLocaleSymbols[64];
        cCache = new WeakHashMap();
    }

    private GJLocaleSymbols(Locale locale) {
        this.iLocale = new WeakReference<Locale>(locale);
        DateFormatSymbols dateFormatSymbols = DateTimeUtils.getDateFormatSymbols(locale);
        this.iEras = dateFormatSymbols.getEras();
        this.iDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getWeekdays());
        this.iShortDaysOfWeek = GJLocaleSymbols.realignDaysOfWeek(dateFormatSymbols.getShortWeekdays());
        this.iMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getMonths());
        this.iShortMonths = GJLocaleSymbols.realignMonths(dateFormatSymbols.getShortMonths());
        this.iHalfday = dateFormatSymbols.getAmPmStrings();
        Integer[] integerArray = new Integer[13];
        for (int i2 = 0; i2 < 13; ++i2) {
            integerArray[i2] = i2;
        }
        this.iParseEras = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseEras, this.iEras, integerArray);
        if ("en".equals(locale.getLanguage())) {
            this.iParseEras.put("BCE", integerArray[0]);
            this.iParseEras.put("CE", integerArray[1]);
        }
        this.iParseDaysOfWeek = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iDaysOfWeek, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseDaysOfWeek, this.iShortDaysOfWeek, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseDaysOfWeek, 1, 7, integerArray);
        this.iParseMonths = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iMonths, integerArray);
        GJLocaleSymbols.addSymbols(this.iParseMonths, this.iShortMonths, integerArray);
        GJLocaleSymbols.addNumerals(this.iParseMonths, 1, 12, integerArray);
        this.iMaxEraLength = GJLocaleSymbols.maxLength(this.iEras);
        this.iMaxDayOfWeekLength = GJLocaleSymbols.maxLength(this.iDaysOfWeek);
        this.iMaxShortDayOfWeekLength = GJLocaleSymbols.maxLength(this.iShortDaysOfWeek);
        this.iMaxMonthLength = GJLocaleSymbols.maxLength(this.iMonths);
        this.iMaxShortMonthLength = GJLocaleSymbols.maxLength(this.iShortMonths);
        this.iMaxHalfdayLength = GJLocaleSymbols.maxLength(this.iHalfday);
    }

    private static void addNumerals(TreeMap<String, Integer> treeMap, int n2, int n3, Integer[] integerArray) {
        while (n2 <= n3) {
            treeMap.put(String.valueOf(n2).intern(), integerArray[n2]);
            ++n2;
        }
    }

    private static void addSymbols(TreeMap<String, Integer> treeMap, String[] stringArray, Integer[] integerArray) {
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            String string2 = stringArray[n2];
            if (string2 == null) continue;
            treeMap.put(string2, integerArray[n2]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GJLocaleSymbols forLocale(Locale locale) {
        GJLocaleSymbols gJLocaleSymbols;
        int n2;
        GJLocaleSymbols gJLocaleSymbols2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((gJLocaleSymbols2 = cFastCache[n2 = 0x3F & System.identityHashCode(locale)]) != null && gJLocaleSymbols2.iLocale.get() == locale) {
            return gJLocaleSymbols2;
        }
        WeakHashMap<Locale, GJLocaleSymbols> weakHashMap = cCache;
        synchronized (weakHashMap) {
            gJLocaleSymbols = cCache.get(locale);
            if (gJLocaleSymbols == null) {
                gJLocaleSymbols = new GJLocaleSymbols(locale);
                cCache.put(locale, gJLocaleSymbols);
            }
        }
        GJLocaleSymbols.cFastCache[n2] = gJLocaleSymbols;
        return gJLocaleSymbols;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int maxLength(String[] stringArray) {
        int n2 = 0;
        int n3 = stringArray.length;
        int n4;
        while ((n4 = n3 - 1) >= 0) {
            int n5;
            String string2 = stringArray[n4];
            if (string2 == null || (n5 = string2.length()) <= n2) {
                n5 = n2;
            }
            n2 = n5;
            n3 = n4;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] realignDaysOfWeek(String[] stringArray) {
        String[] stringArray2 = new String[8];
        int n2 = 1;
        while (n2 < 8) {
            int n3 = n2 < 7 ? n2 + 1 : 1;
            stringArray2[n2] = stringArray[n3];
            ++n2;
        }
        return stringArray2;
    }

    private static String[] realignMonths(String[] stringArray) {
        String[] stringArray2 = new String[13];
        for (int i2 = 1; i2 < 13; ++i2) {
            stringArray2[i2] = stringArray[i2 - 1];
        }
        return stringArray2;
    }

    public int dayOfWeekTextToValue(String string2) {
        Integer n2 = this.iParseDaysOfWeek.get(string2);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.dayOfWeek(), string2);
    }

    public String dayOfWeekValueToShortText(int n2) {
        return this.iShortDaysOfWeek[n2];
    }

    public String dayOfWeekValueToText(int n2) {
        return this.iDaysOfWeek[n2];
    }

    public int eraTextToValue(String string2) {
        Integer n2 = this.iParseEras.get(string2);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.era(), string2);
    }

    public String eraValueToText(int n2) {
        return this.iEras[n2];
    }

    public int getDayOfWeekMaxShortTextLength() {
        return this.iMaxShortDayOfWeekLength;
    }

    public int getDayOfWeekMaxTextLength() {
        return this.iMaxDayOfWeekLength;
    }

    public int getEraMaxTextLength() {
        return this.iMaxEraLength;
    }

    public int getHalfdayMaxTextLength() {
        return this.iMaxHalfdayLength;
    }

    public int getMonthMaxShortTextLength() {
        return this.iMaxShortMonthLength;
    }

    public int getMonthMaxTextLength() {
        return this.iMaxMonthLength;
    }

    public int halfdayTextToValue(String string2) {
        String[] stringArray = this.iHalfday;
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            if (!stringArray[n2].equalsIgnoreCase(string2)) continue;
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.halfdayOfDay(), string2);
    }

    public String halfdayValueToText(int n2) {
        return this.iHalfday[n2];
    }

    public int monthOfYearTextToValue(String string2) {
        Integer n2 = this.iParseMonths.get(string2);
        if (n2 != null) {
            return n2;
        }
        throw new IllegalFieldValueException(DateTimeFieldType.monthOfYear(), string2);
    }

    public String monthOfYearValueToShortText(int n2) {
        return this.iShortMonths[n2];
    }

    public String monthOfYearValueToText(int n2) {
        return this.iMonths[n2];
    }
}

