/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDurationField;

final class GJEraDateTimeField
extends BaseDateTimeField {
    private static final long serialVersionUID = 4240986525305515528L;
    private final BasicChronology iChronology;

    GJEraDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.era());
        this.iChronology = basicChronology;
    }

    private Object readResolve() {
        return this.iChronology.era();
    }

    @Override
    public int get(long l2) {
        if (this.iChronology.getYear(l2) <= 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public String getAsText(int n2, Locale locale) {
        return GJLocaleSymbols.forLocale(locale).eraValueToText(n2);
    }

    @Override
    public DurationField getDurationField() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public int getMaximumTextLength(Locale locale) {
        return GJLocaleSymbols.forLocale(locale).getEraMaxTextLength();
    }

    @Override
    public int getMaximumValue() {
        return 1;
    }

    @Override
    public int getMinimumValue() {
        return 0;
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public long roundCeiling(long l2) {
        if (this.get(l2) == 0) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public long roundFloor(long l2) {
        if (this.get(l2) == 1) {
            return this.iChronology.setYear(0L, 1);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long roundHalfCeiling(long l2) {
        return this.roundFloor(l2);
    }

    @Override
    public long roundHalfEven(long l2) {
        return this.roundFloor(l2);
    }

    @Override
    public long roundHalfFloor(long l2) {
        return this.roundFloor(l2);
    }

    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 0, 1);
        if (this.get(l2) != n2) {
            int n3 = this.iChronology.getYear(l2);
            l2 = this.iChronology.setYear(l2, -n3);
        }
        return l2;
    }

    @Override
    public long set(long l2, String string2, Locale locale) {
        return this.set(l2, GJLocaleSymbols.forLocale(locale).eraTextToValue(string2));
    }
}

