/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.BaseDateTimeField;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class GJChronology
extends AssembledChronology {
    static final Instant DEFAULT_CUTOVER = new Instant(-12219292800000L);
    private static final Map<DateTimeZone, ArrayList<GJChronology>> cCache = new HashMap<DateTimeZone, ArrayList<GJChronology>>();
    private static final long serialVersionUID = -2545574827706931671L;
    private Instant iCutoverInstant;
    private long iCutoverMillis;
    private long iGapDuration;
    private GregorianChronology iGregorianChronology;
    private JulianChronology iJulianChronology;

    private GJChronology(Chronology chronology, JulianChronology julianChronology, GregorianChronology gregorianChronology, Instant instant) {
        super(chronology, new Object[]{julianChronology, gregorianChronology, instant});
    }

    private GJChronology(JulianChronology julianChronology, GregorianChronology gregorianChronology, Instant instant) {
        super(null, new Object[]{julianChronology, gregorianChronology, instant});
    }

    private static long convertByWeekyear(long l2, Chronology chronology, Chronology chronology2) {
        long l3 = chronology2.weekyear().set(0L, chronology.weekyear().get(l2));
        long l4 = chronology2.weekOfWeekyear().set(l3, chronology.weekOfWeekyear().get(l2));
        long l5 = chronology2.dayOfWeek().set(l4, chronology.dayOfWeek().get(l2));
        return chronology2.millisOfDay().set(l5, chronology.millisOfDay().get(l2));
    }

    private static long convertByYear(long l2, Chronology chronology, Chronology chronology2) {
        return chronology2.getDateTimeMillis(chronology.year().get(l2), chronology.monthOfYear().get(l2), chronology.dayOfMonth().get(l2), chronology.millisOfDay().get(l2));
    }

    public static GJChronology getInstance() {
        return GJChronology.getInstance(DateTimeZone.getDefault(), DEFAULT_CUTOVER, 4);
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone) {
        return GJChronology.getInstance(dateTimeZone, DEFAULT_CUTOVER, 4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GJChronology getInstance(DateTimeZone dateTimeZone, long l2, int n2) {
        Instant instant;
        if (l2 == DEFAULT_CUTOVER.getMillis()) {
            instant = null;
            return GJChronology.getInstance(dateTimeZone, instant, n2);
        }
        instant = new Instant(l2);
        return GJChronology.getInstance(dateTimeZone, instant, n2);
    }

    public static GJChronology getInstance(DateTimeZone dateTimeZone, ReadableInstant readableInstant) {
        return GJChronology.getInstance(dateTimeZone, readableInstant, 4);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GJChronology getInstance(DateTimeZone var0, ReadableInstant var1_1, int var2_2) {
        synchronized (GJChronology.class) {
            var4_3 = DateTimeUtils.getZone(var0);
            if (var1_1 == null) {
                var5_4 = GJChronology.DEFAULT_CUTOVER;
            } else {
                var15_5 = var1_1.toInstant();
                if (new LocalDate(var15_5.getMillis(), (Chronology)GregorianChronology.getInstance(var4_3)).getYear() <= 0) {
                    throw new IllegalArgumentException("Cutover too early. Must be on or after 0001-01-01.");
                }
                var5_4 = var15_5;
            }
            var6_6 = GJChronology.cCache;
            synchronized (var6_6) {
                block20: {
                    var8_7 = GJChronology.cCache.get(var4_3);
                    if (var8_7 != null) break block20;
                    var8_7 = new ArrayList<E>(2);
                    GJChronology.cCache.put(var4_3, var8_7);
                    ** GOTO lbl22
                }
                var13_9 = var8_7.size();
                while (true) {
                    block21: {
                        if ((var14_10 = var13_9 - 1) >= 0) break block21;
lbl22:
                        // 2 sources

                        if (var4_3 == DateTimeZone.UTC) {
                            var10_8 = new GJChronology(JulianChronology.getInstance(var4_3, var2_2), GregorianChronology.getInstance(var4_3, var2_2), var5_4);
                        } else {
                            var12_11 = GJChronology.getInstance(DateTimeZone.UTC, var5_4, var2_2);
                            var10_8 = new GJChronology(ZonedChronology.getInstance(var12_11, var4_3), var12_11.iJulianChronology, var12_11.iGregorianChronology, var12_11.iCutoverInstant);
                        }
                        var8_7.add(var10_8);
                        // MONITOREXIT @DISABLED, blocks:[7, 8, 9] lbl28 : MonitorExitStatement: MONITOREXIT : var6_6
lbl30:
                        // 2 sources

                        return var10_8;
                    }
                    var10_8 = var8_7.get(var14_10);
                    if (var2_2 == var10_8.getMinimumDaysInFirstWeek() && var5_4.equals(var10_8.getGregorianCutover())) {
                        // MONITOREXIT @DISABLED, blocks:[7, 8, 9, 11] lbl34 : MonitorExitStatement: MONITOREXIT : var6_6
                        ** continue;
                    }
                    var13_9 = var14_10;
                }
            }
        }
    }

    public static GJChronology getInstanceUTC() {
        return GJChronology.getInstance(DateTimeZone.UTC, DEFAULT_CUTOVER, 4);
    }

    private Object readResolve() {
        return GJChronology.getInstance(this.getZone(), this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        Object[] objectArray = (Object[])this.getParam();
        JulianChronology julianChronology = (JulianChronology)objectArray[0];
        GregorianChronology gregorianChronology = (GregorianChronology)objectArray[1];
        Instant instant = (Instant)objectArray[2];
        this.iCutoverMillis = instant.getMillis();
        this.iJulianChronology = julianChronology;
        this.iGregorianChronology = gregorianChronology;
        this.iCutoverInstant = instant;
        if (this.getBase() != null) {
            return;
        }
        if (julianChronology.getMinimumDaysInFirstWeek() != gregorianChronology.getMinimumDaysInFirstWeek()) {
            throw new IllegalArgumentException();
        }
        this.iGapDuration = this.iCutoverMillis - this.julianToGregorianByYear(this.iCutoverMillis);
        fields.copyFieldsFrom(gregorianChronology);
        if (gregorianChronology.millisOfDay().get(this.iCutoverMillis) == 0) {
            fields.millisOfSecond = new CutoverField(julianChronology.millisOfSecond(), fields.millisOfSecond, this.iCutoverMillis);
            fields.millisOfDay = new CutoverField(julianChronology.millisOfDay(), fields.millisOfDay, this.iCutoverMillis);
            fields.secondOfMinute = new CutoverField(julianChronology.secondOfMinute(), fields.secondOfMinute, this.iCutoverMillis);
            fields.secondOfDay = new CutoverField(julianChronology.secondOfDay(), fields.secondOfDay, this.iCutoverMillis);
            fields.minuteOfHour = new CutoverField(julianChronology.minuteOfHour(), fields.minuteOfHour, this.iCutoverMillis);
            fields.minuteOfDay = new CutoverField(julianChronology.minuteOfDay(), fields.minuteOfDay, this.iCutoverMillis);
            fields.hourOfDay = new CutoverField(julianChronology.hourOfDay(), fields.hourOfDay, this.iCutoverMillis);
            fields.hourOfHalfday = new CutoverField(julianChronology.hourOfHalfday(), fields.hourOfHalfday, this.iCutoverMillis);
            fields.clockhourOfDay = new CutoverField(julianChronology.clockhourOfDay(), fields.clockhourOfDay, this.iCutoverMillis);
            fields.clockhourOfHalfday = new CutoverField(julianChronology.clockhourOfHalfday(), fields.clockhourOfHalfday, this.iCutoverMillis);
            fields.halfdayOfDay = new CutoverField(julianChronology.halfdayOfDay(), fields.halfdayOfDay, this.iCutoverMillis);
        }
        fields.era = new CutoverField(julianChronology.era(), fields.era, this.iCutoverMillis);
        long l2 = gregorianChronology.year().roundCeiling(this.iCutoverMillis);
        fields.dayOfYear = new CutoverField(julianChronology.dayOfYear(), fields.dayOfYear, l2);
        long l3 = gregorianChronology.weekyear().roundCeiling(this.iCutoverMillis);
        fields.weekOfWeekyear = new CutoverField(julianChronology.weekOfWeekyear(), fields.weekOfWeekyear, l3, true);
        fields.year = new ImpreciseCutoverField(julianChronology.year(), fields.year, this.iCutoverMillis);
        fields.years = fields.year.getDurationField();
        fields.yearOfEra = new ImpreciseCutoverField(julianChronology.yearOfEra(), fields.yearOfEra, fields.years, this.iCutoverMillis);
        fields.yearOfCentury = new ImpreciseCutoverField(julianChronology.yearOfCentury(), fields.yearOfCentury, fields.years, this.iCutoverMillis);
        fields.centuryOfEra = new ImpreciseCutoverField(julianChronology.centuryOfEra(), fields.centuryOfEra, this.iCutoverMillis);
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.monthOfYear = new ImpreciseCutoverField(julianChronology.monthOfYear(), fields.monthOfYear, this.iCutoverMillis);
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyear = new ImpreciseCutoverField(julianChronology.weekyear(), fields.weekyear, null, this.iCutoverMillis, true);
        fields.weekyearOfCentury = new ImpreciseCutoverField(julianChronology.weekyearOfCentury(), fields.weekyearOfCentury, fields.weekyears, this.iCutoverMillis);
        fields.weekyears = fields.weekyear.getDurationField();
        CutoverField cutoverField = new CutoverField(julianChronology.dayOfMonth(), fields.dayOfMonth, this.iCutoverMillis);
        cutoverField.iRangeDurationField = fields.months;
        fields.dayOfMonth = cutoverField;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof GJChronology)) {
                    return false;
                }
                GJChronology gJChronology = (GJChronology)object;
                if (this.iCutoverMillis != gJChronology.iCutoverMillis || this.getMinimumDaysInFirstWeek() != gJChronology.getMinimumDaysInFirstWeek() || !this.getZone().equals(gJChronology.getZone())) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(n2, n3, n4, n5);
        }
        long l2 = this.iGregorianChronology.getDateTimeMillis(n2, n3, n4, n5);
        if (l2 >= this.iCutoverMillis) return l2;
        l2 = this.iJulianChronology.getDateTimeMillis(n2, n3, n4, n5);
        if (l2 < this.iCutoverMillis) return l2;
        throw new IllegalArgumentException("Specified date does not exist");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        long l2;
        block4: {
            Chronology chronology = this.getBase();
            if (chronology != null) {
                return chronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
            }
            try {
                long l3;
                l2 = l3 = this.iGregorianChronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
            }
            catch (IllegalFieldValueException illegalFieldValueException) {
                if (n3 != 2) throw illegalFieldValueException;
                if (n4 != 29) {
                    throw illegalFieldValueException;
                }
                l2 = this.iGregorianChronology.getDateTimeMillis(n2, n3, 28, n5, n6, n7, n8);
                if (l2 < this.iCutoverMillis) break block4;
                throw illegalFieldValueException;
            }
        }
        if (l2 >= this.iCutoverMillis) return l2;
        l2 = this.iJulianChronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
        if (l2 < this.iCutoverMillis) return l2;
        throw new IllegalArgumentException("Specified date does not exist");
    }

    public Instant getGregorianCutover() {
        return this.iCutoverInstant;
    }

    public int getMinimumDaysInFirstWeek() {
        return this.iGregorianChronology.getMinimumDaysInFirstWeek();
    }

    @Override
    public DateTimeZone getZone() {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getZone();
        }
        return DateTimeZone.UTC;
    }

    long gregorianToJulianByWeekyear(long l2) {
        return GJChronology.convertByWeekyear(l2, this.iGregorianChronology, this.iJulianChronology);
    }

    long gregorianToJulianByYear(long l2) {
        return GJChronology.convertByYear(l2, this.iGregorianChronology, this.iJulianChronology);
    }

    public int hashCode() {
        return 11 * "GJ".hashCode() + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek() + this.iCutoverInstant.hashCode();
    }

    long julianToGregorianByWeekyear(long l2) {
        return GJChronology.convertByWeekyear(l2, this.iJulianChronology, this.iGregorianChronology);
    }

    long julianToGregorianByYear(long l2) {
        return GJChronology.convertByYear(l2, this.iJulianChronology, this.iGregorianChronology);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("GJChronology");
        stringBuffer.append('[');
        stringBuffer.append(this.getZone().getID());
        if (this.iCutoverMillis != DEFAULT_CUTOVER.getMillis()) {
            stringBuffer.append(",cutover=");
            DateTimeFormatter dateTimeFormatter = this.withUTC().dayOfYear().remainder(this.iCutoverMillis) == 0L ? ISODateTimeFormat.date() : ISODateTimeFormat.dateTime();
            dateTimeFormatter.withChronology(this.withUTC()).printTo(stringBuffer, this.iCutoverMillis);
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            stringBuffer.append(",mdfw=");
            stringBuffer.append(this.getMinimumDaysInFirstWeek());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public Chronology withUTC() {
        return this.withZone(DateTimeZone.UTC);
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return GJChronology.getInstance(dateTimeZone, this.iCutoverInstant, this.getMinimumDaysInFirstWeek());
    }

    private class CutoverField
    extends BaseDateTimeField {
        private static final long serialVersionUID = 3528501219481026402L;
        final boolean iConvertByWeekyear;
        final long iCutover;
        protected DurationField iDurationField;
        final DateTimeField iGregorianField;
        final DateTimeField iJulianField;
        protected DurationField iRangeDurationField;

        CutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2) {
            this(dateTimeField, dateTimeField2, l2, false);
        }

        CutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2, boolean bl2) {
            super(dateTimeField2.getType());
            this.iJulianField = dateTimeField;
            this.iGregorianField = dateTimeField2;
            this.iCutover = l2;
            this.iConvertByWeekyear = bl2;
            this.iDurationField = dateTimeField2.getDurationField();
            DurationField durationField = dateTimeField2.getRangeDurationField();
            if (durationField == null) {
                durationField = dateTimeField.getRangeDurationField();
            }
            this.iRangeDurationField = durationField;
        }

        @Override
        public long add(long l2, int n2) {
            return this.iGregorianField.add(l2, n2);
        }

        @Override
        public long add(long l2, long l3) {
            return this.iGregorianField.add(l2, l3);
        }

        @Override
        public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
            if (n3 == 0) {
                return nArray;
            }
            if (DateTimeUtils.isContiguous(readablePartial)) {
                long l2 = 0L;
                int n4 = readablePartial.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    l2 = readablePartial.getFieldType(i2).getField(GJChronology.this).set(l2, nArray[i2]);
                }
                long l3 = this.add(l2, n3);
                return GJChronology.this.get(readablePartial, l3);
            }
            return super.add(readablePartial, n2, nArray, n3);
        }

        @Override
        public int get(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.get(l2);
            }
            return this.iJulianField.get(l2);
        }

        @Override
        public String getAsShortText(int n2, Locale locale) {
            return this.iGregorianField.getAsShortText(n2, locale);
        }

        @Override
        public String getAsShortText(long l2, Locale locale) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getAsShortText(l2, locale);
            }
            return this.iJulianField.getAsShortText(l2, locale);
        }

        @Override
        public String getAsText(int n2, Locale locale) {
            return this.iGregorianField.getAsText(n2, locale);
        }

        @Override
        public String getAsText(long l2, Locale locale) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getAsText(l2, locale);
            }
            return this.iJulianField.getAsText(l2, locale);
        }

        @Override
        public int getDifference(long l2, long l3) {
            return this.iGregorianField.getDifference(l2, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            return this.iGregorianField.getDifferenceAsLong(l2, l3);
        }

        @Override
        public DurationField getDurationField() {
            return this.iDurationField;
        }

        @Override
        public int getLeapAmount(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getLeapAmount(l2);
            }
            return this.iJulianField.getLeapAmount(l2);
        }

        @Override
        public DurationField getLeapDurationField() {
            return this.iGregorianField.getLeapDurationField();
        }

        @Override
        public int getMaximumShortTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumShortTextLength(locale), this.iGregorianField.getMaximumShortTextLength(locale));
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return Math.max(this.iJulianField.getMaximumTextLength(locale), this.iGregorianField.getMaximumTextLength(locale));
        }

        @Override
        public int getMaximumValue() {
            return this.iGregorianField.getMaximumValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getMaximumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(l2);
            }
            int n2 = this.iJulianField.getMaximumValue(l2);
            if (this.iJulianField.set(l2, n2) < this.iCutover) return n2;
            return this.iJulianField.get(this.iJulianField.add(this.iCutover, -1));
        }

        @Override
        public int getMaximumValue(ReadablePartial readablePartial) {
            return this.getMaximumValue(GJChronology.getInstanceUTC().set(readablePartial, 0L));
        }

        @Override
        public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
            GJChronology gJChronology = GJChronology.getInstanceUTC();
            int n2 = readablePartial.size();
            long l2 = 0L;
            for (int i2 = 0; i2 < n2; ++i2) {
                DateTimeField dateTimeField = readablePartial.getFieldType(i2).getField(gJChronology);
                if (nArray[i2] > dateTimeField.getMaximumValue(l2)) continue;
                l2 = dateTimeField.set(l2, nArray[i2]);
            }
            return this.getMaximumValue(l2);
        }

        @Override
        public int getMinimumValue() {
            return this.iJulianField.getMinimumValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getMinimumValue(long l2) {
            if (l2 < this.iCutover) {
                return this.iJulianField.getMinimumValue(l2);
            }
            int n2 = this.iGregorianField.getMinimumValue(l2);
            if (this.iGregorianField.set(l2, n2) >= this.iCutover) return n2;
            return this.iGregorianField.get(this.iCutover);
        }

        @Override
        public int getMinimumValue(ReadablePartial readablePartial) {
            return this.iJulianField.getMinimumValue(readablePartial);
        }

        @Override
        public int getMinimumValue(ReadablePartial readablePartial, int[] nArray) {
            return this.iJulianField.getMinimumValue(readablePartial, nArray);
        }

        @Override
        public DurationField getRangeDurationField() {
            return this.iRangeDurationField;
        }

        protected long gregorianToJulian(long l2) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.gregorianToJulianByWeekyear(l2);
            }
            return GJChronology.this.gregorianToJulianByYear(l2);
        }

        @Override
        public boolean isLeap(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.isLeap(l2);
            }
            return this.iJulianField.isLeap(l2);
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        protected long julianToGregorian(long l2) {
            if (this.iConvertByWeekyear) {
                return GJChronology.this.julianToGregorianByWeekyear(l2);
            }
            return GJChronology.this.julianToGregorianByYear(l2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long roundCeiling(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.roundCeiling(l2);
            }
            long l3 = this.iJulianField.roundCeiling(l2);
            if (l3 < this.iCutover) return l3;
            if (l3 - GJChronology.this.iGapDuration < this.iCutover) return l3;
            return this.julianToGregorian(l3);
        }

        @Override
        public long roundFloor(long l2) {
            if (l2 >= this.iCutover) {
                long l3 = this.iGregorianField.roundFloor(l2);
                if (l3 < this.iCutover && l3 + GJChronology.this.iGapDuration < this.iCutover) {
                    l3 = this.gregorianToJulian(l3);
                }
                return l3;
            }
            return this.iJulianField.roundFloor(l2);
        }

        @Override
        public long set(long l2, int n2) {
            long l3;
            if (l2 >= this.iCutover) {
                l3 = this.iGregorianField.set(l2, n2);
                if (l3 < this.iCutover) {
                    if (l3 + GJChronology.this.iGapDuration < this.iCutover) {
                        l3 = this.gregorianToJulian(l3);
                    }
                    if (this.get(l3) != n2) {
                        throw new IllegalFieldValueException(this.iGregorianField.getType(), (Number)n2, null, null);
                    }
                }
            } else {
                l3 = this.iJulianField.set(l2, n2);
                if (l3 >= this.iCutover) {
                    if (l3 - GJChronology.this.iGapDuration >= this.iCutover) {
                        l3 = this.julianToGregorian(l3);
                    }
                    if (this.get(l3) != n2) {
                        throw new IllegalFieldValueException(this.iJulianField.getType(), (Number)n2, null, null);
                    }
                }
            }
            return l3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long set(long l2, String string2, Locale locale) {
            long l3;
            if (l2 >= this.iCutover) {
                l3 = this.iGregorianField.set(l2, string2, locale);
                if (l3 >= this.iCutover) return l3;
                if (l3 + GJChronology.this.iGapDuration >= this.iCutover) return l3;
                return this.gregorianToJulian(l3);
            }
            l3 = this.iJulianField.set(l2, string2, locale);
            if (l3 < this.iCutover) return l3;
            if (l3 - GJChronology.this.iGapDuration < this.iCutover) return l3;
            return this.julianToGregorian(l3);
        }
    }

    private final class ImpreciseCutoverField
    extends CutoverField {
        private static final long serialVersionUID = 3410248757173576441L;

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, long l2) {
            this(dateTimeField, dateTimeField2, null, l2, false);
        }

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, long l2) {
            this(dateTimeField, dateTimeField2, durationField, l2, false);
        }

        ImpreciseCutoverField(DateTimeField dateTimeField, DateTimeField dateTimeField2, DurationField durationField, long l2, boolean bl2) {
            super(dateTimeField, dateTimeField2, l2, bl2);
            if (durationField == null) {
                durationField = new LinkedDurationField(this.iDurationField, this);
            }
            this.iDurationField = durationField;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long add(long l2, int n2) {
            long l3;
            if (l2 >= this.iCutover) {
                l3 = this.iGregorianField.add(l2, n2);
                if (l3 >= this.iCutover) return l3;
                if (l3 + GJChronology.this.iGapDuration >= this.iCutover) return l3;
                if (this.iConvertByWeekyear) {
                    if (GJChronology.this.iGregorianChronology.weekyear().get(l3) > 0) return this.gregorianToJulian(l3);
                    l3 = GJChronology.this.iGregorianChronology.weekyear().add(l3, -1);
                    return this.gregorianToJulian(l3);
                }
                if (GJChronology.this.iGregorianChronology.year().get(l3) > 0) return this.gregorianToJulian(l3);
                l3 = GJChronology.this.iGregorianChronology.year().add(l3, -1);
                return this.gregorianToJulian(l3);
            }
            l3 = this.iJulianField.add(l2, n2);
            if (l3 < this.iCutover) return l3;
            if (l3 - GJChronology.this.iGapDuration < this.iCutover) return l3;
            return this.julianToGregorian(l3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long add(long l2, long l3) {
            long l4;
            if (l2 >= this.iCutover) {
                l4 = this.iGregorianField.add(l2, l3);
                if (l4 >= this.iCutover) return l4;
                if (l4 + GJChronology.this.iGapDuration >= this.iCutover) return l4;
                if (this.iConvertByWeekyear) {
                    if (GJChronology.this.iGregorianChronology.weekyear().get(l4) > 0) return this.gregorianToJulian(l4);
                    l4 = GJChronology.this.iGregorianChronology.weekyear().add(l4, -1);
                    return this.gregorianToJulian(l4);
                }
                if (GJChronology.this.iGregorianChronology.year().get(l4) > 0) return this.gregorianToJulian(l4);
                l4 = GJChronology.this.iGregorianChronology.year().add(l4, -1);
                return this.gregorianToJulian(l4);
            }
            l4 = this.iJulianField.add(l2, l3);
            if (l4 < this.iCutover) return l4;
            if (l4 - GJChronology.this.iGapDuration < this.iCutover) return l4;
            return this.julianToGregorian(l4);
        }

        @Override
        public int getDifference(long l2, long l3) {
            if (l2 >= this.iCutover) {
                if (l3 >= this.iCutover) {
                    return this.iGregorianField.getDifference(l2, l3);
                }
                long l4 = this.gregorianToJulian(l2);
                return this.iJulianField.getDifference(l4, l3);
            }
            if (l3 < this.iCutover) {
                return this.iJulianField.getDifference(l2, l3);
            }
            long l5 = this.julianToGregorian(l2);
            return this.iGregorianField.getDifference(l5, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            if (l2 >= this.iCutover) {
                if (l3 >= this.iCutover) {
                    return this.iGregorianField.getDifferenceAsLong(l2, l3);
                }
                long l4 = this.gregorianToJulian(l2);
                return this.iJulianField.getDifferenceAsLong(l4, l3);
            }
            if (l3 < this.iCutover) {
                return this.iJulianField.getDifferenceAsLong(l2, l3);
            }
            long l5 = this.julianToGregorian(l2);
            return this.iGregorianField.getDifferenceAsLong(l5, l3);
        }

        @Override
        public int getMaximumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMaximumValue(l2);
            }
            return this.iJulianField.getMaximumValue(l2);
        }

        @Override
        public int getMinimumValue(long l2) {
            if (l2 >= this.iCutover) {
                return this.iGregorianField.getMinimumValue(l2);
            }
            return this.iJulianField.getMinimumValue(l2);
        }
    }

    private static class LinkedDurationField
    extends DecoratedDurationField {
        private static final long serialVersionUID = 4097975388007713084L;
        private final ImpreciseCutoverField iField;

        LinkedDurationField(DurationField durationField, ImpreciseCutoverField impreciseCutoverField) {
            super(durationField, durationField.getType());
            this.iField = impreciseCutoverField;
        }

        @Override
        public long add(long l2, int n2) {
            return this.iField.add(l2, n2);
        }

        @Override
        public long add(long l2, long l3) {
            return this.iField.add(l2, l3);
        }

        @Override
        public int getDifference(long l2, long l3) {
            return this.iField.getDifference(l2, l3);
        }

        @Override
        public long getDifferenceAsLong(long l2, long l3) {
            return this.iField.getDifferenceAsLong(l2, l3);
        }
    }
}

