/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class EthiopicChronology
extends BasicFixedMonthChronology {
    public static final int EE = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("EE");
    private static final EthiopicChronology INSTANCE_UTC;
    private static final int MAX_YEAR = 292272984;
    private static final int MIN_YEAR = -292269337;
    private static final Map<DateTimeZone, EthiopicChronology[]> cCache;
    private static final long serialVersionUID = -5972804258688333942L;

    static {
        cCache = new HashMap<DateTimeZone, EthiopicChronology[]>();
        INSTANCE_UTC = EthiopicChronology.getInstance(DateTimeZone.UTC);
    }

    EthiopicChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    public static EthiopicChronology getInstance() {
        return EthiopicChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static EthiopicChronology getInstance(DateTimeZone dateTimeZone) {
        return EthiopicChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EthiopicChronology getInstance(DateTimeZone dateTimeZone, int n2) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, EthiopicChronology[]> map = cCache;
        synchronized (map) {
            EthiopicChronology ethiopicChronology;
            block8: {
                block10: {
                    block9: {
                        EthiopicChronology[] ethiopicChronologyArray = cCache.get(dateTimeZone);
                        if (ethiopicChronologyArray == null) {
                            ethiopicChronologyArray = new EthiopicChronology[7];
                            cCache.put(dateTimeZone, ethiopicChronologyArray);
                        }
                        EthiopicChronology[] ethiopicChronologyArray2 = ethiopicChronologyArray;
                        int n3 = n2 - 1;
                        try {
                            ethiopicChronology = ethiopicChronologyArray2[n3];
                            if (ethiopicChronology != null) break block8;
                            if (dateTimeZone != DateTimeZone.UTC) break block9;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new IllegalArgumentException("Invalid min days in first week: " + n2);
                        }
                        EthiopicChronology ethiopicChronology2 = new EthiopicChronology(null, null, n2);
                        ethiopicChronology = new EthiopicChronology(LimitChronology.getInstance(ethiopicChronology2, new DateTime(1, 1, 1, 0, 0, 0, 0, ethiopicChronology2), null), null, n2);
                        break block10;
                    }
                    ethiopicChronology = new EthiopicChronology(ZonedChronology.getInstance(EthiopicChronology.getInstance(DateTimeZone.UTC, n2), dateTimeZone), null, n2);
                }
                ethiopicChronologyArray2[n2 - 1] = ethiopicChronology;
            }
            return ethiopicChronology;
        }
    }

    public static EthiopicChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        if (chronology == null) {
            return EthiopicChronology.getInstance(DateTimeZone.UTC, this.getMinimumDaysInFirstWeek());
        }
        return EthiopicChronology.getInstance(chronology.getZone(), this.getMinimumDaysInFirstWeek());
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long calculateFirstDayOfYearMillis(int n2) {
        int n3;
        int n4 = n2 - 1963;
        if (n4 <= 0) {
            n3 = n4 + 3 >> 2;
            return 21859200000L + 86400000L * (365L * (long)n4 + (long)n3);
        }
        n3 = n4 >> 2;
        if (this.isLeapYear(n2)) return 21859200000L + 86400000L * (365L * (long)n4 + (long)n3);
        return 21859200000L + 86400000L * (365L * (long)n4 + (long)(++n3));
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 30962844000000L;
    }

    @Override
    int getMaxYear() {
        return 292272984;
    }

    @Override
    int getMinYear() {
        return -292269337;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return EthiopicChronology.getInstance(dateTimeZone);
    }
}

