/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicFixedMonthChronology;
import org.joda.time.chrono.BasicMonthOfYearDateTimeField;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.SkipDateTimeField;

public final class CopticChronology
extends BasicFixedMonthChronology {
    public static final int AM = 1;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("AM");
    private static final CopticChronology INSTANCE_UTC;
    private static final int MAX_YEAR = 292272708;
    private static final int MIN_YEAR = -292269337;
    private static final Map<DateTimeZone, CopticChronology[]> cCache;
    private static final long serialVersionUID = -5972804258688333942L;

    static {
        cCache = new HashMap<DateTimeZone, CopticChronology[]>();
        INSTANCE_UTC = CopticChronology.getInstance(DateTimeZone.UTC);
    }

    CopticChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    public static CopticChronology getInstance() {
        return CopticChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static CopticChronology getInstance(DateTimeZone dateTimeZone) {
        return CopticChronology.getInstance(dateTimeZone, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CopticChronology getInstance(DateTimeZone dateTimeZone, int n2) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, CopticChronology[]> map = cCache;
        synchronized (map) {
            CopticChronology copticChronology;
            block8: {
                block10: {
                    block9: {
                        CopticChronology[] copticChronologyArray = cCache.get(dateTimeZone);
                        if (copticChronologyArray == null) {
                            copticChronologyArray = new CopticChronology[7];
                            cCache.put(dateTimeZone, copticChronologyArray);
                        }
                        CopticChronology[] copticChronologyArray2 = copticChronologyArray;
                        int n3 = n2 - 1;
                        try {
                            copticChronology = copticChronologyArray2[n3];
                            if (copticChronology != null) break block8;
                            if (dateTimeZone != DateTimeZone.UTC) break block9;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new IllegalArgumentException("Invalid min days in first week: " + n2);
                        }
                        CopticChronology copticChronology2 = new CopticChronology(null, null, n2);
                        copticChronology = new CopticChronology(LimitChronology.getInstance(copticChronology2, new DateTime(1, 1, 1, 0, 0, 0, 0, copticChronology2), null), null, n2);
                        break block10;
                    }
                    copticChronology = new CopticChronology(ZonedChronology.getInstance(CopticChronology.getInstance(DateTimeZone.UTC, n2), dateTimeZone), null, n2);
                }
                copticChronologyArray2[n2 - 1] = copticChronology;
            }
            return copticChronology;
        }
    }

    public static CopticChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        int n2 = this.getMinimumDaysInFirstWeek();
        if (n2 == 0) {
            n2 = 4;
        }
        if (chronology == null) {
            return CopticChronology.getInstance(DateTimeZone.UTC, n2);
        }
        return CopticChronology.getInstance(chronology.getZone(), n2);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new SkipDateTimeField(this, fields.year);
            fields.weekyear = new SkipDateTimeField(this, fields.weekyear);
            fields.era = ERA_FIELD;
            fields.monthOfYear = new BasicMonthOfYearDateTimeField(this, 13);
            fields.months = fields.monthOfYear.getDurationField();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long calculateFirstDayOfYearMillis(int n2) {
        int n3;
        int n4 = n2 - 1687;
        if (n4 <= 0) {
            n3 = n4 + 3 >> 2;
            return 21859200000L + 86400000L * (365L * (long)n4 + (long)n3);
        }
        n3 = n4 >> 2;
        if (this.isLeapYear(n2)) return 21859200000L + 86400000L * (365L * (long)n4 + (long)n3);
        return 21859200000L + 86400000L * (365L * (long)n4 + (long)(++n3));
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 26607895200000L;
    }

    @Override
    int getMaxYear() {
        return 292272708;
    }

    @Override
    int getMinYear() {
        return -292269337;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return CopticChronology.getInstance(dateTimeZone);
    }
}

