/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicSingleEraDateTimeField;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.SkipUndoDateTimeField;

public final class BuddhistChronology
extends AssembledChronology {
    public static final int BE = 1;
    private static final int BUDDHIST_OFFSET = 543;
    private static final DateTimeField ERA_FIELD = new BasicSingleEraDateTimeField("BE");
    private static final BuddhistChronology INSTANCE_UTC;
    private static final Map<DateTimeZone, BuddhistChronology> cCache;
    private static final long serialVersionUID = -3474595157769370126L;

    static {
        cCache = new HashMap<DateTimeZone, BuddhistChronology>();
        INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);
    }

    private BuddhistChronology(Chronology chronology, Object object) {
        super(chronology, object);
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BuddhistChronology getInstance(DateTimeZone dateTimeZone) {
        synchronized (BuddhistChronology.class) {
            if (dateTimeZone == null) {
                dateTimeZone = DateTimeZone.getDefault();
            }
            Map<DateTimeZone, BuddhistChronology> map = cCache;
            synchronized (map) {
                BuddhistChronology buddhistChronology = cCache.get(dateTimeZone);
                if (buddhistChronology != null) return buddhistChronology;
                BuddhistChronology buddhistChronology2 = new BuddhistChronology(GJChronology.getInstance(dateTimeZone, null), null);
                BuddhistChronology buddhistChronology3 = new BuddhistChronology(LimitChronology.getInstance(buddhistChronology2, new DateTime(1, 1, 1, 0, 0, 0, 0, buddhistChronology2), null), "");
                cCache.put(dateTimeZone, buddhistChronology3);
                return buddhistChronology3;
            }
        }
    }

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    private Object readResolve() {
        Chronology chronology = this.getBase();
        if (chronology == null) {
            return BuddhistChronology.getInstanceUTC();
        }
        return BuddhistChronology.getInstance(chronology.getZone());
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getParam() == null) {
            fields.year = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, fields.year), 543);
            DateTimeField cfr_ignored_0 = fields.yearOfEra;
            fields.yearOfEra = new DelegatedDateTimeField(fields.year, DateTimeFieldType.yearOfEra());
            fields.weekyear = new OffsetDateTimeField((DateTimeField)new SkipUndoDateTimeField(this, fields.weekyear), 543);
            fields.centuryOfEra = new DividedDateTimeField(new OffsetDateTimeField(fields.yearOfEra, 99), DateTimeFieldType.centuryOfEra(), 100);
            fields.yearOfCentury = new OffsetDateTimeField(new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra), DateTimeFieldType.yearOfCentury(), 1);
            fields.weekyearOfCentury = new OffsetDateTimeField(new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100), DateTimeFieldType.weekyearOfCentury(), 1);
            fields.era = ERA_FIELD;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BuddhistChronology) {
            BuddhistChronology buddhistChronology = (BuddhistChronology)object;
            return this.getZone().equals(buddhistChronology.getZone());
        }
        return false;
    }

    public int hashCode() {
        return 11 * "Buddhist".hashCode() + this.getZone().hashCode();
    }

    @Override
    public String toString() {
        String string2 = "BuddhistChronology";
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            string2 = string2 + '[' + dateTimeZone.getID() + ']';
        }
        return string2;
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(dateTimeZone);
    }
}

