/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private static final long WEEK_53 = 31449600000L;
    private static final long serialVersionUID = 6215066916806820644L;
    private final BasicChronology iChronology;

    BasicWeekyearDateTimeField(BasicChronology basicChronology) {
        super(DateTimeFieldType.weekyear(), basicChronology.getAverageMillisPerYear());
        this.iChronology = basicChronology;
    }

    private Object readResolve() {
        return this.iChronology.weekyear();
    }

    @Override
    public long add(long l2, int n2) {
        if (n2 == 0) {
            return l2;
        }
        return this.set(l2, n2 + this.get(l2));
    }

    @Override
    public long add(long l2, long l3) {
        return this.add(l2, FieldUtils.safeToInt(l3));
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.add(l2, n2);
    }

    @Override
    public int get(long l2) {
        return this.iChronology.getWeekyear(l2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.getDifference(l3, l2);
        }
        int n2 = this.get(l2);
        int n3 = this.get(l3);
        long l4 = this.remainder(l2);
        long l5 = this.remainder(l3);
        long l6 = l5 >= 31449600000L && this.iChronology.getWeeksInYear(n2) <= 52 ? l5 - 604800000L : l5;
        int n4 = n2 - n3;
        if (l4 < l6) {
            --n4;
        }
        return n4;
    }

    @Override
    public int getLeapAmount(long l2) {
        return -52 + this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(l2));
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    @Override
    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    @Override
    public DurationField getRangeDurationField() {
        return null;
    }

    @Override
    public boolean isLeap(long l2) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(l2)) > 52;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    @Override
    public long roundFloor(long l2) {
        long l3 = this.iChronology.weekOfWeekyear().roundFloor(l2);
        int n2 = this.iChronology.getWeekOfWeekyear(l3);
        if (n2 > 1) {
            l3 -= 604800000L * (long)(n2 - 1);
        }
        return l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long set(long l2, int n2) {
        long l3;
        int n3;
        int n4;
        FieldUtils.verifyValueBounds(this, Math.abs(n2), this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        int n5 = this.get(l2);
        if (n5 == n2) {
            return l2;
        }
        int n6 = this.iChronology.getDayOfWeek(l2);
        int n7 = this.iChronology.getWeeksInYear(n5);
        int n8 = this.iChronology.getWeeksInYear(n2);
        if (n8 >= n7) {
            n8 = n7;
        }
        if ((n4 = this.iChronology.getWeekOfWeekyear(l2)) <= n8) {
            n8 = n4;
        }
        if ((n3 = this.get(l3 = this.iChronology.setYear(l2, n2))) < n2) {
            l3 += 604800000L;
        } else if (n3 > n2) {
            l3 -= 604800000L;
        }
        long l4 = l3 + 604800000L * (long)(n8 - this.iChronology.getWeekOfWeekyear(l3));
        return this.iChronology.dayOfWeek().set(l4, n6);
    }
}

