/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -1587436826395135328L;
    private final BasicChronology iChronology;

    BasicWeekOfWeekyearDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.weekOfWeekyear(), durationField);
        this.iChronology = basicChronology;
    }

    private Object readResolve() {
        return this.iChronology.weekOfWeekyear();
    }

    @Override
    public int get(long l2) {
        return this.iChronology.getWeekOfWeekyear(l2);
    }

    @Override
    public int getMaximumValue() {
        return 53;
    }

    @Override
    public int getMaximumValue(long l2) {
        int n2 = this.iChronology.getWeekyear(l2);
        return this.iChronology.getWeeksInYear(n2);
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.weekyear())) {
            int n2 = readablePartial.get(DateTimeFieldType.weekyear());
            return this.iChronology.getWeeksInYear(n2);
        }
        return 53;
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (readablePartial.getFieldType(i2) != DateTimeFieldType.weekyear()) continue;
            int n3 = nArray[i2];
            return this.iChronology.getWeeksInYear(n3);
        }
        return 53;
    }

    @Override
    protected int getMaximumValueForSet(long l2, int n2) {
        int n3 = 52;
        if (n2 > n3) {
            n3 = this.getMaximumValue(l2);
        }
        return n3;
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    @Override
    public long remainder(long l2) {
        return super.remainder(259200000L + l2);
    }

    @Override
    public long roundCeiling(long l2) {
        return super.roundCeiling(l2 + 259200000L) - 259200000L;
    }

    @Override
    public long roundFloor(long l2) {
        return super.roundFloor(l2 + 259200000L) - 259200000L;
    }
}

