/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

class BasicMonthOfYearDateTimeField
extends ImpreciseDateTimeField {
    private static final int MIN = 1;
    private static final long serialVersionUID = -8258715387168736L;
    private final BasicChronology iChronology;
    private final int iLeapMonth;
    private final int iMax;

    BasicMonthOfYearDateTimeField(BasicChronology basicChronology, int n2) {
        super(DateTimeFieldType.monthOfYear(), basicChronology.getAverageMillisPerMonth());
        this.iChronology = basicChronology;
        this.iMax = this.iChronology.getMaxMonth();
        this.iLeapMonth = n2;
    }

    private Object readResolve() {
        return this.iChronology.monthOfYear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long add(long l2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 == 0) {
            return l2;
        }
        long l3 = this.iChronology.getMillisOfDay(l2);
        int n7 = this.iChronology.getYear(l2);
        int n8 = this.iChronology.getMonthOfYear(l2, n7);
        int n9 = n2 + (n8 - 1);
        if (n9 >= 0) {
            n6 = n7 + n9 / this.iMax;
            n5 = 1 + n9 % this.iMax;
        } else {
            n6 = -1 + (n7 + n9 / this.iMax);
            int n10 = Math.abs(n9) % this.iMax;
            if (n10 == 0) {
                n10 = this.iMax;
            }
            if ((n5 = 1 + (this.iMax - n10)) == 1) {
                ++n6;
            }
        }
        if ((n4 = this.iChronology.getDayOfMonth(l2, n7, n8)) > (n3 = this.iChronology.getDaysInYearMonth(n6, n5))) {
            return l3 + this.iChronology.getYearMonthDayMillis(n6, n5, n3);
        }
        n3 = n4;
        return l3 + this.iChronology.getYearMonthDayMillis(n6, n5, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long add(long l2, long l3) {
        int n2;
        long l4;
        long l5;
        int n3 = (int)l3;
        if ((long)n3 == l3) {
            return this.add(l2, n3);
        }
        long l6 = this.iChronology.getMillisOfDay(l2);
        int n4 = this.iChronology.getYear(l2);
        int n5 = this.iChronology.getMonthOfYear(l2, n4);
        long l7 = l3 + (long)(n5 - 1);
        if (l7 >= 0L) {
            l5 = (long)n4 + l7 / (long)this.iMax;
            l4 = 1L + l7 % (long)this.iMax;
        } else {
            l5 = (long)n4 + l7 / (long)this.iMax - 1L;
            int n6 = (int)(Math.abs(l7) % (long)this.iMax);
            if (n6 == 0) {
                n6 = this.iMax;
            }
            if ((l4 = (long)(1 + (this.iMax - n6))) == 1L) {
                ++l5;
            }
        }
        if (l5 < (long)this.iChronology.getMinYear()) throw new IllegalArgumentException("Magnitude of add amount is too large: " + l3);
        if (l5 > (long)this.iChronology.getMaxYear()) {
            throw new IllegalArgumentException("Magnitude of add amount is too large: " + l3);
        }
        int n7 = (int)l5;
        int n8 = (int)l4;
        int n9 = this.iChronology.getDayOfMonth(l2, n4, n5);
        if (n9 > (n2 = this.iChronology.getDaysInYearMonth(n7, n8))) {
            return l6 + this.iChronology.getYearMonthDayMillis(n7, n8, n2);
        }
        n2 = n9;
        return l6 + this.iChronology.getYearMonthDayMillis(n7, n8, n2);
    }

    @Override
    public int[] add(ReadablePartial readablePartial, int n2, int[] nArray, int n3) {
        if (n3 == 0) {
            return nArray;
        }
        if (readablePartial.size() > 0 && readablePartial.getFieldType(0).equals(DateTimeFieldType.monthOfYear()) && n2 == 0) {
            return this.set(readablePartial, 0, nArray, 1 + (12 + (-1 + readablePartial.getValue(0) + n3 % 12)) % 12);
        }
        if (DateTimeUtils.isContiguous(readablePartial)) {
            long l2 = 0L;
            int n4 = readablePartial.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                l2 = readablePartial.getFieldType(i2).getField(this.iChronology).set(l2, nArray[i2]);
            }
            long l3 = this.add(l2, n3);
            return this.iChronology.get(readablePartial, l3);
        }
        return super.add(readablePartial, n2, nArray, n3);
    }

    @Override
    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, 1, this.iMax));
    }

    @Override
    public int get(long l2) {
        return this.iChronology.getMonthOfYear(l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long getDifferenceAsLong(long l2, long l3) {
        if (l2 < l3) {
            return -this.getDifference(l3, l2);
        }
        int n2 = this.iChronology.getYear(l2);
        int n3 = this.iChronology.getMonthOfYear(l2, n2);
        int n4 = this.iChronology.getYear(l3);
        int n5 = this.iChronology.getMonthOfYear(l3, n4);
        long l4 = (long)(n2 - n4) * (long)this.iMax + (long)n3 - (long)n5;
        int n6 = this.iChronology.getDayOfMonth(l2, n2, n3);
        if (n6 == this.iChronology.getDaysInYearMonth(n2, n3) && this.iChronology.getDayOfMonth(l3, n4, n5) > n6) {
            l3 = this.iChronology.dayOfMonth().set(l3, n6);
        }
        if (l2 - this.iChronology.getYearMonthMillis(n2, n3) >= l3 - this.iChronology.getYearMonthMillis(n4, n5)) return l4;
        return l4 - 1L;
    }

    @Override
    public int getLeapAmount(long l2) {
        if (this.isLeap(l2)) {
            return 1;
        }
        return 0;
    }

    @Override
    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    @Override
    public boolean isLeap(long l2) {
        int n2 = this.iChronology.getYear(l2);
        boolean bl2 = this.iChronology.isLeapYear(n2);
        boolean bl3 = false;
        if (bl2) {
            int n3 = this.iChronology.getMonthOfYear(l2, n2);
            int n4 = this.iLeapMonth;
            bl3 = false;
            if (n3 == n4) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public long remainder(long l2) {
        return l2 - this.roundFloor(l2);
    }

    @Override
    public long roundFloor(long l2) {
        int n2 = this.iChronology.getYear(l2);
        int n3 = this.iChronology.getMonthOfYear(l2, n2);
        return this.iChronology.getYearMonthMillis(n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, 1, this.iMax);
        int n3 = this.iChronology.getYear(l2);
        int n4 = this.iChronology.getDayOfMonth(l2, n3);
        int n5 = this.iChronology.getDaysInYearMonth(n3, n2);
        if (n4 > n5) {
            return this.iChronology.getYearMonthDayMillis(n3, n2, n5) + (long)this.iChronology.getMillisOfDay(l2);
        }
        n5 = n4;
        return this.iChronology.getYearMonthDayMillis(n3, n2, n5) + (long)this.iChronology.getMillisOfDay(l2);
    }
}

