/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicGJChronology
extends BasicChronology {
    private static final long FEB_29 = 5097600000L;
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY;
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY;
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY;
    private static final long serialVersionUID = 538276888268L;

    static {
        long l2 = 0L;
        MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
        long l3 = l2;
        for (int i2 = 0; i2 < 11; ++i2) {
            BasicGJChronology.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l3 += 86400000L * (long)MIN_DAYS_PER_MONTH_ARRAY[i2];
            BasicGJChronology.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i2 + 1] = l2 += 86400000L * (long)MAX_DAYS_PER_MONTH_ARRAY[i2];
        }
    }

    BasicGJChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    @Override
    int getDaysInMonthMax(int n2) {
        return MAX_DAYS_PER_MONTH_ARRAY[n2 - 1];
    }

    @Override
    int getDaysInMonthMaxForSet(long l2, int n2) {
        int n3 = 28;
        if (n2 > n3 || n2 < 1) {
            n3 = this.getDaysInMonthMax(l2);
        }
        return n3;
    }

    @Override
    int getDaysInYearMonth(int n2, int n3) {
        if (this.isLeapYear(n2)) {
            return MAX_DAYS_PER_MONTH_ARRAY[n3 - 1];
        }
        return MIN_DAYS_PER_MONTH_ARRAY[n3 - 1];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int getMonthOfYear(long l2, int n2) {
        int n3 = (int)(l2 - this.getYearMillis(n2) >> 10);
        if (this.isLeapYear(n2)) {
            if (n3 < 15356250) {
                if (n3 < 7678125) {
                    if (n3 < 2615625) return 1;
                    if (n3 >= 5062500) return 3;
                    return 2;
                } else {
                    if (n3 < 10209375) {
                        return 4;
                    }
                    if (n3 >= 12825000) return 6;
                    return 5;
                }
            }
            if (n3 < 23118750) {
                if (n3 < 17971875) {
                    return 7;
                }
                if (n3 >= 20587500) return 9;
                return 8;
            }
            if (n3 < 25734375) {
                return 10;
            }
            if (n3 >= 28265625) return 12;
            return 11;
        }
        if (n3 < 15271875) {
            if (n3 < 7593750) {
                if (n3 < 2615625) {
                    return 1;
                }
                if (n3 >= 4978125) return 3;
                return 2;
            }
            if (n3 < 10125000) {
                return 4;
            }
            if (n3 >= 12740625) return 6;
            return 5;
        }
        if (n3 < 23034375) {
            if (n3 < 17887500) {
                return 7;
            }
            if (n3 >= 20503125) return 9;
            return 8;
        }
        if (n3 < 25650000) {
            return 10;
        }
        if (n3 >= 28181250) return 12;
        return 11;
    }

    @Override
    long getTotalMillisByYearMonth(int n2, int n3) {
        if (this.isLeapYear(n2)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[n3 - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[n3 - 1];
    }

    /*
     * Unable to fully structure code
     */
    @Override
    long getYearDifference(long var1_1, long var3_2) {
        block3: {
            block4: {
                var5_3 = this.getYear(var1_1);
                var6_4 = this.getYear(var3_2);
                var7_5 = var1_1 - this.getYearMillis(var5_3);
                var9_6 = var3_2 - this.getYearMillis(var6_4);
                if (var9_6 < 5097600000L) break block3;
                if (!this.isLeapYear(var6_4)) break block4;
                if (!this.isLeapYear(var5_3)) {
                    var16_7 = var9_6 - 86400000L;
                    var11_8 = var7_5;
                    var13_9 = var16_7;
lbl11:
                    // 3 sources

                    while (true) {
                        var15_10 = var5_3 - var6_4;
                        if (var11_8 < var13_9) {
                            --var15_10;
                        }
                        return var15_10;
                    }
                }
                break block3;
            }
            if (var7_5 < 5097600000L || !this.isLeapYear(var5_3)) break block3;
            var11_8 = var7_5 - 86400000L;
            var13_9 = var9_6;
            ** GOTO lbl11
        }
        var11_8 = var7_5;
        var13_9 = var9_6;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    long setYear(long l2, int n2) {
        int n3 = this.getYear(l2);
        int n4 = this.getDayOfYear(l2, n3);
        int n5 = this.getMillisOfDay(l2);
        if (n4 <= 59) return this.getYearMonthDayMillis(n2, 1, n4) + (long)n5;
        if (this.isLeapYear(n3)) {
            if (this.isLeapYear(n2)) return this.getYearMonthDayMillis(n2, 1, n4) + (long)n5;
            --n4;
            return this.getYearMonthDayMillis(n2, 1, n4) + (long)n5;
        }
        if (!this.isLeapYear(n2)) return this.getYearMonthDayMillis(n2, 1, n4) + (long)n5;
        return this.getYearMonthDayMillis(n2, 1, ++n4) + (long)n5;
    }
}

