/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.Chronology;
import org.joda.time.chrono.BasicChronology;

abstract class BasicFixedMonthChronology
extends BasicChronology {
    static final long MILLIS_PER_MONTH = 2592000000L;
    static final long MILLIS_PER_YEAR = 31557600000L;
    static final int MONTH_LENGTH = 30;
    private static final long serialVersionUID = 261387371998L;

    BasicFixedMonthChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object, n2);
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2592000000L;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778800000L;
    }

    @Override
    int getDayOfMonth(long l2) {
        return 1 + (-1 + this.getDayOfYear(l2)) % 30;
    }

    @Override
    int getDaysInMonthMax() {
        return 30;
    }

    @Override
    int getDaysInMonthMax(int n2) {
        if (n2 != 13) {
            return 30;
        }
        return 6;
    }

    @Override
    int getDaysInYearMonth(int n2, int n3) {
        if (n3 != 13) {
            return 30;
        }
        if (this.isLeapYear(n2)) {
            return 6;
        }
        return 5;
    }

    @Override
    int getMaxMonth() {
        return 13;
    }

    @Override
    int getMonthOfYear(long l2) {
        return 1 + (-1 + this.getDayOfYear(l2)) / 30;
    }

    @Override
    int getMonthOfYear(long l2, int n2) {
        return 1 + (int)((l2 - this.getYearMillis(n2)) / 2592000000L);
    }

    @Override
    long getTotalMillisByYearMonth(int n2, int n3) {
        return 2592000000L * (long)(n3 - 1);
    }

    @Override
    long getYearDifference(long l2, long l3) {
        int n2 = this.getYear(l2);
        int n3 = this.getYear(l3);
        long l4 = l2 - this.getYearMillis(n2);
        long l5 = l3 - this.getYearMillis(n3);
        int n4 = n2 - n3;
        if (l4 < l5) {
            --n4;
        }
        return n4;
    }

    @Override
    boolean isLeapYear(int n2) {
        return (n2 & 3) == 3;
    }

    @Override
    long setYear(long l2, int n2) {
        int n3 = this.getDayOfYear(l2, this.getYear(l2));
        int n4 = this.getMillisOfDay(l2);
        if (n3 > 365 && !this.isLeapYear(n2)) {
            --n3;
        }
        return this.getYearMonthDayMillis(n2, 1, n3) + (long)n4;
    }
}

