/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfMonth(), durationField);
        this.iChronology = basicChronology;
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }

    @Override
    public int get(long l2) {
        return this.iChronology.getDayOfMonth(l2);
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }

    @Override
    public int getMaximumValue(long l2) {
        return this.iChronology.getDaysInMonthMax(l2);
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.monthOfYear())) {
            int n2 = readablePartial.get(DateTimeFieldType.monthOfYear());
            if (readablePartial.isSupported(DateTimeFieldType.year())) {
                int n3 = readablePartial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(n3, n2);
            }
            return this.iChronology.getDaysInMonthMax(n2);
        }
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n2 = 0;
        int n3 = readablePartial.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (readablePartial.getFieldType(i2) != DateTimeFieldType.monthOfYear()) continue;
            int n4 = nArray[i2];
            while (n2 < n3) {
                if (readablePartial.getFieldType(n2) == DateTimeFieldType.year()) {
                    int n5 = nArray[n2];
                    return this.iChronology.getDaysInYearMonth(n5, n4);
                }
                ++n2;
            }
            return this.iChronology.getDaysInMonthMax(n4);
        }
        return this.getMaximumValue();
    }

    @Override
    protected int getMaximumValueForSet(long l2, int n2) {
        return this.iChronology.getDaysInMonthMaxForSet(l2, n2);
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }
}

