/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BasicDayOfMonthDateTimeField;
import org.joda.time.chrono.BasicDayOfYearDateTimeField;
import org.joda.time.chrono.BasicWeekOfWeekyearDateTimeField;
import org.joda.time.chrono.BasicWeekyearDateTimeField;
import org.joda.time.chrono.BasicYearDateTimeField;
import org.joda.time.chrono.GJDayOfWeekDateTimeField;
import org.joda.time.chrono.GJEraDateTimeField;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.chrono.GJMonthOfYearDateTimeField;
import org.joda.time.chrono.GJYearOfEraDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ZeroIsMaxDateTimeField;

abstract class BasicChronology
extends AssembledChronology {
    private static final int CACHE_MASK = 1023;
    private static final int CACHE_SIZE = 1024;
    private static final DateTimeField cClockhourOfDayField;
    private static final DateTimeField cClockhourOfHalfdayField;
    private static final DurationField cDaysField;
    private static final DateTimeField cHalfdayOfDayField;
    private static final DurationField cHalfdaysField;
    private static final DateTimeField cHourOfDayField;
    private static final DateTimeField cHourOfHalfdayField;
    private static final DurationField cHoursField;
    private static final DurationField cMillisField;
    private static final DateTimeField cMillisOfDayField;
    private static final DateTimeField cMillisOfSecondField;
    private static final DateTimeField cMinuteOfDayField;
    private static final DateTimeField cMinuteOfHourField;
    private static final DurationField cMinutesField;
    private static final DateTimeField cSecondOfDayField;
    private static final DateTimeField cSecondOfMinuteField;
    private static final DurationField cSecondsField;
    private static final DurationField cWeeksField;
    private static final long serialVersionUID = 8283225332206808863L;
    private final int iMinDaysInFirstWeek;
    private final transient YearInfo[] iYearInfoCache = new YearInfo[1024];

    static {
        cMillisField = MillisDurationField.INSTANCE;
        cSecondsField = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
        cMinutesField = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
        cHoursField = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
        cHalfdaysField = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
        cDaysField = new PreciseDurationField(DurationFieldType.days(), 86400000L);
        cWeeksField = new PreciseDurationField(DurationFieldType.weeks(), 604800000L);
        cMillisOfSecondField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), cMillisField, cSecondsField);
        cMillisOfDayField = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), cMillisField, cDaysField);
        cSecondOfMinuteField = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), cSecondsField, cMinutesField);
        cSecondOfDayField = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), cSecondsField, cDaysField);
        cMinuteOfHourField = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), cMinutesField, cHoursField);
        cMinuteOfDayField = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), cMinutesField, cDaysField);
        cHourOfDayField = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), cHoursField, cDaysField);
        cHourOfHalfdayField = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), cHoursField, cHalfdaysField);
        cClockhourOfDayField = new ZeroIsMaxDateTimeField(cHourOfDayField, DateTimeFieldType.clockhourOfDay());
        cClockhourOfHalfdayField = new ZeroIsMaxDateTimeField(cHourOfHalfdayField, DateTimeFieldType.clockhourOfHalfday());
        cHalfdayOfDayField = new HalfdayField();
    }

    BasicChronology(Chronology chronology, Object object, int n2) {
        super(chronology, object);
        if (n2 < 1 || n2 > 7) {
            throw new IllegalArgumentException("Invalid min days in first week: " + n2);
        }
        this.iMinDaysInFirstWeek = n2;
    }

    private YearInfo getYearInfo(int n2) {
        YearInfo yearInfo = this.iYearInfoCache[n2 & 0x3FF];
        if (yearInfo == null || yearInfo.iYear != n2) {
            this.iYearInfoCache[n2 & 0x3FF] = yearInfo = new YearInfo(n2, this.calculateFirstDayOfYearMillis(n2));
        }
        return yearInfo;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        fields.millis = cMillisField;
        fields.seconds = cSecondsField;
        fields.minutes = cMinutesField;
        fields.hours = cHoursField;
        fields.halfdays = cHalfdaysField;
        fields.days = cDaysField;
        fields.weeks = cWeeksField;
        fields.millisOfSecond = cMillisOfSecondField;
        fields.millisOfDay = cMillisOfDayField;
        fields.secondOfMinute = cSecondOfMinuteField;
        fields.secondOfDay = cSecondOfDayField;
        fields.minuteOfHour = cMinuteOfHourField;
        fields.minuteOfDay = cMinuteOfDayField;
        fields.hourOfDay = cHourOfDayField;
        fields.hourOfHalfday = cHourOfHalfdayField;
        fields.clockhourOfDay = cClockhourOfDayField;
        fields.clockhourOfHalfday = cClockhourOfHalfdayField;
        fields.halfdayOfDay = cHalfdayOfDayField;
        fields.year = new BasicYearDateTimeField(this);
        fields.yearOfEra = new GJYearOfEraDateTimeField(fields.year, this);
        fields.centuryOfEra = new DividedDateTimeField(new OffsetDateTimeField(fields.yearOfEra, 99), DateTimeFieldType.centuryOfEra(), 100);
        fields.yearOfCentury = new OffsetDateTimeField(new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra), DateTimeFieldType.yearOfCentury(), 1);
        fields.era = new GJEraDateTimeField(this);
        fields.dayOfWeek = new GJDayOfWeekDateTimeField(this, fields.days);
        fields.dayOfMonth = new BasicDayOfMonthDateTimeField(this, fields.days);
        fields.dayOfYear = new BasicDayOfYearDateTimeField(this, fields.days);
        fields.monthOfYear = new GJMonthOfYearDateTimeField(this);
        fields.weekyear = new BasicWeekyearDateTimeField(this);
        fields.weekOfWeekyear = new BasicWeekOfWeekyearDateTimeField(this, fields.weeks);
        fields.weekyearOfCentury = new OffsetDateTimeField(new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100), DateTimeFieldType.weekyearOfCentury(), 1);
        fields.years = fields.year.getDurationField();
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyears = fields.weekyear.getDurationField();
    }

    abstract long calculateFirstDayOfYearMillis(int var1);

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block4: {
                block2: {
                    if (this == object) break block2;
                    if (object == null || this.getClass() != object.getClass()) break block3;
                    BasicChronology basicChronology = (BasicChronology)object;
                    if (this.getMinimumDaysInFirstWeek() != basicChronology.getMinimumDaysInFirstWeek() || !this.getZone().equals(basicChronology.getZone())) break block4;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    abstract long getApproxMillisAtEpochDividedByTwo();

    abstract long getAverageMillisPerMonth();

    abstract long getAverageMillisPerYear();

    abstract long getAverageMillisPerYearDividedByTwo();

    long getDateMidnightMillis(int n2, int n3, int n4) {
        FieldUtils.verifyValueBounds(DateTimeFieldType.year(), n2, this.getMinYear(), this.getMaxYear());
        FieldUtils.verifyValueBounds(DateTimeFieldType.monthOfYear(), n3, 1, this.getMaxMonth(n2));
        FieldUtils.verifyValueBounds(DateTimeFieldType.dayOfMonth(), n4, 1, this.getDaysInYearMonth(n2, n3));
        return this.getYearMonthDayMillis(n2, n3, n4);
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(n2, n3, n4, n5);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfDay(), n5, 0, 86399999);
        return this.getDateMidnightMillis(n2, n3, n4) + (long)n5;
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getDateTimeMillis(n2, n3, n4, n5, n6, n7, n8);
        }
        FieldUtils.verifyValueBounds(DateTimeFieldType.hourOfDay(), n5, 0, 23);
        FieldUtils.verifyValueBounds(DateTimeFieldType.minuteOfHour(), n6, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.secondOfMinute(), n7, 0, 59);
        FieldUtils.verifyValueBounds(DateTimeFieldType.millisOfSecond(), n8, 0, 999);
        return this.getDateMidnightMillis(n2, n3, n4) + (long)(3600000 * n5) + (long)(60000 * n6) + (long)(n7 * 1000) + (long)n8;
    }

    int getDayOfMonth(long l2) {
        int n2 = this.getYear(l2);
        return this.getDayOfMonth(l2, n2, this.getMonthOfYear(l2, n2));
    }

    int getDayOfMonth(long l2, int n2) {
        return this.getDayOfMonth(l2, n2, this.getMonthOfYear(l2, n2));
    }

    int getDayOfMonth(long l2, int n2, int n3) {
        return 1 + (int)((l2 - (this.getYearMillis(n2) + this.getTotalMillisByYearMonth(n2, n3))) / 86400000L);
    }

    /*
     * Enabled aggressive block sorting
     */
    int getDayOfWeek(long l2) {
        long l3;
        if (l2 >= 0L) {
            l3 = l2 / 86400000L;
            return 1 + (int)((l3 + 3L) % 7L);
        } else {
            l3 = (l2 - 86399999L) / 86400000L;
            if (l3 >= -3L) return 1 + (int)((l3 + 3L) % 7L);
            return 7 + (int)((l3 + 4L) % 7L);
        }
    }

    int getDayOfYear(long l2) {
        return this.getDayOfYear(l2, this.getYear(l2));
    }

    int getDayOfYear(long l2, int n2) {
        return 1 + (int)((l2 - this.getYearMillis(n2)) / 86400000L);
    }

    int getDaysInMonthMax() {
        return 31;
    }

    abstract int getDaysInMonthMax(int var1);

    int getDaysInMonthMax(long l2) {
        int n2 = this.getYear(l2);
        return this.getDaysInYearMonth(n2, this.getMonthOfYear(l2, n2));
    }

    int getDaysInMonthMaxForSet(long l2, int n2) {
        return this.getDaysInMonthMax(l2);
    }

    int getDaysInYear(int n2) {
        if (this.isLeapYear(n2)) {
            return 366;
        }
        return 365;
    }

    int getDaysInYearMax() {
        return 366;
    }

    abstract int getDaysInYearMonth(int var1, int var2);

    long getFirstWeekOfYearMillis(int n2) {
        long l2 = this.getYearMillis(n2);
        int n3 = this.getDayOfWeek(l2);
        if (n3 > 8 - this.iMinDaysInFirstWeek) {
            return l2 + 86400000L * (long)(8 - n3);
        }
        return l2 - 86400000L * (long)(n3 - 1);
    }

    int getMaxMonth() {
        return 12;
    }

    int getMaxMonth(int n2) {
        return this.getMaxMonth();
    }

    abstract int getMaxYear();

    int getMillisOfDay(long l2) {
        if (l2 >= 0L) {
            return (int)(l2 % 86400000L);
        }
        return 86399999 + (int)((1L + l2) % 86400000L);
    }

    abstract int getMinYear();

    public int getMinimumDaysInFirstWeek() {
        return this.iMinDaysInFirstWeek;
    }

    int getMonthOfYear(long l2) {
        return this.getMonthOfYear(l2, this.getYear(l2));
    }

    abstract int getMonthOfYear(long var1, int var3);

    abstract long getTotalMillisByYearMonth(int var1, int var2);

    int getWeekOfWeekyear(long l2) {
        return this.getWeekOfWeekyear(l2, this.getYear(l2));
    }

    int getWeekOfWeekyear(long l2, int n2) {
        long l3 = this.getFirstWeekOfYearMillis(n2);
        if (l2 < l3) {
            return this.getWeeksInYear(n2 - 1);
        }
        if (l2 >= this.getFirstWeekOfYearMillis(n2 + 1)) {
            return 1;
        }
        return 1 + (int)((l2 - l3) / 604800000L);
    }

    int getWeeksInYear(int n2) {
        long l2 = this.getFirstWeekOfYearMillis(n2);
        return (int)((this.getFirstWeekOfYearMillis(n2 + 1) - l2) / 604800000L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getWeekyear(long l2) {
        int n2 = this.getYear(l2);
        int n3 = this.getWeekOfWeekyear(l2, n2);
        if (n3 == 1) {
            return this.getYear(604800000L + l2);
        }
        if (n3 <= 51) return n2;
        return this.getYear(l2 - 1209600000L);
    }

    /*
     * Enabled aggressive block sorting
     */
    int getYear(long l2) {
        int n2;
        long l3;
        long l4;
        long l5 = this.getAverageMillisPerYearDividedByTwo();
        long l6 = (l2 >> 1) + this.getApproxMillisAtEpochDividedByTwo();
        if (l6 < 0L) {
            l6 = 1L + (l6 - l5);
        }
        if ((l4 = l2 - (l3 = this.getYearMillis(n2 = (int)(l6 / l5)))) < 0L) {
            --n2;
            return n2;
        } else {
            long l7;
            if (l4 < 31536000000L || (l7 = this.isLeapYear(n2) ? 31622400000L : 31536000000L) + l3 > l2) return n2;
            return n2 + 1;
        }
    }

    abstract long getYearDifference(long var1, long var3);

    long getYearMillis(int n2) {
        return this.getYearInfo((int)n2).iFirstDayMillis;
    }

    long getYearMonthDayMillis(int n2, int n3, int n4) {
        return this.getYearMillis(n2) + this.getTotalMillisByYearMonth(n2, n3) + 86400000L * (long)(n4 - 1);
    }

    long getYearMonthMillis(int n2, int n3) {
        return this.getYearMillis(n2) + this.getTotalMillisByYearMonth(n2, n3);
    }

    @Override
    public DateTimeZone getZone() {
        Chronology chronology = this.getBase();
        if (chronology != null) {
            return chronology.getZone();
        }
        return DateTimeZone.UTC;
    }

    public int hashCode() {
        return 11 * this.getClass().getName().hashCode() + this.getZone().hashCode() + this.getMinimumDaysInFirstWeek();
    }

    abstract boolean isLeapYear(int var1);

    abstract long setYear(long var1, int var3);

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        String string2 = this.getClass().getName();
        int n2 = string2.lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string2.substring(n2 + 1);
        }
        stringBuilder.append(string2);
        stringBuilder.append('[');
        DateTimeZone dateTimeZone = this.getZone();
        if (dateTimeZone != null) {
            stringBuilder.append(dateTimeZone.getID());
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            stringBuilder.append(",mdfw=");
            stringBuilder.append(this.getMinimumDaysInFirstWeek());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static class HalfdayField
    extends PreciseDateTimeField {
        private static final long serialVersionUID = 581601443656929254L;

        HalfdayField() {
            super(DateTimeFieldType.halfdayOfDay(), cHalfdaysField, cDaysField);
        }

        @Override
        public String getAsText(int n2, Locale locale) {
            return GJLocaleSymbols.forLocale(locale).halfdayValueToText(n2);
        }

        @Override
        public int getMaximumTextLength(Locale locale) {
            return GJLocaleSymbols.forLocale(locale).getHalfdayMaxTextLength();
        }

        @Override
        public long set(long l2, String string2, Locale locale) {
            return this.set(l2, GJLocaleSymbols.forLocale(locale).halfdayTextToValue(string2));
        }
    }

    private static class YearInfo {
        public final long iFirstDayMillis;
        public final int iYear;

        YearInfo(int n2, long l2) {
            this.iYear = n2;
            this.iFirstDayMillis = l2;
        }
    }
}

