/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    @Override
    public long add(long l2, long l3, int n2) {
        if (l3 == 0L || n2 == 0) {
            return l2;
        }
        return FieldUtils.safeAdd(l2, FieldUtils.safeMultiply(l3, n2));
    }

    @Override
    public long add(ReadablePeriod readablePeriod, long l2, int n2) {
        if (n2 != 0 && readablePeriod != null) {
            int n3 = readablePeriod.size();
            long l3 = l2;
            for (int i2 = 0; i2 < n3; ++i2) {
                long l4 = readablePeriod.getValue(i2);
                if (l4 == 0L) continue;
                l3 = readablePeriod.getFieldType(i2).getField(this).add(l3, l4 * (long)n2);
            }
            l2 = l3;
        }
        return l2;
    }

    @Override
    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    @Override
    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    @Override
    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    @Override
    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    @Override
    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    @Override
    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    @Override
    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    @Override
    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    @Override
    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    @Override
    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    @Override
    public int[] get(ReadablePartial readablePartial, long l2) {
        int n2 = readablePartial.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = readablePartial.getFieldType(i2).getField(this).get(l2);
        }
        return nArray;
    }

    @Override
    public int[] get(ReadablePeriod readablePeriod, long l2) {
        int n2 = readablePeriod.size();
        int[] nArray = new int[n2];
        if (l2 != 0L) {
            long l3 = 0L;
            for (int i2 = 0; i2 < n2; ++i2) {
                DurationField durationField = readablePeriod.getFieldType(i2).getField(this);
                if (!durationField.isPrecise()) continue;
                int n3 = durationField.getDifference(l2, l3);
                l3 = durationField.add(l3, n3);
                nArray[i2] = n3;
            }
        }
        return nArray;
    }

    @Override
    public int[] get(ReadablePeriod readablePeriod, long l2, long l3) {
        int n2 = readablePeriod.size();
        int[] nArray = new int[n2];
        if (l2 != l3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                DurationField durationField = readablePeriod.getFieldType(i2).getField(this);
                int n3 = durationField.getDifference(l3, l2);
                l2 = durationField.add(l2, n3);
                nArray[i2] = n3;
            }
        }
        return nArray;
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        long l2 = this.year().set(0L, n2);
        long l3 = this.monthOfYear().set(l2, n3);
        long l4 = this.dayOfMonth().set(l3, n4);
        return this.millisOfDay().set(l4, n5);
    }

    @Override
    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        long l2 = this.year().set(0L, n2);
        long l3 = this.monthOfYear().set(l2, n3);
        long l4 = this.dayOfMonth().set(l3, n4);
        long l5 = this.hourOfDay().set(l4, n5);
        long l6 = this.minuteOfHour().set(l5, n6);
        long l7 = this.secondOfMinute().set(l6, n7);
        return this.millisOfSecond().set(l7, n8);
    }

    @Override
    public long getDateTimeMillis(long l2, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        long l3 = this.hourOfDay().set(l2, n2);
        long l4 = this.minuteOfHour().set(l3, n3);
        long l5 = this.secondOfMinute().set(l4, n4);
        return this.millisOfSecond().set(l5, n5);
    }

    @Override
    public abstract DateTimeZone getZone();

    @Override
    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    @Override
    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    @Override
    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    @Override
    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    @Override
    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    @Override
    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    @Override
    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    @Override
    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    @Override
    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    @Override
    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    @Override
    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    @Override
    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    @Override
    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    @Override
    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    @Override
    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    @Override
    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    @Override
    public long set(ReadablePartial readablePartial, long l2) {
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = readablePartial.getFieldType(i2).getField(this).set(l2, readablePartial.getValue(i2));
        }
        return l2;
    }

    @Override
    public abstract String toString();

    /*
     * Unable to fully structure code
     */
    @Override
    public void validate(ReadablePartial var1_1, int[] var2_2) {
        block4: {
            var3_3 = var1_1.size();
            var4_4 = 0;
            while (true) {
                var5_5 = 0;
                if (var4_4 >= var3_3) ** GOTO lbl15
                var8_6 = var2_2[var4_4];
                var9_7 = var1_1.getField(var4_4);
                if (var8_6 < var9_7.getMinimumValue()) {
                    throw new IllegalFieldValueException(var9_7.getType(), (Number)var8_6, (Number)var9_7.getMinimumValue(), null);
                }
                if (var8_6 > var9_7.getMaximumValue()) {
                    throw new IllegalFieldValueException(var9_7.getType(), (Number)var8_6, null, (Number)var9_7.getMaximumValue());
                }
                ++var4_4;
            }
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl15:
                // 2 sources

                if (var5_5 >= var3_3) break block4;
                var6_8 = var2_2[var5_5];
                var7_9 = var1_1.getField(var5_5);
                if (var6_8 >= var7_9.getMinimumValue(var1_1, var2_2)) continue;
                throw new IllegalFieldValueException(var7_9.getType(), (Number)var6_8, (Number)var7_9.getMinimumValue(var1_1, var2_2), null);
                ** while (var6_8 <= var7_9.getMaximumValue((ReadablePartial)var1_1, (int[])var2_2))
            }
lbl21:
            // 1 sources

            throw new IllegalFieldValueException(var7_9.getType(), (Number)var6_8, null, (Number)var7_9.getMaximumValue(var1_1, var2_2));
        }
    }

    @Override
    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    @Override
    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    @Override
    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    @Override
    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    @Override
    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    @Override
    public abstract Chronology withUTC();

    @Override
    public abstract Chronology withZone(DateTimeZone var1);

    @Override
    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    @Override
    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    @Override
    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    @Override
    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }
}

