/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractPartial;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class BasePartial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2353678632973660L;
    private final Chronology iChronology;
    private final int[] iValues;

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected BasePartial(long l2) {
        this(l2, (Chronology)null);
    }

    protected BasePartial(long l2, Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology2.withUTC();
        this.iValues = chronology2.get(this, l2);
    }

    protected BasePartial(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology2 = DateTimeUtils.getChronology(partialConverter.getChronology(object, chronology));
        this.iChronology = chronology2.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology2);
    }

    protected BasePartial(Object object, Chronology chronology, DateTimeFormatter dateTimeFormatter) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology2 = DateTimeUtils.getChronology(partialConverter.getChronology(object, chronology));
        this.iChronology = chronology2.withUTC();
        this.iValues = partialConverter.getPartialValues(this, object, chronology2, dateTimeFormatter);
    }

    protected BasePartial(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    protected BasePartial(BasePartial basePartial, Chronology chronology) {
        this.iChronology = chronology.withUTC();
        this.iValues = basePartial.iValues;
    }

    protected BasePartial(BasePartial basePartial, int[] nArray) {
        this.iChronology = basePartial.iChronology;
        this.iValues = nArray;
    }

    protected BasePartial(int[] nArray, Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology2.withUTC();
        chronology2.validate(this, nArray);
        this.iValues = nArray;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    public int getValue(int n2) {
        return this.iValues[n2];
    }

    @Override
    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    protected void setValue(int n2, int n3) {
        System.arraycopy(this.getField(n2).set(this, n2, this.iValues, n3), 0, this.iValues, 0, this.iValues.length);
    }

    protected void setValues(int[] nArray) {
        this.getChronology().validate(this, nArray);
        System.arraycopy(nArray, 0, this.iValues, 0, this.iValues.length);
    }

    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }
}

