/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractPartial
implements ReadablePartial,
Comparable<ReadablePartial> {
    protected AbstractPartial() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compareTo(ReadablePartial readablePartial) {
        if (this != readablePartial) {
            if (this.size() != readablePartial.size()) {
                throw new ClassCastException("ReadablePartial objects must have matching field types");
            }
            int n2 = this.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.getFieldType(i2) == readablePartial.getFieldType(i2)) continue;
                throw new ClassCastException("ReadablePartial objects must have matching field types");
            }
            int n3 = this.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (this.getValue(i3) > readablePartial.getValue(i3)) {
                    return 1;
                }
                if (this.getValue(i3) >= readablePartial.getValue(i3)) continue;
                return -1;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl2 = object instanceof ReadablePartial;
        boolean bl3 = false;
        if (!bl2) return bl3;
        ReadablePartial readablePartial = (ReadablePartial)object;
        int n2 = this.size();
        int n3 = readablePartial.size();
        bl3 = false;
        if (n2 != n3) return bl3;
        int n4 = this.size();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.getValue(n5);
            int n7 = readablePartial.getValue(n5);
            bl3 = false;
            if (n6 != n7) return bl3;
            DateTimeFieldType dateTimeFieldType = this.getFieldType(n5);
            DateTimeFieldType dateTimeFieldType2 = readablePartial.getFieldType(n5);
            bl3 = false;
            if (dateTimeFieldType != dateTimeFieldType2) return bl3;
            ++n5;
        }
        return FieldUtils.equals(this.getChronology(), readablePartial.getChronology());
    }

    @Override
    public int get(DateTimeFieldType dateTimeFieldType) {
        return this.getValue(this.indexOfSupported(dateTimeFieldType));
    }

    @Override
    public DateTimeField getField(int n2) {
        return this.getField(n2, this.getChronology());
    }

    protected abstract DateTimeField getField(int var1, Chronology var2);

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return this.getField(n2, this.getChronology()).getType();
    }

    public DateTimeFieldType[] getFieldTypes() {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[this.size()];
        for (int i2 = 0; i2 < dateTimeFieldTypeArray.length; ++i2) {
            dateTimeFieldTypeArray[i2] = this.getFieldType(i2);
        }
        return dateTimeFieldTypeArray;
    }

    public DateTimeField[] getFields() {
        DateTimeField[] dateTimeFieldArray = new DateTimeField[this.size()];
        for (int i2 = 0; i2 < dateTimeFieldArray.length; ++i2) {
            dateTimeFieldArray[i2] = this.getField(i2);
        }
        return dateTimeFieldArray;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.getValue(i2);
        }
        return nArray;
    }

    @Override
    public int hashCode() {
        int n2 = 157;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = 23 * (n2 * 23 + this.getValue(i2)) + this.getFieldType(i2).hashCode();
        }
        return n2 + this.getChronology().hashCode();
    }

    public int indexOf(DateTimeFieldType dateTimeFieldType) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.getFieldType(i2) != dateTimeFieldType) continue;
            return i2;
        }
        return -1;
    }

    protected int indexOf(DurationFieldType durationFieldType) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.getFieldType(i2).getDurationType() != durationFieldType) continue;
            return i2;
        }
        return -1;
    }

    protected int indexOfSupported(DateTimeFieldType dateTimeFieldType) {
        int n2 = this.indexOf(dateTimeFieldType);
        if (n2 == -1) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return n2;
    }

    protected int indexOfSupported(DurationFieldType durationFieldType) {
        int n2 = this.indexOf(durationFieldType);
        if (n2 == -1) {
            throw new IllegalArgumentException("Field '" + durationFieldType + "' is not supported");
        }
        return n2;
    }

    public boolean isAfter(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) > 0;
    }

    public boolean isBefore(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) < 0;
    }

    public boolean isEqual(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(readablePartial) == 0;
    }

    @Override
    public boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        return this.indexOf(dateTimeFieldType) != -1;
    }

    @Override
    public DateTime toDateTime(ReadableInstant readableInstant) {
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        return new DateTime(chronology.set(this, DateTimeUtils.getInstantMillis(readableInstant)), chronology);
    }

    public String toString(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            return this.toString();
        }
        return dateTimeFormatter.print(this);
    }
}

