/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.MutableInterval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInterval
implements ReadableInterval {
    protected AbstractInterval() {
    }

    protected void checkInterval(long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("The end instant must be greater or equal to the start");
        }
    }

    public boolean contains(long l2) {
        long l3 = this.getStartMillis();
        long l4 = this.getEndMillis();
        return l2 >= l3 && l2 < l4;
    }

    @Override
    public boolean contains(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.containsNow();
        }
        return this.contains(readableInstant.getMillis());
    }

    @Override
    public boolean contains(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return this.containsNow();
        }
        long l2 = readableInterval.getStartMillis();
        long l3 = readableInterval.getEndMillis();
        long l4 = this.getStartMillis();
        long l5 = this.getEndMillis();
        return l4 <= l2 && l2 < l5 && l3 <= l5;
    }

    public boolean containsNow() {
        return this.contains(DateTimeUtils.currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof ReadableInterval)) {
                    return false;
                }
                ReadableInterval readableInterval = (ReadableInterval)object;
                if (this.getStartMillis() != readableInterval.getStartMillis() || this.getEndMillis() != readableInterval.getEndMillis() || !FieldUtils.equals(this.getChronology(), readableInterval.getChronology())) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public DateTime getEnd() {
        return new DateTime(this.getEndMillis(), this.getChronology());
    }

    @Override
    public DateTime getStart() {
        return new DateTime(this.getStartMillis(), this.getChronology());
    }

    @Override
    public int hashCode() {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        return 31 * (31 * (3007 + (int)(l2 ^ l2 >>> 32)) + (int)(l3 ^ l3 >>> 32)) + this.getChronology().hashCode();
    }

    public boolean isAfter(long l2) {
        return this.getStartMillis() > l2;
    }

    @Override
    public boolean isAfter(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.isAfterNow();
        }
        return this.isAfter(readableInstant.getMillis());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAfter(ReadableInterval readableInterval) {
        long l2;
        if (readableInterval == null) {
            l2 = DateTimeUtils.currentTimeMillis();
            return this.getStartMillis() >= l2;
        }
        l2 = readableInterval.getEndMillis();
        return this.getStartMillis() >= l2;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(long l2) {
        return this.getEndMillis() <= l2;
    }

    @Override
    public boolean isBefore(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(readableInstant.getMillis());
    }

    @Override
    public boolean isBefore(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return this.isBeforeNow();
        }
        return this.isBefore(readableInterval.getStartMillis());
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isEqual(ReadableInterval readableInterval) {
        return this.getStartMillis() == readableInterval.getStartMillis() && this.getEndMillis() == readableInterval.getEndMillis();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean overlaps(ReadableInterval readableInterval) {
        long l2 = this.getStartMillis();
        long l3 = this.getEndMillis();
        if (readableInterval == null) {
            long l4 = DateTimeUtils.currentTimeMillis();
            if (l2 < l4 && l4 < l3) return true;
            return false;
        }
        long l5 = readableInterval.getStartMillis();
        if (l2 >= readableInterval.getEndMillis() || l5 >= l3) return false;
        return true;
    }

    @Override
    public Duration toDuration() {
        long l2 = this.toDurationMillis();
        if (l2 == 0L) {
            return Duration.ZERO;
        }
        return new Duration(l2);
    }

    @Override
    public long toDurationMillis() {
        return FieldUtils.safeAdd(this.getEndMillis(), -this.getStartMillis());
    }

    @Override
    public Interval toInterval() {
        return new Interval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public MutableInterval toMutableInterval() {
        return new MutableInterval(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public Period toPeriod() {
        return new Period(this.getStartMillis(), this.getEndMillis(), this.getChronology());
    }

    @Override
    public Period toPeriod(PeriodType periodType) {
        return new Period(this.getStartMillis(), this.getEndMillis(), periodType, this.getChronology());
    }

    @Override
    public String toString() {
        DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime().withChronology(this.getChronology());
        StringBuffer stringBuffer = new StringBuffer(48);
        dateTimeFormatter.printTo(stringBuffer, this.getStartMillis());
        stringBuffer.append('/');
        dateTimeFormatter.printTo(stringBuffer, this.getEndMillis());
        return stringBuffer.toString();
    }
}

