/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.util.Date;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class AbstractInstant
implements ReadableInstant {
    protected AbstractInstant() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compareTo(ReadableInstant readableInstant) {
        long l2;
        long l3;
        block5: {
            block4: {
                if (this == readableInstant) break block4;
                l3 = readableInstant.getMillis();
                l2 = this.getMillis();
                if (l2 != l3) break block5;
            }
            return 0;
        }
        if (l2 < l3) {
            return -1;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (!(object instanceof ReadableInstant)) {
                    return false;
                }
                ReadableInstant readableInstant = (ReadableInstant)object;
                if (this.getMillis() != readableInstant.getMillis() || !FieldUtils.equals(this.getChronology(), readableInstant.getChronology())) break block5;
            }
            return true;
        }
        return false;
    }

    public int get(DateTimeField dateTimeField) {
        if (dateTimeField == null) {
            throw new IllegalArgumentException("The DateTimeField must not be null");
        }
        return dateTimeField.get(this.getMillis());
    }

    @Override
    public int get(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return dateTimeFieldType.getField(this.getChronology()).get(this.getMillis());
    }

    @Override
    public DateTimeZone getZone() {
        return this.getChronology().getZone();
    }

    @Override
    public int hashCode() {
        return (int)(this.getMillis() ^ this.getMillis() >>> 32) + this.getChronology().hashCode();
    }

    public boolean isAfter(long l2) {
        return this.getMillis() > l2;
    }

    @Override
    public boolean isAfter(ReadableInstant readableInstant) {
        return this.isAfter(DateTimeUtils.getInstantMillis(readableInstant));
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    public boolean isBefore(long l2) {
        return this.getMillis() < l2;
    }

    @Override
    public boolean isBefore(ReadableInstant readableInstant) {
        return this.isBefore(DateTimeUtils.getInstantMillis(readableInstant));
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    public boolean isEqual(long l2) {
        return this.getMillis() == l2;
    }

    @Override
    public boolean isEqual(ReadableInstant readableInstant) {
        return this.isEqual(DateTimeUtils.getInstantMillis(readableInstant));
    }

    public boolean isEqualNow() {
        return this.isEqual(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            return false;
        }
        return dateTimeFieldType.getField(this.getChronology()).isSupported();
    }

    public Date toDate() {
        return new Date(this.getMillis());
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), this.getZone());
    }

    public DateTime toDateTime(Chronology chronology) {
        return new DateTime(this.getMillis(), chronology);
    }

    public DateTime toDateTime(DateTimeZone dateTimeZone) {
        Chronology chronology = DateTimeUtils.getChronology(this.getChronology()).withZone(dateTimeZone);
        return new DateTime(this.getMillis(), chronology);
    }

    public DateTime toDateTimeISO() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    @Override
    public Instant toInstant() {
        return new Instant(this.getMillis());
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), this.getZone());
    }

    public MutableDateTime toMutableDateTime(Chronology chronology) {
        return new MutableDateTime(this.getMillis(), chronology);
    }

    public MutableDateTime toMutableDateTime(DateTimeZone dateTimeZone) {
        Chronology chronology = DateTimeUtils.getChronology(this.getChronology()).withZone(dateTimeZone);
        return new MutableDateTime(this.getMillis(), chronology);
    }

    public MutableDateTime toMutableDateTimeISO() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    @Override
    @ToString
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public String toString(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            return this.toString();
        }
        return dateTimeFormatter.print(this);
    }
}

