/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadableDateTime;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormat;

public abstract class AbstractDateTime
extends AbstractInstant
implements ReadableDateTime {
    protected AbstractDateTime() {
    }

    @Override
    public int get(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return dateTimeFieldType.getField(this.getChronology()).get(this.getMillis());
    }

    @Override
    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getMillis());
    }

    @Override
    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getMillis());
    }

    @Override
    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getMillis());
    }

    @Override
    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getMillis());
    }

    @Override
    public int getEra() {
        return this.getChronology().era().get(this.getMillis());
    }

    @Override
    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getMillis());
    }

    @Override
    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getMillis());
    }

    @Override
    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getMillis());
    }

    @Override
    public int getMinuteOfDay() {
        return this.getChronology().minuteOfDay().get(this.getMillis());
    }

    @Override
    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getMillis());
    }

    @Override
    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getMillis());
    }

    @Override
    public int getSecondOfDay() {
        return this.getChronology().secondOfDay().get(this.getMillis());
    }

    @Override
    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getMillis());
    }

    @Override
    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getMillis());
    }

    @Override
    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getMillis());
    }

    @Override
    public int getYear() {
        return this.getChronology().year().get(this.getMillis());
    }

    @Override
    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getMillis());
    }

    @Override
    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getMillis());
    }

    public Calendar toCalendar(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Calendar calendar = Calendar.getInstance(this.getZone().toTimeZone(), locale);
        calendar.setTime(this.toDate());
        return calendar;
    }

    public GregorianCalendar toGregorianCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getZone().toTimeZone());
        gregorianCalendar.setTime(this.toDate());
        return gregorianCalendar;
    }

    @Override
    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    @Override
    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }
}

