/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Years
extends BaseSingleFieldPeriod {
    public static final Years MAX_VALUE;
    public static final Years MIN_VALUE;
    public static final Years ONE;
    private static final PeriodFormatter PARSER;
    public static final Years THREE;
    public static final Years TWO;
    public static final Years ZERO;
    private static final long serialVersionUID = 87525275727380868L;

    static {
        ZERO = new Years(0);
        ONE = new Years(1);
        TWO = new Years(2);
        THREE = new Years(3);
        MAX_VALUE = new Years(Integer.MAX_VALUE);
        MIN_VALUE = new Years(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.years());
    }

    private Years(int n2) {
        super(n2);
    }

    @FromString
    public static Years parseYears(String string2) {
        if (string2 == null) {
            return ZERO;
        }
        return Years.years(PARSER.parsePeriod(string2).getYears());
    }

    private Object readResolve() {
        return Years.years(this.getValue());
    }

    public static Years years(int n2) {
        switch (n2) {
            default: {
                return new Years(n2);
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: 
        }
        return MIN_VALUE;
    }

    public static Years yearsBetween(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        return Years.years(BaseSingleFieldPeriod.between(readableInstant, readableInstant2, DurationFieldType.years()));
    }

    public static Years yearsBetween(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial instanceof LocalDate && readablePartial2 instanceof LocalDate) {
            return Years.years(DateTimeUtils.getChronology(readablePartial.getChronology()).years().getDifference(((LocalDate)readablePartial2).getLocalMillis(), ((LocalDate)readablePartial).getLocalMillis()));
        }
        return Years.years(BaseSingleFieldPeriod.between(readablePartial, readablePartial2, ZERO));
    }

    public static Years yearsIn(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ZERO;
        }
        return Years.years(BaseSingleFieldPeriod.between(readableInterval.getStart(), readableInterval.getEnd(), DurationFieldType.years()));
    }

    public Years dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Years.years(this.getValue() / n2);
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.years();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.years();
    }

    public int getYears() {
        return this.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isGreaterThan(Years years) {
        if (years == null) {
            if (this.getValue() > 0) return true;
            return false;
        }
        if (this.getValue() <= years.getValue()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLessThan(Years years) {
        if (years == null) {
            if (this.getValue() < 0) return true;
            return false;
        }
        if (this.getValue() >= years.getValue()) return false;
        return true;
    }

    public Years minus(int n2) {
        return this.plus(FieldUtils.safeNegate(n2));
    }

    public Years minus(Years years) {
        if (years == null) {
            return this;
        }
        return this.minus(years.getValue());
    }

    public Years multipliedBy(int n2) {
        return Years.years(FieldUtils.safeMultiply(this.getValue(), n2));
    }

    public Years negated() {
        return Years.years(FieldUtils.safeNegate(this.getValue()));
    }

    public Years plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Years.years(FieldUtils.safeAdd(this.getValue(), n2));
    }

    public Years plus(Years years) {
        if (years == null) {
            return this;
        }
        return this.plus(years.getValue());
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "Y";
    }
}

