/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class YearMonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int DAY_OF_MONTH = 2;
    private static final DateTimeFieldType[] FIELD_TYPES;
    public static final int MONTH_OF_YEAR = 1;
    public static final int YEAR = 0;
    private static final long serialVersionUID = 797544782896179L;

    static {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
        FIELD_TYPES = dateTimeFieldTypeArray;
    }

    public YearMonthDay() {
    }

    public YearMonthDay(int n2, int n3, int n4) {
        this(n2, n3, n4, null);
    }

    public YearMonthDay(int n2, int n3, int n4, Chronology chronology) {
        super(new int[]{n2, n3, n4}, chronology);
    }

    public YearMonthDay(long l2) {
        super(l2);
    }

    public YearMonthDay(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public YearMonthDay(Object object) {
        super(object, null, ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.dateOptionalTimeParser());
    }

    public YearMonthDay(Chronology chronology) {
        super(chronology);
    }

    public YearMonthDay(DateTimeZone dateTimeZone) {
        super(ISOChronology.getInstance(dateTimeZone));
    }

    YearMonthDay(YearMonthDay yearMonthDay, Chronology chronology) {
        super((BasePartial)yearMonthDay, chronology);
    }

    YearMonthDay(YearMonthDay yearMonthDay, int[] nArray) {
        super((BasePartial)yearMonthDay, nArray);
    }

    public static YearMonthDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonthDay(calendar.get(1), 1 + calendar.get(2), calendar.get(5));
    }

    public static YearMonthDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonthDay(1900 + date.getYear(), 1 + date.getMonth(), date.getDate());
    }

    public Property dayOfMonth() {
        return new Property(this, 2);
    }

    public int getDayOfMonth() {
        return this.getValue(2);
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return chronology.year();
            }
            case 1: {
                return chronology.monthOfYear();
            }
            case 2: 
        }
        return chronology.dayOfMonth();
    }

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return FIELD_TYPES[n2];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public int getYear() {
        return this.getValue(0);
    }

    public YearMonthDay minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public YearMonthDay minusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(n2));
    }

    public YearMonthDay minusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(n2));
    }

    public YearMonthDay minusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(n2));
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    public YearMonthDay plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public YearMonthDay plusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), n2);
    }

    public YearMonthDay plusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), n2);
    }

    public YearMonthDay plusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), n2);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    @Override
    public int size() {
        return 3;
    }

    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public DateMidnight toDateMidnight(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chronology);
    }

    public DateTime toDateTime(TimeOfDay timeOfDay) {
        return this.toDateTime(timeOfDay, null);
    }

    public DateTime toDateTime(TimeOfDay timeOfDay, DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        long l2 = chronology.set(this, DateTimeUtils.currentTimeMillis());
        if (timeOfDay != null) {
            l2 = chronology.set(timeOfDay, l2);
        }
        return new DateTime(l2, chronology);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(chronology.set(this, DateTimeUtils.currentTimeMillis()), chronology);
    }

    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public DateTime toDateTimeAtMidnight(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chronology);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone dateTimeZone) {
        return this.toDateMidnight(DateTimeUtils.getZone(dateTimeZone)).toInterval();
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.yearMonthDay().print(this);
    }

    public YearMonthDay withChronologyRetainFields(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (chronology2 == this.getChronology()) {
            return this;
        }
        YearMonthDay yearMonthDay = new YearMonthDay(this, chronology2);
        chronology2.validate(yearMonthDay, this.getValues());
        return yearMonthDay;
    }

    public YearMonthDay withDayOfMonth(int n2) {
        int[] nArray = this.getValues();
        return new YearMonthDay(this, this.getChronology().dayOfMonth().set(this, 2, nArray, n2));
    }

    public YearMonthDay withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        return new YearMonthDay(this, this.getField(n3).set(this, n3, nArray, n2));
    }

    public YearMonthDay withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new YearMonthDay(this, this.getField(n3).add(this, n3, nArray, n2));
    }

    public YearMonthDay withMonthOfYear(int n2) {
        int[] nArray = this.getValues();
        return new YearMonthDay(this, this.getChronology().monthOfYear().set(this, 1, nArray, n2));
    }

    public YearMonthDay withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n3 = this.indexOf(readablePeriod.getFieldType(i2));
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new YearMonthDay(this, nArray);
    }

    public YearMonthDay withYear(int n2) {
        int[] nArray = this.getValues();
        return new YearMonthDay(this, this.getChronology().year().set(this, 0, nArray, n2));
    }

    public Property year() {
        return new Property(this, 0);
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final int iFieldIndex;
        private final YearMonthDay iYearMonthDay;

        Property(YearMonthDay yearMonthDay, int n2) {
            this.iYearMonthDay = yearMonthDay;
            this.iFieldIndex = n2;
        }

        public YearMonthDay addToCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            int[] nArray2 = this.getField().add(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray2);
        }

        public YearMonthDay addWrapFieldToCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            int[] nArray2 = this.getField().addWrapField(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray2);
        }

        @Override
        public int get() {
            return this.iYearMonthDay.getValue(this.iFieldIndex);
        }

        @Override
        public DateTimeField getField() {
            return this.iYearMonthDay.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iYearMonthDay;
        }

        public YearMonthDay getYearMonthDay() {
            return this.iYearMonthDay;
        }

        public YearMonthDay setCopy(int n2) {
            int[] nArray = this.iYearMonthDay.getValues();
            int[] nArray2 = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, n2);
            return new YearMonthDay(this.iYearMonthDay, nArray2);
        }

        public YearMonthDay setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public YearMonthDay setCopy(String string2, Locale locale) {
            int[] nArray = this.iYearMonthDay.getValues();
            int[] nArray2 = this.getField().set(this.iYearMonthDay, this.iFieldIndex, nArray, string2, locale);
            return new YearMonthDay(this.iYearMonthDay, nArray2);
        }

        public YearMonthDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public YearMonthDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

