/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class YearMonth
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final DateTimeFieldType[] FIELD_TYPES;
    public static final int MONTH_OF_YEAR = 1;
    public static final int YEAR = 0;
    private static final long serialVersionUID = 797544782896179L;

    static {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[]{DateTimeFieldType.year(), DateTimeFieldType.monthOfYear()};
        FIELD_TYPES = dateTimeFieldTypeArray;
    }

    public YearMonth() {
    }

    public YearMonth(int n2, int n3) {
        this(n2, n3, null);
    }

    public YearMonth(int n2, int n3, Chronology chronology) {
        super(new int[]{n2, n3}, chronology);
    }

    public YearMonth(long l2) {
        super(l2);
    }

    public YearMonth(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public YearMonth(Object object) {
        super(object, null, ISODateTimeFormat.localDateParser());
    }

    public YearMonth(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.localDateParser());
    }

    public YearMonth(Chronology chronology) {
        super(chronology);
    }

    public YearMonth(DateTimeZone dateTimeZone) {
        super(ISOChronology.getInstance(dateTimeZone));
    }

    YearMonth(YearMonth yearMonth, Chronology chronology) {
        super((BasePartial)yearMonth, chronology);
    }

    YearMonth(YearMonth yearMonth, int[] nArray) {
        super((BasePartial)yearMonth, nArray);
    }

    public static YearMonth fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new YearMonth(calendar.get(1), 1 + calendar.get(2));
    }

    public static YearMonth fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new YearMonth(1900 + date.getYear(), 1 + date.getMonth());
    }

    public static YearMonth now() {
        return new YearMonth();
    }

    public static YearMonth now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new YearMonth(chronology);
    }

    public static YearMonth now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new YearMonth(dateTimeZone);
    }

    @FromString
    public static YearMonth parse(String string2) {
        return YearMonth.parse(string2, ISODateTimeFormat.localDateParser());
    }

    public static YearMonth parse(String string2, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = dateTimeFormatter.parseLocalDate(string2);
        return new YearMonth(localDate.getYear(), localDate.getMonthOfYear());
    }

    private Object readResolve() {
        if (!DateTimeZone.UTC.equals(yearMonth.getChronology().getZone())) {
            YearMonth yearMonth = new YearMonth(yearMonth, yearMonth.getChronology().withUTC());
        }
        return yearMonth;
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return chronology.year();
            }
            case 1: 
        }
        return chronology.monthOfYear();
    }

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return FIELD_TYPES[n2];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public int getMonthOfYear() {
        return this.getValue(1);
    }

    public int getYear() {
        return this.getValue(0);
    }

    public YearMonth minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public YearMonth minusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(n2));
    }

    public YearMonth minusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), FieldUtils.safeNegate(n2));
    }

    public Property monthOfYear() {
        return new Property(this, 1);
    }

    public YearMonth plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public YearMonth plusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), n2);
    }

    public YearMonth plusYears(int n2) {
        return this.withFieldAdded(DurationFieldType.years(), n2);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    @Override
    public int size() {
        return 2;
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2 = DateTimeUtils.getZone(dateTimeZone);
        return new Interval((ReadableInstant)this.toLocalDate(1).toDateTimeAtStartOfDay(dateTimeZone2), (ReadableInstant)this.plusMonths(1).toLocalDate(1).toDateTimeAtStartOfDay(dateTimeZone2));
    }

    public LocalDate toLocalDate(int n2) {
        return new LocalDate(this.getYear(), this.getMonthOfYear(), n2, this.getChronology());
    }

    @Override
    @ToString
    public String toString() {
        return ISODateTimeFormat.yearMonth().print(this);
    }

    @Override
    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    @Override
    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }

    public YearMonth withChronologyRetainFields(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (chronology2 == this.getChronology()) {
            return this;
        }
        YearMonth yearMonth = new YearMonth(this, chronology2);
        chronology2.validate(yearMonth, this.getValues());
        return yearMonth;
    }

    public YearMonth withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        return new YearMonth(this, this.getField(n3).set(this, n3, nArray, n2));
    }

    public YearMonth withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new YearMonth(this, this.getField(n3).add(this, n3, nArray, n2));
    }

    public YearMonth withMonthOfYear(int n2) {
        int[] nArray = this.getValues();
        return new YearMonth(this, this.getChronology().monthOfYear().set(this, 1, nArray, n2));
    }

    public YearMonth withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n3 = this.indexOf(readablePeriod.getFieldType(i2));
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new YearMonth(this, nArray);
    }

    public YearMonth withYear(int n2) {
        int[] nArray = this.getValues();
        return new YearMonth(this, this.getChronology().year().set(this, 0, nArray, n2));
    }

    public Property year() {
        return new Property(this, 0);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final YearMonth iBase;
        private final int iFieldIndex;

        Property(YearMonth yearMonth, int n2) {
            this.iBase = yearMonth;
            this.iFieldIndex = n2;
        }

        public YearMonth addToCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().add(this.iBase, this.iFieldIndex, nArray, n2);
            return new YearMonth(this.iBase, nArray2);
        }

        public YearMonth addWrapFieldToCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().addWrapField(this.iBase, this.iFieldIndex, nArray, n2);
            return new YearMonth(this.iBase, nArray2);
        }

        @Override
        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        @Override
        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public YearMonth getYearMonth() {
            return this.iBase;
        }

        public YearMonth setCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().set(this.iBase, this.iFieldIndex, nArray, n2);
            return new YearMonth(this.iBase, nArray2);
        }

        public YearMonth setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public YearMonth setCopy(String string2, Locale locale) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().set(this.iBase, this.iFieldIndex, nArray, string2, locale);
            return new YearMonth(this.iBase, nArray2);
        }
    }
}

