/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Weeks
extends BaseSingleFieldPeriod {
    public static final Weeks MAX_VALUE;
    public static final Weeks MIN_VALUE;
    public static final Weeks ONE;
    private static final PeriodFormatter PARSER;
    public static final Weeks THREE;
    public static final Weeks TWO;
    public static final Weeks ZERO;
    private static final long serialVersionUID = 87525275727380866L;

    static {
        ZERO = new Weeks(0);
        ONE = new Weeks(1);
        TWO = new Weeks(2);
        THREE = new Weeks(3);
        MAX_VALUE = new Weeks(Integer.MAX_VALUE);
        MIN_VALUE = new Weeks(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.weeks());
    }

    private Weeks(int n2) {
        super(n2);
    }

    @FromString
    public static Weeks parseWeeks(String string2) {
        if (string2 == null) {
            return ZERO;
        }
        return Weeks.weeks(PARSER.parsePeriod(string2).getWeeks());
    }

    private Object readResolve() {
        return Weeks.weeks(this.getValue());
    }

    public static Weeks standardWeeksIn(ReadablePeriod readablePeriod) {
        return Weeks.weeks(BaseSingleFieldPeriod.standardPeriodIn(readablePeriod, 604800000L));
    }

    public static Weeks weeks(int n2) {
        switch (n2) {
            default: {
                return new Weeks(n2);
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: 
        }
        return MIN_VALUE;
    }

    public static Weeks weeksBetween(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        return Weeks.weeks(BaseSingleFieldPeriod.between(readableInstant, readableInstant2, DurationFieldType.weeks()));
    }

    public static Weeks weeksBetween(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial instanceof LocalDate && readablePartial2 instanceof LocalDate) {
            return Weeks.weeks(DateTimeUtils.getChronology(readablePartial.getChronology()).weeks().getDifference(((LocalDate)readablePartial2).getLocalMillis(), ((LocalDate)readablePartial).getLocalMillis()));
        }
        return Weeks.weeks(BaseSingleFieldPeriod.between(readablePartial, readablePartial2, ZERO));
    }

    public static Weeks weeksIn(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ZERO;
        }
        return Weeks.weeks(BaseSingleFieldPeriod.between(readableInterval.getStart(), readableInterval.getEnd(), DurationFieldType.weeks()));
    }

    public Weeks dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Weeks.weeks(this.getValue() / n2);
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.weeks();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.weeks();
    }

    public int getWeeks() {
        return this.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isGreaterThan(Weeks weeks) {
        if (weeks == null) {
            if (this.getValue() > 0) return true;
            return false;
        }
        if (this.getValue() <= weeks.getValue()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLessThan(Weeks weeks) {
        if (weeks == null) {
            if (this.getValue() < 0) return true;
            return false;
        }
        if (this.getValue() >= weeks.getValue()) return false;
        return true;
    }

    public Weeks minus(int n2) {
        return this.plus(FieldUtils.safeNegate(n2));
    }

    public Weeks minus(Weeks weeks) {
        if (weeks == null) {
            return this;
        }
        return this.minus(weeks.getValue());
    }

    public Weeks multipliedBy(int n2) {
        return Weeks.weeks(FieldUtils.safeMultiply(this.getValue(), n2));
    }

    public Weeks negated() {
        return Weeks.weeks(FieldUtils.safeNegate(this.getValue()));
    }

    public Weeks plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Weeks.weeks(FieldUtils.safeAdd(this.getValue(), n2));
    }

    public Weeks plus(Weeks weeks) {
        if (weeks == null) {
            return this;
        }
        return this.plus(weeks.getValue());
    }

    public Days toStandardDays() {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), 7));
    }

    public Duration toStandardDuration() {
        return new Duration(604800000L * (long)this.getValue());
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 168));
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 10080));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 604800));
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "W";
    }
}

