/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class TimeOfDay
extends BasePartial
implements ReadablePartial,
Serializable {
    private static final DateTimeFieldType[] FIELD_TYPES;
    public static final int HOUR_OF_DAY = 0;
    public static final TimeOfDay MIDNIGHT;
    public static final int MILLIS_OF_SECOND = 3;
    public static final int MINUTE_OF_HOUR = 1;
    public static final int SECOND_OF_MINUTE = 2;
    private static final long serialVersionUID = 3633353405803318660L;

    static {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[]{DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute(), DateTimeFieldType.millisOfSecond()};
        FIELD_TYPES = dateTimeFieldTypeArray;
        MIDNIGHT = new TimeOfDay(0, 0, 0, 0);
    }

    public TimeOfDay() {
    }

    public TimeOfDay(int n2, int n3) {
        this(n2, n3, 0, 0, null);
    }

    public TimeOfDay(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, null);
    }

    public TimeOfDay(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null);
    }

    public TimeOfDay(int n2, int n3, int n4, int n5, Chronology chronology) {
        super(new int[]{n2, n3, n4, n5}, chronology);
    }

    public TimeOfDay(int n2, int n3, int n4, Chronology chronology) {
        this(n2, n3, n4, 0, chronology);
    }

    public TimeOfDay(int n2, int n3, Chronology chronology) {
        this(n2, n3, 0, 0, chronology);
    }

    public TimeOfDay(long l2) {
        super(l2);
    }

    public TimeOfDay(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public TimeOfDay(Object object) {
        super(object, null, ISODateTimeFormat.timeParser());
    }

    public TimeOfDay(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.timeParser());
    }

    public TimeOfDay(Chronology chronology) {
        super(chronology);
    }

    public TimeOfDay(DateTimeZone dateTimeZone) {
        super(ISOChronology.getInstance(dateTimeZone));
    }

    TimeOfDay(TimeOfDay timeOfDay, Chronology chronology) {
        super((BasePartial)timeOfDay, chronology);
    }

    TimeOfDay(TimeOfDay timeOfDay, int[] nArray) {
        super((BasePartial)timeOfDay, nArray);
    }

    public static TimeOfDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static TimeOfDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new TimeOfDay(date.getHours(), date.getMinutes(), date.getSeconds(), (1000 + (int)(date.getTime() % 1000L)) % 1000);
    }

    public static TimeOfDay fromMillisOfDay(long l2) {
        return TimeOfDay.fromMillisOfDay(l2, null);
    }

    public static TimeOfDay fromMillisOfDay(long l2, Chronology chronology) {
        return new TimeOfDay(l2, DateTimeUtils.getChronology(chronology).withUTC());
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return chronology.hourOfDay();
            }
            case 1: {
                return chronology.minuteOfHour();
            }
            case 2: {
                return chronology.secondOfMinute();
            }
            case 3: 
        }
        return chronology.millisOfSecond();
    }

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return FIELD_TYPES[n2];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public int getHourOfDay() {
        return this.getValue(0);
    }

    public int getMillisOfSecond() {
        return this.getValue(3);
    }

    public int getMinuteOfHour() {
        return this.getValue(1);
    }

    public int getSecondOfMinute() {
        return this.getValue(2);
    }

    public Property hourOfDay() {
        return new Property(this, 0);
    }

    public Property millisOfSecond() {
        return new Property(this, 3);
    }

    public TimeOfDay minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public TimeOfDay minusHours(int n2) {
        return this.withFieldAdded(DurationFieldType.hours(), FieldUtils.safeNegate(n2));
    }

    public TimeOfDay minusMillis(int n2) {
        return this.withFieldAdded(DurationFieldType.millis(), FieldUtils.safeNegate(n2));
    }

    public TimeOfDay minusMinutes(int n2) {
        return this.withFieldAdded(DurationFieldType.minutes(), FieldUtils.safeNegate(n2));
    }

    public TimeOfDay minusSeconds(int n2) {
        return this.withFieldAdded(DurationFieldType.seconds(), FieldUtils.safeNegate(n2));
    }

    public Property minuteOfHour() {
        return new Property(this, 1);
    }

    public TimeOfDay plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public TimeOfDay plusHours(int n2) {
        return this.withFieldAdded(DurationFieldType.hours(), n2);
    }

    public TimeOfDay plusMillis(int n2) {
        return this.withFieldAdded(DurationFieldType.millis(), n2);
    }

    public TimeOfDay plusMinutes(int n2) {
        return this.withFieldAdded(DurationFieldType.minutes(), n2);
    }

    public TimeOfDay plusSeconds(int n2) {
        return this.withFieldAdded(DurationFieldType.seconds(), n2);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    public Property secondOfMinute() {
        return new Property(this, 2);
    }

    @Override
    public int size() {
        return 4;
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public DateTime toDateTimeToday(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(chronology.set(this, DateTimeUtils.currentTimeMillis()), chronology);
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getHourOfDay(), this.getMinuteOfHour(), this.getSecondOfMinute(), this.getMillisOfSecond(), this.getChronology());
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.tTime().print(this);
    }

    public TimeOfDay withChronologyRetainFields(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (chronology2 == this.getChronology()) {
            return this;
        }
        TimeOfDay timeOfDay = new TimeOfDay(this, chronology2);
        chronology2.validate(timeOfDay, this.getValues());
        return timeOfDay;
    }

    public TimeOfDay withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getField(n3).set(this, n3, nArray, n2));
    }

    public TimeOfDay withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getField(n3).addWrapPartial(this, n3, nArray, n2));
    }

    public TimeOfDay withHourOfDay(int n2) {
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getChronology().hourOfDay().set(this, 0, nArray, n2));
    }

    public TimeOfDay withMillisOfSecond(int n2) {
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getChronology().millisOfSecond().set(this, 3, nArray, n2));
    }

    public TimeOfDay withMinuteOfHour(int n2) {
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getChronology().minuteOfHour().set(this, 1, nArray, n2));
    }

    public TimeOfDay withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n3 = this.indexOf(readablePeriod.getFieldType(i2));
            if (n3 < 0) continue;
            nArray = this.getField(n3).addWrapPartial(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new TimeOfDay(this, nArray);
    }

    public TimeOfDay withSecondOfMinute(int n2) {
        int[] nArray = this.getValues();
        return new TimeOfDay(this, this.getChronology().secondOfMinute().set(this, 2, nArray, n2));
    }

    @Deprecated
    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5598459141741063833L;
        private final int iFieldIndex;
        private final TimeOfDay iTimeOfDay;

        Property(TimeOfDay timeOfDay, int n2) {
            this.iTimeOfDay = timeOfDay;
            this.iFieldIndex = n2;
        }

        public TimeOfDay addNoWrapToCopy(int n2) {
            int[] nArray = this.iTimeOfDay.getValues();
            int[] nArray2 = this.getField().add(this.iTimeOfDay, this.iFieldIndex, nArray, n2);
            return new TimeOfDay(this.iTimeOfDay, nArray2);
        }

        public TimeOfDay addToCopy(int n2) {
            int[] nArray = this.iTimeOfDay.getValues();
            int[] nArray2 = this.getField().addWrapPartial(this.iTimeOfDay, this.iFieldIndex, nArray, n2);
            return new TimeOfDay(this.iTimeOfDay, nArray2);
        }

        public TimeOfDay addWrapFieldToCopy(int n2) {
            int[] nArray = this.iTimeOfDay.getValues();
            int[] nArray2 = this.getField().addWrapField(this.iTimeOfDay, this.iFieldIndex, nArray, n2);
            return new TimeOfDay(this.iTimeOfDay, nArray2);
        }

        @Override
        public int get() {
            return this.iTimeOfDay.getValue(this.iFieldIndex);
        }

        @Override
        public DateTimeField getField() {
            return this.iTimeOfDay.getField(this.iFieldIndex);
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iTimeOfDay;
        }

        public TimeOfDay getTimeOfDay() {
            return this.iTimeOfDay;
        }

        public TimeOfDay setCopy(int n2) {
            int[] nArray = this.iTimeOfDay.getValues();
            int[] nArray2 = this.getField().set(this.iTimeOfDay, this.iFieldIndex, nArray, n2);
            return new TimeOfDay(this.iTimeOfDay, nArray2);
        }

        public TimeOfDay setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public TimeOfDay setCopy(String string2, Locale locale) {
            int[] nArray = this.iTimeOfDay.getValues();
            int[] nArray2 = this.getField().set(this.iTimeOfDay, this.iFieldIndex, nArray, string2, locale);
            return new TimeOfDay(this.iTimeOfDay, nArray2);
        }

        public TimeOfDay withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public TimeOfDay withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

