/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;

public class PeriodType
implements Serializable {
    static int DAY_INDEX = 0;
    static int HOUR_INDEX = 0;
    static int MILLI_INDEX = 0;
    static int MINUTE_INDEX = 0;
    static int MONTH_INDEX = 0;
    static int SECOND_INDEX = 0;
    static int WEEK_INDEX = 0;
    static int YEAR_INDEX = 0;
    private static PeriodType cDTime;
    private static PeriodType cDays;
    private static PeriodType cHours;
    private static PeriodType cMillis;
    private static PeriodType cMinutes;
    private static PeriodType cMonths;
    private static PeriodType cSeconds;
    private static PeriodType cStandard;
    private static PeriodType cTime;
    private static final Map<PeriodType, Object> cTypes;
    private static PeriodType cWeeks;
    private static PeriodType cYD;
    private static PeriodType cYDTime;
    private static PeriodType cYMD;
    private static PeriodType cYMDTime;
    private static PeriodType cYWD;
    private static PeriodType cYWDTime;
    private static PeriodType cYears;
    private static final long serialVersionUID = 2274324892792009998L;
    private final int[] iIndices;
    private final String iName;
    private final DurationFieldType[] iTypes;

    static {
        cTypes = new HashMap<PeriodType, Object>(32);
        YEAR_INDEX = 0;
        MONTH_INDEX = 1;
        WEEK_INDEX = 2;
        DAY_INDEX = 3;
        HOUR_INDEX = 4;
        MINUTE_INDEX = 5;
        SECOND_INDEX = 6;
        MILLI_INDEX = 7;
    }

    protected PeriodType(String string2, DurationFieldType[] durationFieldTypeArray, int[] nArray) {
        this.iName = string2;
        this.iTypes = durationFieldTypeArray;
        this.iIndices = nArray;
    }

    public static PeriodType dayTime() {
        PeriodType periodType = cDTime;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cDTime = periodType = new PeriodType("DayTime", durationFieldTypeArray, new int[]{-1, -1, -1, 0, 1, 2, 3, 4});
        }
        return periodType;
    }

    public static PeriodType days() {
        PeriodType periodType = cDays;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.days()};
            cDays = periodType = new PeriodType("Days", durationFieldTypeArray, new int[]{-1, -1, -1, 0, -1, -1, -1, -1});
        }
        return periodType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PeriodType forFields(DurationFieldType[] durationFieldTypeArray) {
        synchronized (PeriodType.class) {
            if (durationFieldTypeArray == null) throw new IllegalArgumentException("Types array must not be null or empty");
            if (durationFieldTypeArray.length == 0) {
                throw new IllegalArgumentException("Types array must not be null or empty");
            }
            int n2 = 0;
            while (true) {
                if (n2 < durationFieldTypeArray.length) {
                    if (durationFieldTypeArray[n2] == null) {
                        throw new IllegalArgumentException("Types array must not contain null");
                    }
                } else {
                    PeriodType periodType;
                    Object object;
                    Map<PeriodType, Object> map = cTypes;
                    if (map.isEmpty()) {
                        map.put(PeriodType.standard(), PeriodType.standard());
                        map.put(PeriodType.yearMonthDayTime(), PeriodType.yearMonthDayTime());
                        map.put(PeriodType.yearMonthDay(), PeriodType.yearMonthDay());
                        map.put(PeriodType.yearWeekDayTime(), PeriodType.yearWeekDayTime());
                        map.put(PeriodType.yearWeekDay(), PeriodType.yearWeekDay());
                        map.put(PeriodType.yearDayTime(), PeriodType.yearDayTime());
                        map.put(PeriodType.yearDay(), PeriodType.yearDay());
                        map.put(PeriodType.dayTime(), PeriodType.dayTime());
                        map.put(PeriodType.time(), PeriodType.time());
                        map.put(PeriodType.years(), PeriodType.years());
                        map.put(PeriodType.months(), PeriodType.months());
                        map.put(PeriodType.weeks(), PeriodType.weeks());
                        map.put(PeriodType.days(), PeriodType.days());
                        map.put(PeriodType.hours(), PeriodType.hours());
                        map.put(PeriodType.minutes(), PeriodType.minutes());
                        map.put(PeriodType.seconds(), PeriodType.seconds());
                        map.put(PeriodType.millis(), PeriodType.millis());
                    }
                    if ((object = map.get(periodType = new PeriodType(null, durationFieldTypeArray, null))) instanceof PeriodType) {
                        return (PeriodType)object;
                    }
                    if (object != null) {
                        throw new IllegalArgumentException("PeriodType does not support fields: " + object);
                    }
                    PeriodType periodType2 = PeriodType.standard();
                    ArrayList<DurationFieldType> arrayList = new ArrayList<DurationFieldType>(Arrays.asList(durationFieldTypeArray));
                    if (!arrayList.remove(DurationFieldType.years())) {
                        periodType2 = periodType2.withYearsRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.months())) {
                        periodType2 = periodType2.withMonthsRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.weeks())) {
                        periodType2 = periodType2.withWeeksRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.days())) {
                        periodType2 = periodType2.withDaysRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.hours())) {
                        periodType2 = periodType2.withHoursRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.minutes())) {
                        periodType2 = periodType2.withMinutesRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.seconds())) {
                        periodType2 = periodType2.withSecondsRemoved();
                    }
                    if (!arrayList.remove(DurationFieldType.millis())) {
                        periodType2 = periodType2.withMillisRemoved();
                    }
                    if (arrayList.size() > 0) {
                        map.put(periodType, arrayList);
                        throw new IllegalArgumentException("PeriodType does not support fields: " + arrayList);
                    }
                    PeriodType periodType3 = new PeriodType(null, periodType2.iTypes, null);
                    PeriodType periodType4 = (PeriodType)map.get(periodType3);
                    if (periodType4 == null) {
                        map.put(periodType3, periodType2);
                        return periodType2;
                    }
                    map.put(periodType3, periodType4);
                    return periodType4;
                }
                ++n2;
            }
        }
    }

    public static PeriodType hours() {
        PeriodType periodType = cHours;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.hours()};
            cHours = periodType = new PeriodType("Hours", durationFieldTypeArray, new int[]{-1, -1, -1, -1, 0, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType millis() {
        PeriodType periodType = cMillis;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.millis()};
            cMillis = periodType = new PeriodType("Millis", durationFieldTypeArray, new int[]{-1, -1, -1, -1, -1, -1, -1, 0});
        }
        return periodType;
    }

    public static PeriodType minutes() {
        PeriodType periodType = cMinutes;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.minutes()};
            cMinutes = periodType = new PeriodType("Minutes", durationFieldTypeArray, new int[]{-1, -1, -1, -1, -1, 0, -1, -1});
        }
        return periodType;
    }

    public static PeriodType months() {
        PeriodType periodType = cMonths;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.months()};
            cMonths = periodType = new PeriodType("Months", durationFieldTypeArray, new int[]{-1, 0, -1, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType seconds() {
        PeriodType periodType = cSeconds;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.seconds()};
            cSeconds = periodType = new PeriodType("Seconds", durationFieldTypeArray, new int[]{-1, -1, -1, -1, -1, -1, 0, -1});
        }
        return periodType;
    }

    public static PeriodType standard() {
        PeriodType periodType = cStandard;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cStandard = periodType = new PeriodType("Standard", durationFieldTypeArray, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return periodType;
    }

    public static PeriodType time() {
        PeriodType periodType = cTime;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cTime = periodType = new PeriodType("Time", durationFieldTypeArray, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return periodType;
    }

    public static PeriodType weeks() {
        PeriodType periodType = cWeeks;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.weeks()};
            cWeeks = periodType = new PeriodType("Weeks", durationFieldTypeArray, new int[]{-1, -1, 0, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    /*
     * Enabled aggressive block sorting
     */
    private PeriodType withFieldRemoved(int n2, String string2) {
        int n3 = 0;
        int n4 = this.iIndices[n2];
        if (n4 == -1) {
            return this;
        }
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[-1 + this.size()];
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            if (i2 < n4) {
                durationFieldTypeArray[i2] = this.iTypes[i2];
                continue;
            }
            if (i2 <= n4) continue;
            durationFieldTypeArray[i2 - 1] = this.iTypes[i2];
        }
        int[] nArray = new int[8];
        while (n3 < nArray.length) {
            if (n3 < n2) {
                nArray[n3] = this.iIndices[n3];
            } else if (n3 > n2) {
                int n5 = this.iIndices[n3] == -1 ? -1 : -1 + this.iIndices[n3];
                nArray[n3] = n5;
            } else {
                nArray[n3] = -1;
            }
            ++n3;
        }
        return new PeriodType(this.getName() + string2, durationFieldTypeArray, nArray);
    }

    public static PeriodType yearDay() {
        PeriodType periodType = cYD;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days()};
            cYD = periodType = new PeriodType("YearDay", durationFieldTypeArray, new int[]{0, -1, -1, 1, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType yearDayTime() {
        PeriodType periodType = cYDTime;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cYDTime = periodType = new PeriodType("YearDayTime", durationFieldTypeArray, new int[]{0, -1, -1, 1, 2, 3, 4, 5});
        }
        return periodType;
    }

    public static PeriodType yearMonthDay() {
        PeriodType periodType = cYMD;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days()};
            cYMD = periodType = new PeriodType("YearMonthDay", durationFieldTypeArray, new int[]{0, 1, -1, 2, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType yearMonthDayTime() {
        PeriodType periodType = cYMDTime;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cYMDTime = periodType = new PeriodType("YearMonthDayTime", durationFieldTypeArray, new int[]{0, 1, -1, 2, 3, 4, 5, 6});
        }
        return periodType;
    }

    public static PeriodType yearWeekDay() {
        PeriodType periodType = cYWD;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days()};
            cYWD = periodType = new PeriodType("YearWeekDay", durationFieldTypeArray, new int[]{0, -1, 1, 2, -1, -1, -1, -1});
        }
        return periodType;
    }

    public static PeriodType yearWeekDayTime() {
        PeriodType periodType = cYWDTime;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()};
            cYWDTime = periodType = new PeriodType("YearWeekDayTime", durationFieldTypeArray, new int[]{0, -1, 1, 2, 3, 4, 5, 6});
        }
        return periodType;
    }

    public static PeriodType years() {
        PeriodType periodType = cYears;
        if (periodType == null) {
            DurationFieldType[] durationFieldTypeArray = new DurationFieldType[]{DurationFieldType.years()};
            cYears = periodType = new PeriodType("Years", durationFieldTypeArray, new int[]{0, -1, -1, -1, -1, -1, -1, -1});
        }
        return periodType;
    }

    boolean addIndexedField(ReadablePeriod readablePeriod, int n2, int[] nArray, int n3) {
        if (n3 == 0) {
            return false;
        }
        int n4 = this.iIndices[n2];
        if (n4 == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        nArray[n4] = FieldUtils.safeAdd(nArray[n4], n3);
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PeriodType)) {
            return false;
        }
        PeriodType periodType = (PeriodType)object;
        return Arrays.equals(this.iTypes, periodType.iTypes);
    }

    public DurationFieldType getFieldType(int n2) {
        return this.iTypes[n2];
    }

    int getIndexedField(ReadablePeriod readablePeriod, int n2) {
        int n3 = this.iIndices[n2];
        if (n3 == -1) {
            return 0;
        }
        return readablePeriod.getValue(n3);
    }

    public String getName() {
        return this.iName;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            n2 += this.iTypes[i2].hashCode();
        }
        return n2;
    }

    public int indexOf(DurationFieldType durationFieldType) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.iTypes[i2] != durationFieldType) continue;
            return i2;
        }
        return -1;
    }

    public boolean isSupported(DurationFieldType durationFieldType) {
        return this.indexOf(durationFieldType) >= 0;
    }

    boolean setIndexedField(ReadablePeriod readablePeriod, int n2, int[] nArray, int n3) {
        int n4 = this.iIndices[n2];
        if (n4 == -1) {
            throw new UnsupportedOperationException("Field is not supported");
        }
        nArray[n4] = n3;
        return true;
    }

    public int size() {
        return this.iTypes.length;
    }

    public String toString() {
        return "PeriodType[" + this.getName() + "]";
    }

    public PeriodType withDaysRemoved() {
        return this.withFieldRemoved(3, "NoDays");
    }

    public PeriodType withHoursRemoved() {
        return this.withFieldRemoved(4, "NoHours");
    }

    public PeriodType withMillisRemoved() {
        return this.withFieldRemoved(7, "NoMillis");
    }

    public PeriodType withMinutesRemoved() {
        return this.withFieldRemoved(5, "NoMinutes");
    }

    public PeriodType withMonthsRemoved() {
        return this.withFieldRemoved(1, "NoMonths");
    }

    public PeriodType withSecondsRemoved() {
        return this.withFieldRemoved(6, "NoSeconds");
    }

    public PeriodType withWeeksRemoved() {
        return this.withFieldRemoved(2, "NoWeeks");
    }

    public PeriodType withYearsRemoved() {
        return this.withFieldRemoved(0, "NoYears");
    }
}

