/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BasePeriod;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Period
extends BasePeriod
implements ReadablePeriod,
Serializable {
    public static final Period ZERO = new Period();
    private static final long serialVersionUID = 741052353876488155L;

    public Period() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public Period(int n2, int n3, int n4, int n5) {
        super(0, 0, 0, 0, n2, n3, n4, n5, PeriodType.standard());
    }

    public Period(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n2, n3, n4, n5, n6, n7, n8, n9, PeriodType.standard());
    }

    public Period(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, PeriodType periodType) {
        super(n2, n3, n4, n5, n6, n7, n8, n9, periodType);
    }

    public Period(long l2) {
        super(l2);
    }

    public Period(long l2, long l3) {
        super(l2, l3, null, null);
    }

    public Period(long l2, long l3, Chronology chronology) {
        super(l2, l3, null, chronology);
    }

    public Period(long l2, long l3, PeriodType periodType) {
        super(l2, l3, periodType, null);
    }

    public Period(long l2, long l3, PeriodType periodType, Chronology chronology) {
        super(l2, l3, periodType, chronology);
    }

    public Period(long l2, Chronology chronology) {
        super(l2, (PeriodType)null, chronology);
    }

    public Period(long l2, PeriodType periodType) {
        super(l2, periodType, (Chronology)null);
    }

    public Period(long l2, PeriodType periodType, Chronology chronology) {
        super(l2, periodType, chronology);
    }

    public Period(Object object) {
        super(object, null, null);
    }

    public Period(Object object, Chronology chronology) {
        super(object, null, chronology);
    }

    public Period(Object object, PeriodType periodType) {
        super(object, periodType, null);
    }

    public Period(Object object, PeriodType periodType, Chronology chronology) {
        super(object, periodType, chronology);
    }

    public Period(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        super(readableDuration, readableInstant, null);
    }

    public Period(ReadableDuration readableDuration, ReadableInstant readableInstant, PeriodType periodType) {
        super(readableDuration, readableInstant, periodType);
    }

    public Period(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        super(readableInstant, readableDuration, null);
    }

    public Period(ReadableInstant readableInstant, ReadableDuration readableDuration, PeriodType periodType) {
        super(readableInstant, readableDuration, periodType);
    }

    public Period(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2, null);
    }

    public Period(ReadableInstant readableInstant, ReadableInstant readableInstant2, PeriodType periodType) {
        super(readableInstant, readableInstant2, periodType);
    }

    public Period(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        super(readablePartial, readablePartial2, null);
    }

    public Period(ReadablePartial readablePartial, ReadablePartial readablePartial2, PeriodType periodType) {
        super(readablePartial, readablePartial2, periodType);
    }

    private Period(int[] nArray, PeriodType periodType) {
        super(nArray, periodType);
    }

    private void checkYearsAndMonths(String string2) {
        if (this.getMonths() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + string2 + " as this period contains months and months vary in length");
        }
        if (this.getYears() != 0) {
            throw new UnsupportedOperationException("Cannot convert to " + string2 + " as this period contains years and years vary in length");
        }
    }

    public static Period days(int n2) {
        return new Period(new int[]{0, 0, 0, n2, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period fieldDifference(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial == null || readablePartial2 == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (readablePartial.size() != readablePartial2.size()) {
            throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
        }
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[readablePartial.size()];
        int[] nArray = new int[readablePartial.size()];
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (readablePartial.getFieldType(i2) != readablePartial2.getFieldType(i2)) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            durationFieldTypeArray[i2] = readablePartial.getFieldType(i2).getDurationType();
            if (i2 > 0 && durationFieldTypeArray[i2 - 1] == durationFieldTypeArray[i2]) {
                throw new IllegalArgumentException("ReadablePartial objects must not have overlapping fields");
            }
            nArray[i2] = readablePartial2.getValue(i2) - readablePartial.getValue(i2);
        }
        return new Period(nArray, PeriodType.forFields(durationFieldTypeArray));
    }

    public static Period hours(int n2) {
        return new Period(new int[]{0, 0, 0, 0, n2, 0, 0, 0}, PeriodType.standard());
    }

    public static Period millis(int n2) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, 0, n2}, PeriodType.standard());
    }

    public static Period minutes(int n2) {
        return new Period(new int[]{0, 0, 0, 0, 0, n2, 0, 0}, PeriodType.standard());
    }

    public static Period months(int n2) {
        return new Period(new int[]{0, n2, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    @FromString
    public static Period parse(String string2) {
        return Period.parse(string2, ISOPeriodFormat.standard());
    }

    public static Period parse(String string2, PeriodFormatter periodFormatter) {
        return periodFormatter.parsePeriod(string2);
    }

    public static Period seconds(int n2) {
        return new Period(new int[]{0, 0, 0, 0, 0, 0, n2, 0}, PeriodType.standard());
    }

    public static Period weeks(int n2) {
        return new Period(new int[]{0, 0, n2, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public static Period years(int n2) {
        return new Period(new int[]{n2, 0, 0, 0, 0, 0, 0, 0, 0}, PeriodType.standard());
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public Period minus(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, -readablePeriod.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, -readablePeriod.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, -readablePeriod.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, -readablePeriod.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, -readablePeriod.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, -readablePeriod.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, -readablePeriod.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, -readablePeriod.get(DurationFieldType.MILLIS_TYPE));
        return new Period(nArray, this.getPeriodType());
    }

    public Period minusDays(int n2) {
        return this.plusDays(-n2);
    }

    public Period minusHours(int n2) {
        return this.plusHours(-n2);
    }

    public Period minusMillis(int n2) {
        return this.plusMillis(-n2);
    }

    public Period minusMinutes(int n2) {
        return this.plusMinutes(-n2);
    }

    public Period minusMonths(int n2) {
        return this.plusMonths(-n2);
    }

    public Period minusSeconds(int n2) {
        return this.plusSeconds(-n2);
    }

    public Period minusWeeks(int n2) {
        return this.plusWeeks(-n2);
    }

    public Period minusYears(int n2) {
        return this.plusYears(-n2);
    }

    public Period multipliedBy(int n2) {
        if (this == ZERO || n2 == 1) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = FieldUtils.safeMultiply(nArray[i2], n2);
        }
        return new Period(nArray, this.getPeriodType());
    }

    public Period negated() {
        return this.multipliedBy(-1);
    }

    public Period normalizedStandard() {
        return this.normalizedStandard(PeriodType.standard());
    }

    public Period normalizedStandard(PeriodType periodType) {
        Period period = new Period((long)this.getMillis() + 1000L * (long)this.getSeconds() + 60000L * (long)this.getMinutes() + 3600000L * (long)this.getHours() + 86400000L * (long)this.getDays() + 604800000L * (long)this.getWeeks(), DateTimeUtils.getPeriodType(periodType), (Chronology)ISOChronology.getInstanceUTC());
        int n2 = this.getYears();
        int n3 = this.getMonths();
        if (n2 != 0 || n3 != 0) {
            int n4 = FieldUtils.safeAdd(n2, n3 / 12);
            int n5 = n3 % 12;
            if (n4 != 0) {
                period = period.withYears(n4);
            }
            if (n5 != 0) {
                period = period.withMonths(n5);
            }
        }
        return period;
    }

    public Period plus(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, readablePeriod.get(DurationFieldType.YEARS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, readablePeriod.get(DurationFieldType.MONTHS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, readablePeriod.get(DurationFieldType.WEEKS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, readablePeriod.get(DurationFieldType.DAYS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, readablePeriod.get(DurationFieldType.HOURS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, readablePeriod.get(DurationFieldType.MINUTES_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, readablePeriod.get(DurationFieldType.SECONDS_TYPE));
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, readablePeriod.get(DurationFieldType.MILLIS_TYPE));
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.DAY_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.HOUR_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MILLI_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MINUTE_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.MONTH_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.SECOND_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.WEEK_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        this.getPeriodType().addIndexedField(this, PeriodType.YEAR_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    @Override
    public Period toPeriod() {
        return this;
    }

    public Days toStandardDays() {
        this.checkYearsAndMonths("Days");
        return Days.days(FieldUtils.safeToInt(FieldUtils.safeAdd(FieldUtils.safeAdd(((long)this.getMillis() + 1000L * (long)this.getSeconds() + 60000L * (long)this.getMinutes() + 3600000L * (long)this.getHours()) / 86400000L, (long)this.getDays()), 7L * (long)this.getWeeks())));
    }

    public Duration toStandardDuration() {
        this.checkYearsAndMonths("Duration");
        return new Duration((long)this.getMillis() + 1000L * (long)this.getSeconds() + 60000L * (long)this.getMinutes() + 3600000L * (long)this.getHours() + 86400000L * (long)this.getDays() + 604800000L * (long)this.getWeeks());
    }

    public Hours toStandardHours() {
        this.checkYearsAndMonths("Hours");
        return Hours.hours(FieldUtils.safeToInt(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd(((long)this.getMillis() + 1000L * (long)this.getSeconds() + 60000L * (long)this.getMinutes()) / 3600000L, (long)this.getHours()), 24L * (long)this.getDays()), 168L * (long)this.getWeeks())));
    }

    public Minutes toStandardMinutes() {
        this.checkYearsAndMonths("Minutes");
        return Minutes.minutes(FieldUtils.safeToInt(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd(((long)this.getMillis() + 1000L * (long)this.getSeconds()) / 60000L, (long)this.getMinutes()), 60L * (long)this.getHours()), 1440L * (long)this.getDays()), 10080L * (long)this.getWeeks())));
    }

    public Seconds toStandardSeconds() {
        this.checkYearsAndMonths("Seconds");
        return Seconds.seconds(FieldUtils.safeToInt(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd(FieldUtils.safeAdd((long)(this.getMillis() / 1000), (long)this.getSeconds()), 60L * (long)this.getMinutes()), 3600L * (long)this.getHours()), 86400L * (long)this.getDays()), 604800L * (long)this.getWeeks())));
    }

    public Weeks toStandardWeeks() {
        this.checkYearsAndMonths("Weeks");
        long l2 = (long)this.getMillis() + 1000L * (long)this.getSeconds() + 60000L * (long)this.getMinutes() + 3600000L * (long)this.getHours() + 86400000L * (long)this.getDays();
        return Weeks.weeks(FieldUtils.safeToInt((long)this.getWeeks() + l2 / 604800000L));
    }

    public Period withDays(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.DAY_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withField(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        int[] nArray = this.getValues();
        super.setFieldInto(nArray, durationFieldType, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        super.addFieldInto(nArray, durationFieldType, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withFields(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            return this;
        }
        return new Period(super.mergePeriodInto(this.getValues(), readablePeriod), this.getPeriodType());
    }

    public Period withHours(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.HOUR_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withMillis(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MILLI_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withMinutes(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MINUTE_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withMonths(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.MONTH_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withPeriodType(PeriodType periodType) {
        PeriodType periodType2 = DateTimeUtils.getPeriodType(periodType);
        if (periodType2.equals(this.getPeriodType())) {
            return this;
        }
        return new Period((Object)this, periodType2);
    }

    public Period withSeconds(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.SECOND_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withWeeks(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.WEEK_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }

    public Period withYears(int n2) {
        int[] nArray = this.getValues();
        this.getPeriodType().setIndexedField(this, PeriodType.YEAR_INDEX, nArray, n2);
        return new Period(nArray, this.getPeriodType());
    }
}

