/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractPartial;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Partial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 12324121189002L;
    private final Chronology iChronology;
    private transient DateTimeFormatter[] iFormatter;
    private final DateTimeFieldType[] iTypes;
    private final int[] iValues;

    public Partial() {
        this((Chronology)null);
    }

    public Partial(Chronology chronology) {
        this.iChronology = DateTimeUtils.getChronology(chronology).withUTC();
        this.iTypes = new DateTimeFieldType[0];
        this.iValues = new int[0];
    }

    Partial(Chronology chronology, DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray) {
        this.iChronology = chronology;
        this.iTypes = dateTimeFieldTypeArray;
        this.iValues = nArray;
    }

    public Partial(DateTimeFieldType dateTimeFieldType, int n2) {
        this(dateTimeFieldType, n2, null);
    }

    public Partial(DateTimeFieldType dateTimeFieldType, int n2, Chronology chronology) {
        Chronology chronology2;
        this.iChronology = chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        this.iTypes = new DateTimeFieldType[]{dateTimeFieldType};
        this.iValues = new int[]{n2};
        chronology2.validate(this, this.iValues);
    }

    Partial(Partial partial, int[] nArray) {
        this.iChronology = partial.iChronology;
        this.iTypes = partial.iTypes;
        this.iValues = nArray;
    }

    public Partial(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        this.iChronology = DateTimeUtils.getChronology(readablePartial.getChronology()).withUTC();
        this.iTypes = new DateTimeFieldType[readablePartial.size()];
        this.iValues = new int[readablePartial.size()];
        for (int i2 = 0; i2 < readablePartial.size(); ++i2) {
            this.iTypes[i2] = readablePartial.getFieldType(i2);
            this.iValues[i2] = readablePartial.getValue(i2);
        }
    }

    public Partial(DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray) {
        this(dateTimeFieldTypeArray, nArray, null);
    }

    public Partial(DateTimeFieldType[] dateTimeFieldTypeArray, int[] nArray, Chronology chronology) {
        Chronology chronology2;
        int n2 = 0;
        this.iChronology = chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (dateTimeFieldTypeArray == null) {
            throw new IllegalArgumentException("Types array must not be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("Values array must not be null");
        }
        if (nArray.length != dateTimeFieldTypeArray.length) {
            throw new IllegalArgumentException("Values array must be the same length as the types array");
        }
        if (dateTimeFieldTypeArray.length == 0) {
            this.iTypes = dateTimeFieldTypeArray;
            this.iValues = nArray;
            return;
        }
        for (int i2 = 0; i2 < dateTimeFieldTypeArray.length; ++i2) {
            if (dateTimeFieldTypeArray[i2] != null) continue;
            throw new IllegalArgumentException("Types array must not contain null: index " + i2);
        }
        Comparable comparable = null;
        while (n2 < dateTimeFieldTypeArray.length) {
            DateTimeFieldType dateTimeFieldType = dateTimeFieldTypeArray[n2];
            DurationField durationField = dateTimeFieldType.getDurationType().getField(this.iChronology);
            if (n2 > 0) {
                int n3 = comparable.compareTo(durationField);
                if (n3 < 0 || n3 != 0 && !durationField.isSupported()) {
                    throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[n2 - 1].getName() + " < " + dateTimeFieldType.getName());
                }
                if (n3 == 0) {
                    if (dateTimeFieldTypeArray[n2 - 1].getRangeDurationType() == null) {
                        if (dateTimeFieldType.getRangeDurationType() == null) {
                            throw new IllegalArgumentException("Types array must not contain duplicate: " + dateTimeFieldType.getName());
                        }
                    } else {
                        DurationField durationField2;
                        if (dateTimeFieldType.getRangeDurationType() == null) {
                            throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[n2 - 1].getName() + " < " + dateTimeFieldType.getName());
                        }
                        DurationField durationField3 = dateTimeFieldTypeArray[n2 - 1].getRangeDurationType().getField(this.iChronology);
                        if (durationField3.compareTo(durationField2 = dateTimeFieldType.getRangeDurationType().getField(this.iChronology)) < 0) {
                            throw new IllegalArgumentException("Types array must be in order largest-smallest: " + dateTimeFieldTypeArray[n2 - 1].getName() + " < " + dateTimeFieldType.getName());
                        }
                        if (durationField3.compareTo(durationField2) == 0) {
                            throw new IllegalArgumentException("Types array must not contain duplicate: " + dateTimeFieldType.getName());
                        }
                    }
                }
            }
            ++n2;
            comparable = durationField;
        }
        this.iTypes = (DateTimeFieldType[])dateTimeFieldTypeArray.clone();
        chronology2.validate(this, nArray);
        this.iValues = (int[])nArray.clone();
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        return this.iTypes[n2].getField(chronology);
    }

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return this.iTypes[n2];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])this.iTypes.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DateTimeFormatter getFormatter() {
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            if (this.size() == 0) {
                return null;
            }
            dateTimeFormatterArray = new DateTimeFormatter[2];
            try {
                ArrayList<DateTimeFieldType> arrayList = new ArrayList<DateTimeFieldType>(Arrays.asList(this.iTypes));
                dateTimeFormatterArray[0] = ISODateTimeFormat.forFields(arrayList, true, false);
                if (arrayList.size() == 0) {
                    dateTimeFormatterArray[1] = dateTimeFormatterArray[0];
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            this.iFormatter = dateTimeFormatterArray;
        }
        return dateTimeFormatterArray[0];
    }

    @Override
    public int getValue(int n2) {
        return this.iValues[n2];
    }

    @Override
    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    public boolean isMatch(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        Chronology chronology = DateTimeUtils.getInstantChronology(readableInstant);
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            if (this.iTypes[i2].getField(chronology).get(l2) == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean isMatch(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        for (int i2 = 0; i2 < this.iTypes.length; ++i2) {
            if (readablePartial.get(this.iTypes[i2]) == this.iValues[i2]) continue;
            return false;
        }
        return true;
    }

    public Partial minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public Partial plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    @Override
    public int size() {
        return this.iTypes.length;
    }

    @Override
    public String toString() {
        DateTimeFormatter dateTimeFormatter;
        DateTimeFormatter[] dateTimeFormatterArray = this.iFormatter;
        if (dateTimeFormatterArray == null) {
            this.getFormatter();
            dateTimeFormatterArray = this.iFormatter;
            if (dateTimeFormatterArray == null) {
                return this.toStringList();
            }
        }
        if ((dateTimeFormatter = dateTimeFormatterArray[1]) == null) {
            return this.toStringList();
        }
        return dateTimeFormatter.print(this);
    }

    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    public String toString(String string2, Locale locale) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }

    public String toStringList() {
        int n2 = this.size();
        StringBuilder stringBuilder = new StringBuilder(n2 * 20);
        stringBuilder.append('[');
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.iTypes[i2].getName());
            stringBuilder.append('=');
            stringBuilder.append(this.iValues[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public Partial with(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3;
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The field type must not be null");
        }
        int n4 = this.indexOf(dateTimeFieldType);
        if (n4 != -1) {
            if (n2 == this.getValue(n4)) return this;
            int[] nArray = this.getValues();
            return new Partial(this, this.getField(n4).set(this, n4, nArray, n2));
        }
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[1 + this.iTypes.length];
        int[] nArray = new int[dateTimeFieldTypeArray.length];
        DurationField durationField = dateTimeFieldType.getDurationType().getField(this.iChronology);
        if (durationField.isSupported()) {
            int n5;
            DateTimeFieldType dateTimeFieldType2;
            DurationField durationField2;
            for (n3 = 0; !(n3 >= this.iTypes.length || (durationField2 = (dateTimeFieldType2 = this.iTypes[n3]).getDurationType().getField(this.iChronology)).isSupported() && ((n5 = durationField.compareTo(durationField2)) > 0 || n5 == 0 && dateTimeFieldType.getRangeDurationType().getField(this.iChronology).compareTo(dateTimeFieldType2.getRangeDurationType().getField(this.iChronology)) > 0)); ++n3) {
            }
        } else {
            n3 = 0;
        }
        System.arraycopy(this.iTypes, 0, dateTimeFieldTypeArray, 0, n3);
        System.arraycopy(this.iValues, 0, nArray, 0, n3);
        dateTimeFieldTypeArray[n3] = dateTimeFieldType;
        nArray[n3] = n2;
        System.arraycopy(this.iTypes, n3, dateTimeFieldTypeArray, n3 + 1, -1 + (dateTimeFieldTypeArray.length - n3));
        System.arraycopy(this.iValues, n3, nArray, n3 + 1, -1 + (nArray.length - n3));
        Partial partial = new Partial(this.iChronology, dateTimeFieldTypeArray, nArray);
        this.iChronology.validate(partial, nArray);
        return partial;
    }

    public Partial withChronologyRetainFields(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (chronology2 == this.getChronology()) {
            return this;
        }
        Partial partial = new Partial(chronology2, this.iTypes, this.iValues);
        chronology2.validate(partial, this.iValues);
        return partial;
    }

    public Partial withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        return new Partial(this, this.getField(n3).set(this, n3, nArray, n2));
    }

    public Partial withFieldAddWrapped(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new Partial(this, this.getField(n3).addWrapPartial(this, n3, nArray, n2));
    }

    public Partial withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new Partial(this, this.getField(n3).add(this, n3, nArray, n2));
    }

    public Partial withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n3 = this.indexOf(readablePeriod.getFieldType(i2));
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new Partial(this, nArray);
    }

    public Partial without(DateTimeFieldType dateTimeFieldType) {
        int n2 = partial2.indexOf(dateTimeFieldType);
        if (n2 != -1) {
            DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[-1 + partial2.size()];
            int[] nArray = new int[-1 + partial2.size()];
            System.arraycopy(partial2.iTypes, 0, dateTimeFieldTypeArray, 0, n2);
            System.arraycopy(partial2.iTypes, n2 + 1, dateTimeFieldTypeArray, n2, dateTimeFieldTypeArray.length - n2);
            System.arraycopy(partial2.iValues, 0, nArray, 0, n2);
            System.arraycopy(partial2.iValues, n2 + 1, nArray, n2, nArray.length - n2);
            Partial partial = new Partial(partial2.iChronology, dateTimeFieldTypeArray, nArray);
            partial2.iChronology.validate(partial, nArray);
            Partial partial2 = partial;
        }
        return partial2;
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 53278362873888L;
        private final int iFieldIndex;
        private final Partial iPartial;

        Property(Partial partial, int n2) {
            this.iPartial = partial;
            this.iFieldIndex = n2;
        }

        public Partial addToCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            int[] nArray2 = this.getField().add(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray2);
        }

        public Partial addWrapFieldToCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            int[] nArray2 = this.getField().addWrapField(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray2);
        }

        @Override
        public int get() {
            return this.iPartial.getValue(this.iFieldIndex);
        }

        @Override
        public DateTimeField getField() {
            return this.iPartial.getField(this.iFieldIndex);
        }

        public Partial getPartial() {
            return this.iPartial;
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iPartial;
        }

        public Partial setCopy(int n2) {
            int[] nArray = this.iPartial.getValues();
            int[] nArray2 = this.getField().set(this.iPartial, this.iFieldIndex, nArray, n2);
            return new Partial(this.iPartial, nArray2);
        }

        public Partial setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public Partial setCopy(String string2, Locale locale) {
            int[] nArray = this.iPartial.getValues();
            int[] nArray2 = this.getField().set(this.iPartial, this.iFieldIndex, nArray, string2, locale);
            return new Partial(this.iPartial, nArray2);
        }

        public Partial withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public Partial withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

