/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.field.FieldUtils;

public class MutableInterval
extends BaseInterval
implements ReadWritableInterval,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5982824024992428470L;

    public MutableInterval() {
        super(0L, 0L, null);
    }

    public MutableInterval(long l2, long l3) {
        super(l2, l3, null);
    }

    public MutableInterval(long l2, long l3, Chronology chronology) {
        super(l2, l3, chronology);
    }

    public MutableInterval(Object object) {
        super(object, null);
    }

    public MutableInterval(Object object, Chronology chronology) {
        super(object, chronology);
    }

    public MutableInterval(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        super(readableDuration, readableInstant);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        super(readableInstant, readableDuration);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public MutableInterval(ReadableInstant readableInstant, ReadablePeriod readablePeriod) {
        super(readableInstant, readablePeriod);
    }

    public MutableInterval(ReadablePeriod readablePeriod, ReadableInstant readableInstant) {
        super(readablePeriod, readableInstant);
    }

    public static MutableInterval parse(String string2) {
        return new MutableInterval(string2);
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    public MutableInterval copy() {
        return (MutableInterval)this.clone();
    }

    @Override
    public void setChronology(Chronology chronology) {
        super.setInterval(this.getStartMillis(), this.getEndMillis(), chronology);
    }

    public void setDurationAfterStart(long l2) {
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), l2));
    }

    @Override
    public void setDurationAfterStart(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), l2));
    }

    public void setDurationBeforeEnd(long l2) {
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -l2));
    }

    @Override
    public void setDurationBeforeEnd(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -l2));
    }

    @Override
    public void setEnd(ReadableInstant readableInstant) {
        long l2 = DateTimeUtils.getInstantMillis(readableInstant);
        super.setInterval(this.getStartMillis(), l2, this.getChronology());
    }

    @Override
    public void setEndMillis(long l2) {
        super.setInterval(this.getStartMillis(), l2, this.getChronology());
    }

    @Override
    public void setInterval(long l2, long l3) {
        super.setInterval(l2, l3, this.getChronology());
    }

    @Override
    public void setInterval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        if (readableInstant == null && readableInstant2 == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            this.setInterval(l2, l2);
            return;
        }
        super.setInterval(DateTimeUtils.getInstantMillis(readableInstant), DateTimeUtils.getInstantMillis(readableInstant2), DateTimeUtils.getInstantChronology(readableInstant));
    }

    @Override
    public void setInterval(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            throw new IllegalArgumentException("Interval must not be null");
        }
        super.setInterval(readableInterval.getStartMillis(), readableInterval.getEndMillis(), readableInterval.getChronology());
    }

    @Override
    public void setPeriodAfterStart(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            this.setEndMillis(this.getStartMillis());
            return;
        }
        this.setEndMillis(this.getChronology().add(readablePeriod, this.getStartMillis(), 1));
    }

    @Override
    public void setPeriodBeforeEnd(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            this.setStartMillis(this.getEndMillis());
            return;
        }
        this.setStartMillis(this.getChronology().add(readablePeriod, this.getEndMillis(), -1));
    }

    @Override
    public void setStart(ReadableInstant readableInstant) {
        super.setInterval(DateTimeUtils.getInstantMillis(readableInstant), this.getEndMillis(), this.getChronology());
    }

    @Override
    public void setStartMillis(long l2) {
        super.setInterval(l2, this.getEndMillis(), this.getChronology());
    }
}

