/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Months
extends BaseSingleFieldPeriod {
    public static final Months EIGHT;
    public static final Months ELEVEN;
    public static final Months FIVE;
    public static final Months FOUR;
    public static final Months MAX_VALUE;
    public static final Months MIN_VALUE;
    public static final Months NINE;
    public static final Months ONE;
    private static final PeriodFormatter PARSER;
    public static final Months SEVEN;
    public static final Months SIX;
    public static final Months TEN;
    public static final Months THREE;
    public static final Months TWELVE;
    public static final Months TWO;
    public static final Months ZERO;
    private static final long serialVersionUID = 87525275727380867L;

    static {
        ZERO = new Months(0);
        ONE = new Months(1);
        TWO = new Months(2);
        THREE = new Months(3);
        FOUR = new Months(4);
        FIVE = new Months(5);
        SIX = new Months(6);
        SEVEN = new Months(7);
        EIGHT = new Months(8);
        NINE = new Months(9);
        TEN = new Months(10);
        ELEVEN = new Months(11);
        TWELVE = new Months(12);
        MAX_VALUE = new Months(Integer.MAX_VALUE);
        MIN_VALUE = new Months(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.months());
    }

    private Months(int n2) {
        super(n2);
    }

    public static Months months(int n2) {
        switch (n2) {
            default: {
                return new Months(n2);
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 9: {
                return NINE;
            }
            case 10: {
                return TEN;
            }
            case 11: {
                return ELEVEN;
            }
            case 12: {
                return TWELVE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: 
        }
        return MIN_VALUE;
    }

    public static Months monthsBetween(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        return Months.months(BaseSingleFieldPeriod.between(readableInstant, readableInstant2, DurationFieldType.months()));
    }

    public static Months monthsBetween(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial instanceof LocalDate && readablePartial2 instanceof LocalDate) {
            return Months.months(DateTimeUtils.getChronology(readablePartial.getChronology()).months().getDifference(((LocalDate)readablePartial2).getLocalMillis(), ((LocalDate)readablePartial).getLocalMillis()));
        }
        return Months.months(BaseSingleFieldPeriod.between(readablePartial, readablePartial2, ZERO));
    }

    public static Months monthsIn(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ZERO;
        }
        return Months.months(BaseSingleFieldPeriod.between(readableInterval.getStart(), readableInterval.getEnd(), DurationFieldType.months()));
    }

    @FromString
    public static Months parseMonths(String string2) {
        if (string2 == null) {
            return ZERO;
        }
        return Months.months(PARSER.parsePeriod(string2).getMonths());
    }

    private Object readResolve() {
        return Months.months(this.getValue());
    }

    public Months dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Months.months(this.getValue() / n2);
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.months();
    }

    public int getMonths() {
        return this.getValue();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.months();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isGreaterThan(Months months) {
        if (months == null) {
            if (this.getValue() > 0) return true;
            return false;
        }
        if (this.getValue() <= months.getValue()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLessThan(Months months) {
        if (months == null) {
            if (this.getValue() < 0) return true;
            return false;
        }
        if (this.getValue() >= months.getValue()) return false;
        return true;
    }

    public Months minus(int n2) {
        return this.plus(FieldUtils.safeNegate(n2));
    }

    public Months minus(Months months) {
        if (months == null) {
            return this;
        }
        return this.minus(months.getValue());
    }

    public Months multipliedBy(int n2) {
        return Months.months(FieldUtils.safeMultiply(this.getValue(), n2));
    }

    public Months negated() {
        return Months.months(FieldUtils.safeNegate(this.getValue()));
    }

    public Months plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Months.months(FieldUtils.safeAdd(this.getValue(), n2));
    }

    public Months plus(Months months) {
        if (months == null) {
            return this;
        }
        return this.plus(months.getValue());
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "M";
    }
}

