/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BasePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractPartialFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public final class MonthDay
extends BasePartial
implements ReadablePartial,
Serializable {
    public static final int DAY_OF_MONTH = 1;
    private static final DateTimeFieldType[] FIELD_TYPES;
    public static final int MONTH_OF_YEAR = 0;
    private static final DateTimeFormatter PARSER;
    private static final long serialVersionUID = 2954560699050434609L;

    static {
        DateTimeFieldType[] dateTimeFieldTypeArray = new DateTimeFieldType[]{DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth()};
        FIELD_TYPES = dateTimeFieldTypeArray;
        PARSER = new DateTimeFormatterBuilder().appendOptional(ISODateTimeFormat.localDateParser().getParser()).appendOptional(DateTimeFormat.forPattern("--MM-dd").getParser()).toFormatter();
    }

    public MonthDay() {
    }

    public MonthDay(int n2, int n3) {
        this(n2, n3, null);
    }

    public MonthDay(int n2, int n3, Chronology chronology) {
        super(new int[]{n2, n3}, chronology);
    }

    public MonthDay(long l2) {
        super(l2);
    }

    public MonthDay(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public MonthDay(Object object) {
        super(object, null, ISODateTimeFormat.localDateParser());
    }

    public MonthDay(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology), ISODateTimeFormat.localDateParser());
    }

    public MonthDay(Chronology chronology) {
        super(chronology);
    }

    public MonthDay(DateTimeZone dateTimeZone) {
        super(ISOChronology.getInstance(dateTimeZone));
    }

    MonthDay(MonthDay monthDay, Chronology chronology) {
        super((BasePartial)monthDay, chronology);
    }

    MonthDay(MonthDay monthDay, int[] nArray) {
        super((BasePartial)monthDay, nArray);
    }

    public static MonthDay fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new MonthDay(1 + calendar.get(2), calendar.get(5));
    }

    public static MonthDay fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new MonthDay(1 + date.getMonth(), date.getDate());
    }

    public static MonthDay now() {
        return new MonthDay();
    }

    public static MonthDay now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new MonthDay(chronology);
    }

    public static MonthDay now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new MonthDay(dateTimeZone);
    }

    @FromString
    public static MonthDay parse(String string2) {
        return MonthDay.parse(string2, PARSER);
    }

    public static MonthDay parse(String string2, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = dateTimeFormatter.parseLocalDate(string2);
        return new MonthDay(localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    private Object readResolve() {
        if (!DateTimeZone.UTC.equals(monthDay.getChronology().getZone())) {
            MonthDay monthDay = new MonthDay(monthDay, monthDay.getChronology().withUTC());
        }
        return monthDay;
    }

    public Property dayOfMonth() {
        return new Property(this, 1);
    }

    public int getDayOfMonth() {
        return this.getValue(1);
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return chronology.monthOfYear();
            }
            case 1: 
        }
        return chronology.dayOfMonth();
    }

    @Override
    public DateTimeFieldType getFieldType(int n2) {
        return FIELD_TYPES[n2];
    }

    @Override
    public DateTimeFieldType[] getFieldTypes() {
        return (DateTimeFieldType[])FIELD_TYPES.clone();
    }

    public int getMonthOfYear() {
        return this.getValue(0);
    }

    public MonthDay minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public MonthDay minusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), FieldUtils.safeNegate(n2));
    }

    public MonthDay minusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), FieldUtils.safeNegate(n2));
    }

    public Property monthOfYear() {
        return new Property(this, 0);
    }

    public MonthDay plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public MonthDay plusDays(int n2) {
        return this.withFieldAdded(DurationFieldType.days(), n2);
    }

    public MonthDay plusMonths(int n2) {
        return this.withFieldAdded(DurationFieldType.months(), n2);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        return new Property(this, this.indexOfSupported(dateTimeFieldType));
    }

    @Override
    public int size() {
        return 2;
    }

    public LocalDate toLocalDate(int n2) {
        return new LocalDate(n2, this.getMonthOfYear(), this.getDayOfMonth(), this.getChronology());
    }

    @Override
    @ToString
    public String toString() {
        ArrayList<DateTimeFieldType> arrayList = new ArrayList<DateTimeFieldType>();
        arrayList.add(DateTimeFieldType.monthOfYear());
        arrayList.add(DateTimeFieldType.dayOfMonth());
        return ISODateTimeFormat.forFields(arrayList, true, true).print(this);
    }

    @Override
    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    @Override
    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }

    public MonthDay withChronologyRetainFields(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        if (chronology2 == this.getChronology()) {
            return this;
        }
        MonthDay monthDay = new MonthDay(this, chronology2);
        chronology2.validate(monthDay, this.getValues());
        return monthDay;
    }

    public MonthDay withDayOfMonth(int n2) {
        int[] nArray = this.getValues();
        return new MonthDay(this, this.getChronology().dayOfMonth().set(this, 1, nArray, n2));
    }

    public MonthDay withField(DateTimeFieldType dateTimeFieldType, int n2) {
        int n3 = this.indexOfSupported(dateTimeFieldType);
        if (n2 == this.getValue(n3)) {
            return this;
        }
        int[] nArray = this.getValues();
        return new MonthDay(this, this.getField(n3).set(this, n3, nArray, n2));
    }

    public MonthDay withFieldAdded(DurationFieldType durationFieldType, int n2) {
        int n3 = this.indexOfSupported(durationFieldType);
        if (n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        return new MonthDay(this, this.getField(n3).add(this, n3, nArray, n2));
    }

    public MonthDay withMonthOfYear(int n2) {
        int[] nArray = this.getValues();
        return new MonthDay(this, this.getChronology().monthOfYear().set(this, 0, nArray, n2));
    }

    public MonthDay withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        int[] nArray = this.getValues();
        for (int i2 = 0; i2 < readablePeriod.size(); ++i2) {
            int n3 = this.indexOf(readablePeriod.getFieldType(i2));
            if (n3 < 0) continue;
            nArray = this.getField(n3).add(this, n3, nArray, FieldUtils.safeMultiply(readablePeriod.getValue(i2), n2));
        }
        return new MonthDay(this, nArray);
    }

    public static class Property
    extends AbstractPartialFieldProperty
    implements Serializable {
        private static final long serialVersionUID = 5727734012190224363L;
        private final MonthDay iBase;
        private final int iFieldIndex;

        Property(MonthDay monthDay, int n2) {
            this.iBase = monthDay;
            this.iFieldIndex = n2;
        }

        public MonthDay addToCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().add(this.iBase, this.iFieldIndex, nArray, n2);
            return new MonthDay(this.iBase, nArray2);
        }

        public MonthDay addWrapFieldToCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().addWrapField(this.iBase, this.iFieldIndex, nArray, n2);
            return new MonthDay(this.iBase, nArray2);
        }

        @Override
        public int get() {
            return this.iBase.getValue(this.iFieldIndex);
        }

        @Override
        public DateTimeField getField() {
            return this.iBase.getField(this.iFieldIndex);
        }

        public MonthDay getMonthDay() {
            return this.iBase;
        }

        @Override
        protected ReadablePartial getReadablePartial() {
            return this.iBase;
        }

        public MonthDay setCopy(int n2) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().set(this.iBase, this.iFieldIndex, nArray, n2);
            return new MonthDay(this.iBase, nArray2);
        }

        public MonthDay setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public MonthDay setCopy(String string2, Locale locale) {
            int[] nArray = this.iBase.getValues();
            int[] nArray2 = this.getField().set(this.iBase, this.iFieldIndex, nArray, string2, locale);
            return new MonthDay(this.iBase, nArray2);
        }
    }
}

