/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.DateTimeUtils;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalTime;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Minutes
extends BaseSingleFieldPeriod {
    public static final Minutes MAX_VALUE;
    public static final Minutes MIN_VALUE;
    public static final Minutes ONE;
    private static final PeriodFormatter PARSER;
    public static final Minutes THREE;
    public static final Minutes TWO;
    public static final Minutes ZERO;
    private static final long serialVersionUID = 87525275727380863L;

    static {
        ZERO = new Minutes(0);
        ONE = new Minutes(1);
        TWO = new Minutes(2);
        THREE = new Minutes(3);
        MAX_VALUE = new Minutes(Integer.MAX_VALUE);
        MIN_VALUE = new Minutes(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.minutes());
    }

    private Minutes(int n2) {
        super(n2);
    }

    public static Minutes minutes(int n2) {
        switch (n2) {
            default: {
                return new Minutes(n2);
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: 
        }
        return MIN_VALUE;
    }

    public static Minutes minutesBetween(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        return Minutes.minutes(BaseSingleFieldPeriod.between(readableInstant, readableInstant2, DurationFieldType.minutes()));
    }

    public static Minutes minutesBetween(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial instanceof LocalTime && readablePartial2 instanceof LocalTime) {
            return Minutes.minutes(DateTimeUtils.getChronology(readablePartial.getChronology()).minutes().getDifference(((LocalTime)readablePartial2).getLocalMillis(), ((LocalTime)readablePartial).getLocalMillis()));
        }
        return Minutes.minutes(BaseSingleFieldPeriod.between(readablePartial, readablePartial2, ZERO));
    }

    public static Minutes minutesIn(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ZERO;
        }
        return Minutes.minutes(BaseSingleFieldPeriod.between(readableInterval.getStart(), readableInterval.getEnd(), DurationFieldType.minutes()));
    }

    @FromString
    public static Minutes parseMinutes(String string2) {
        if (string2 == null) {
            return ZERO;
        }
        return Minutes.minutes(PARSER.parsePeriod(string2).getMinutes());
    }

    private Object readResolve() {
        return Minutes.minutes(this.getValue());
    }

    public static Minutes standardMinutesIn(ReadablePeriod readablePeriod) {
        return Minutes.minutes(BaseSingleFieldPeriod.standardPeriodIn(readablePeriod, 60000L));
    }

    public Minutes dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Minutes.minutes(this.getValue() / n2);
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.minutes();
    }

    public int getMinutes() {
        return this.getValue();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.minutes();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isGreaterThan(Minutes minutes) {
        if (minutes == null) {
            if (this.getValue() > 0) return true;
            return false;
        }
        if (this.getValue() <= minutes.getValue()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLessThan(Minutes minutes) {
        if (minutes == null) {
            if (this.getValue() < 0) return true;
            return false;
        }
        if (this.getValue() >= minutes.getValue()) return false;
        return true;
    }

    public Minutes minus(int n2) {
        return this.plus(FieldUtils.safeNegate(n2));
    }

    public Minutes minus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.minus(minutes.getValue());
    }

    public Minutes multipliedBy(int n2) {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), n2));
    }

    public Minutes negated() {
        return Minutes.minutes(FieldUtils.safeNegate(this.getValue()));
    }

    public Minutes plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Minutes.minutes(FieldUtils.safeAdd(this.getValue(), n2));
    }

    public Minutes plus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.plus(minutes.getValue());
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 1440);
    }

    public Duration toStandardDuration() {
        return new Duration(60000L * (long)this.getValue());
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 60);
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 10080);
    }

    @Override
    @ToString
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "M";
    }
}

