/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalTime
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final int HOUR_OF_DAY = 0;
    public static final LocalTime MIDNIGHT = new LocalTime(0, 0, 0, 0);
    private static final int MILLIS_OF_SECOND = 3;
    private static final int MINUTE_OF_HOUR = 1;
    private static final int SECOND_OF_MINUTE = 2;
    private static final Set<DurationFieldType> TIME_DURATION_TYPES = new HashSet<DurationFieldType>();
    private static final long serialVersionUID = -12873158713873L;
    private final Chronology iChronology;
    private final long iLocalMillis;

    static {
        TIME_DURATION_TYPES.add(DurationFieldType.millis());
        TIME_DURATION_TYPES.add(DurationFieldType.seconds());
        TIME_DURATION_TYPES.add(DurationFieldType.minutes());
        TIME_DURATION_TYPES.add(DurationFieldType.hours());
    }

    public LocalTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalTime(int n2, int n3) {
        this(n2, n3, 0, 0, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, ISOChronology.getInstanceUTC());
    }

    public LocalTime(int n2, int n3, int n4, int n5, Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology).withUTC();
        long l2 = chronology2.getDateTimeMillis(0L, n2, n3, n4, n5);
        this.iChronology = chronology2;
        this.iLocalMillis = l2;
    }

    public LocalTime(long l2) {
        this(l2, (Chronology)ISOChronology.getInstance());
    }

    public LocalTime(long l2, Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        long l3 = chronology2.getZone().getMillisKeepLocal(DateTimeZone.UTC, l2);
        Chronology chronology3 = chronology2.withUTC();
        this.iLocalMillis = chronology3.millisOfDay().get(l3);
        this.iChronology = chronology3;
    }

    public LocalTime(long l2, DateTimeZone dateTimeZone) {
        this(l2, (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public LocalTime(Object object) {
        this(object, (Chronology)null);
    }

    public LocalTime(Object object, Chronology chronology) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology2 = DateTimeUtils.getChronology(partialConverter.getChronology(object, chronology));
        this.iChronology = chronology2.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology2, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalTime(Object object, DateTimeZone dateTimeZone) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(object);
        Chronology chronology = DateTimeUtils.getChronology(partialConverter.getChronology(object, dateTimeZone));
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, object, chronology, ISODateTimeFormat.localTimeParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(0L, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public LocalTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalTime(DateTimeZone dateTimeZone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(dateTimeZone));
    }

    public static LocalTime fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        return new LocalTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static LocalTime fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return new LocalTime(date.getHours(), date.getMinutes(), date.getSeconds(), (1000 + (int)(date.getTime() % 1000L)) % 1000);
    }

    public static LocalTime fromMillisOfDay(long l2) {
        return LocalTime.fromMillisOfDay(l2, null);
    }

    public static LocalTime fromMillisOfDay(long l2, Chronology chronology) {
        return new LocalTime(l2, DateTimeUtils.getChronology(chronology).withUTC());
    }

    public static LocalTime now() {
        return new LocalTime();
    }

    public static LocalTime now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalTime(chronology);
    }

    public static LocalTime now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalTime(dateTimeZone);
    }

    @FromString
    public static LocalTime parse(String string2) {
        return LocalTime.parse(string2, ISODateTimeFormat.localTimeParser());
    }

    public static LocalTime parse(String string2, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseLocalTime(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readResolve() {
        if (this.iChronology == null) {
            return new LocalTime(this.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (DateTimeZone.UTC.equals(this.iChronology.getZone())) return this;
        return new LocalTime(this.iLocalMillis, this.iChronology.withUTC());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(ReadablePartial readablePartial) {
        if (this == readablePartial) {
            return 0;
        }
        if (!(readablePartial instanceof LocalTime)) return super.compareTo(readablePartial);
        LocalTime localTime = (LocalTime)readablePartial;
        if (!this.iChronology.equals(localTime.iChronology)) return super.compareTo(readablePartial);
        if (this.iLocalMillis < localTime.iLocalMillis) {
            return -1;
        }
        if (this.iLocalMillis != localTime.iLocalMillis) return 1;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocalTime)) return super.equals(object);
        LocalTime localTime = (LocalTime)object;
        if (!this.iChronology.equals(localTime.iChronology)) return super.equals(object);
        if (this.iLocalMillis != localTime.iLocalMillis) return false;
        return true;
    }

    @Override
    public int get(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return dateTimeFieldType.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    protected DateTimeField getField(int n2, Chronology chronology) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return chronology.hourOfDay();
            }
            case 1: {
                return chronology.minuteOfHour();
            }
            case 2: {
                return chronology.secondOfMinute();
            }
            case 3: 
        }
        return chronology.millisOfSecond();
    }

    public int getHourOfDay() {
        return this.getChronology().hourOfDay().get(this.getLocalMillis());
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    public int getMillisOfDay() {
        return this.getChronology().millisOfDay().get(this.getLocalMillis());
    }

    public int getMillisOfSecond() {
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public int getMinuteOfHour() {
        return this.getChronology().minuteOfHour().get(this.getLocalMillis());
    }

    public int getSecondOfMinute() {
        return this.getChronology().secondOfMinute().get(this.getLocalMillis());
    }

    @Override
    public int getValue(int n2) {
        switch (n2) {
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + n2);
            }
            case 0: {
                return this.getChronology().hourOfDay().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().minuteOfHour().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().secondOfMinute().get(this.getLocalMillis());
            }
            case 3: 
        }
        return this.getChronology().millisOfSecond().get(this.getLocalMillis());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isSupported(DateTimeFieldType dateTimeFieldType) {
        DurationFieldType durationFieldType;
        return dateTimeFieldType != null && this.isSupported(dateTimeFieldType.getDurationType()) && (this.isSupported(durationFieldType = dateTimeFieldType.getRangeDurationType()) || durationFieldType == DurationFieldType.days());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSupported(DurationFieldType durationFieldType) {
        DurationField durationField;
        block3: {
            block2: {
                if (durationFieldType == null) break block2;
                durationField = durationFieldType.getField(this.getChronology());
                if (TIME_DURATION_TYPES.contains(durationFieldType) || durationField.getUnitMillis() < this.getChronology().days().getUnitMillis()) break block3;
            }
            return false;
        }
        return durationField.isSupported();
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public LocalTime minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public LocalTime minusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().hours().subtract(this.getLocalMillis(), n2));
    }

    public LocalTime minusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().millis().subtract(this.getLocalMillis(), n2));
    }

    public LocalTime minusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().minutes().subtract(this.getLocalMillis(), n2));
    }

    public LocalTime minusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().seconds().subtract(this.getLocalMillis(), n2));
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public LocalTime plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public LocalTime plusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().hours().add(this.getLocalMillis(), n2));
    }

    public LocalTime plusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().millis().add(this.getLocalMillis(), n2));
    }

    public LocalTime plusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().minutes().add(this.getLocalMillis(), n2));
    }

    public LocalTime plusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().seconds().add(this.getLocalMillis(), n2));
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeFieldType.getField(this.getChronology()));
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    @Override
    public int size() {
        return 4;
    }

    public DateTime toDateTimeToday() {
        return this.toDateTimeToday(null);
    }

    public DateTime toDateTimeToday(DateTimeZone dateTimeZone) {
        Chronology chronology = this.getChronology().withZone(dateTimeZone);
        return new DateTime(chronology.set(this, DateTimeUtils.currentTimeMillis()), chronology);
    }

    @Override
    @ToString
    public String toString() {
        return ISODateTimeFormat.time().print(this);
    }

    public String toString(String string2) {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).print(this);
    }

    public String toString(String string2, Locale locale) throws IllegalArgumentException {
        if (string2 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(string2).withLocale(locale).print(this);
    }

    public LocalTime withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(dateTimeFieldType)) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return this.withLocalMillis(dateTimeFieldType.getField(this.getChronology()).set(this.getLocalMillis(), n2));
    }

    public LocalTime withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(durationFieldType)) {
            throw new IllegalArgumentException("Field '" + durationFieldType + "' is not supported");
        }
        if (n2 == 0) {
            return this;
        }
        return this.withLocalMillis(durationFieldType.getField(this.getChronology()).add(this.getLocalMillis(), n2));
    }

    public LocalTime withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(readablePartial, this.getLocalMillis()));
    }

    public LocalTime withHourOfDay(int n2) {
        return this.withLocalMillis(this.getChronology().hourOfDay().set(this.getLocalMillis(), n2));
    }

    LocalTime withLocalMillis(long l2) {
        if (l2 == this.getLocalMillis()) {
            return this;
        }
        return new LocalTime(l2, this.getChronology());
    }

    public LocalTime withMillisOfDay(int n2) {
        return this.withLocalMillis(this.getChronology().millisOfDay().set(this.getLocalMillis(), n2));
    }

    public LocalTime withMillisOfSecond(int n2) {
        return this.withLocalMillis(this.getChronology().millisOfSecond().set(this.getLocalMillis(), n2));
    }

    public LocalTime withMinuteOfHour(int n2) {
        return this.withLocalMillis(this.getChronology().minuteOfHour().set(this.getLocalMillis(), n2));
    }

    public LocalTime withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().add(readablePeriod, this.getLocalMillis(), n2));
    }

    public LocalTime withSecondOfMinute(int n2) {
        return this.withLocalMillis(this.getChronology().secondOfMinute().set(this.getLocalMillis(), n2));
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -325842547277223L;
        private transient DateTimeField iField;
        private transient LocalTime iInstant;

        Property(LocalTime localTime, DateTimeField dateTimeField) {
            this.iInstant = localTime;
            this.iField = dateTimeField;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalTime)objectInputStream.readObject();
            this.iField = ((DateTimeFieldType)objectInputStream.readObject()).getField(this.iInstant.getChronology());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        public LocalTime addCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), n2));
        }

        public LocalTime addCopy(long l2) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), l2));
        }

        public LocalTime addNoWrapToCopy(int n2) {
            long l2 = this.iField.add(this.iInstant.getLocalMillis(), n2);
            if ((long)this.iInstant.getChronology().millisOfDay().get(l2) != l2) {
                throw new IllegalArgumentException("The addition exceeded the boundaries of LocalTime");
            }
            return this.iInstant.withLocalMillis(l2);
        }

        public LocalTime addWrapFieldToCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), n2));
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        public LocalTime getLocalTime() {
            return this.iInstant;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        public LocalTime roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }

        public LocalTime roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalTime setCopy(int n2) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), n2));
        }

        public LocalTime setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public LocalTime setCopy(String string2, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), string2, locale));
        }

        public LocalTime withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalTime withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

