/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseInterval;
import org.joda.time.chrono.ISOChronology;

public final class Interval
extends BaseInterval
implements ReadableInterval,
Serializable {
    private static final long serialVersionUID = 4922451897541386752L;

    public Interval(long l2, long l3) {
        super(l2, l3, null);
    }

    public Interval(long l2, long l3, Chronology chronology) {
        super(l2, l3, chronology);
    }

    public Interval(long l2, long l3, DateTimeZone dateTimeZone) {
        super(l2, l3, ISOChronology.getInstance(dateTimeZone));
    }

    public Interval(Object object) {
        super(object, null);
    }

    public Interval(Object object, Chronology chronology) {
        super(object, chronology);
    }

    public Interval(ReadableDuration readableDuration, ReadableInstant readableInstant) {
        super(readableDuration, readableInstant);
    }

    public Interval(ReadableInstant readableInstant, ReadableDuration readableDuration) {
        super(readableInstant, readableDuration);
    }

    public Interval(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public Interval(ReadableInstant readableInstant, ReadablePeriod readablePeriod) {
        super(readableInstant, readablePeriod);
    }

    public Interval(ReadablePeriod readablePeriod, ReadableInstant readableInstant) {
        super(readablePeriod, readableInstant);
    }

    public static Interval parse(String string2) {
        return new Interval(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean abuts(ReadableInterval readableInterval) {
        boolean bl2;
        if (readableInterval == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            if (this.getStartMillis() == l2) return true;
            long l3 = this.getEndMillis() - l2;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            bl2 = false;
            if (l4 != false) return bl2;
            return true;
        }
        if (readableInterval.getEndMillis() == this.getStartMillis()) return true;
        long l5 = this.getEndMillis() - readableInterval.getStartMillis();
        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
        bl2 = false;
        if (l6 != false) return bl2;
        return true;
    }

    public Interval gap(ReadableInterval readableInterval) {
        ReadableInterval readableInterval2 = DateTimeUtils.getReadableInterval(readableInterval);
        long l2 = readableInterval2.getStartMillis();
        long l3 = readableInterval2.getEndMillis();
        long l4 = this.getStartMillis();
        long l5 = this.getEndMillis();
        if (l4 > l3) {
            return new Interval(l3, l4, this.getChronology());
        }
        if (l2 > l5) {
            return new Interval(l5, l2, this.getChronology());
        }
        return null;
    }

    public Interval overlap(ReadableInterval readableInterval) {
        ReadableInterval readableInterval2 = DateTimeUtils.getReadableInterval(readableInterval);
        if (!this.overlaps(readableInterval2)) {
            return null;
        }
        return new Interval(Math.max(this.getStartMillis(), readableInterval2.getStartMillis()), Math.min(this.getEndMillis(), readableInterval2.getEndMillis()), this.getChronology());
    }

    @Override
    public Interval toInterval() {
        return this;
    }

    public Interval withChronology(Chronology chronology) {
        if (this.getChronology() == chronology) {
            return this;
        }
        return new Interval(this.getStartMillis(), this.getEndMillis(), chronology);
    }

    public Interval withDurationAfterStart(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        if (l2 == this.toDurationMillis()) {
            return this;
        }
        Chronology chronology = this.getChronology();
        long l3 = this.getStartMillis();
        return new Interval(l3, chronology.add(l3, l2, 1), chronology);
    }

    public Interval withDurationBeforeEnd(ReadableDuration readableDuration) {
        long l2 = DateTimeUtils.getDurationMillis(readableDuration);
        if (l2 == this.toDurationMillis()) {
            return this;
        }
        Chronology chronology = this.getChronology();
        long l3 = this.getEndMillis();
        return new Interval(chronology.add(l3, l2, -1), l3, chronology);
    }

    public Interval withEnd(ReadableInstant readableInstant) {
        return this.withEndMillis(DateTimeUtils.getInstantMillis(readableInstant));
    }

    public Interval withEndMillis(long l2) {
        if (l2 == this.getEndMillis()) {
            return this;
        }
        return new Interval(this.getStartMillis(), l2, this.getChronology());
    }

    public Interval withPeriodAfterStart(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            return this.withDurationAfterStart(null);
        }
        Chronology chronology = this.getChronology();
        long l2 = this.getStartMillis();
        return new Interval(l2, chronology.add(readablePeriod, l2, 1), chronology);
    }

    public Interval withPeriodBeforeEnd(ReadablePeriod readablePeriod) {
        if (readablePeriod == null) {
            return this.withDurationBeforeEnd(null);
        }
        Chronology chronology = this.getChronology();
        long l2 = this.getEndMillis();
        return new Interval(chronology.add(readablePeriod, l2, -1), l2, chronology);
    }

    public Interval withStart(ReadableInstant readableInstant) {
        return this.withStartMillis(DateTimeUtils.getInstantMillis(readableInstant));
    }

    public Interval withStartMillis(long l2) {
        if (l2 == this.getStartMillis()) {
            return this;
        }
        return new Interval(l2, this.getEndMillis(), this.getChronology());
    }
}

