/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long l2) {
        this.iMillis = l2;
    }

    public Instant(Object object) {
        this.iMillis = ConverterManager.getInstance().getInstantConverter(object).getInstantMillis(object, ISOChronology.getInstanceUTC());
    }

    public static Instant now() {
        return new Instant();
    }

    @FromString
    public static Instant parse(String string2) {
        return Instant.parse(string2, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String string2, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string2).toInstant();
    }

    @Override
    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    public Instant minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public Instant minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public Instant plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public Instant plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    @Override
    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    @Override
    public Instant toInstant() {
        return this;
    }

    @Override
    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }

    public Instant withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().add(this.getMillis(), l2, n2));
    }

    public Instant withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public Instant withMillis(long l2) {
        if (l2 == this.iMillis) {
            return this;
        }
        return new Instant(l2);
    }
}

