/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;

public abstract class DurationFieldType
implements Serializable {
    static final byte CENTURIES = 2;
    static final DurationFieldType CENTURIES_TYPE;
    static final byte DAYS = 7;
    static final DurationFieldType DAYS_TYPE;
    static final byte ERAS = 1;
    static final DurationFieldType ERAS_TYPE;
    static final byte HALFDAYS = 8;
    static final DurationFieldType HALFDAYS_TYPE;
    static final byte HOURS = 9;
    static final DurationFieldType HOURS_TYPE;
    static final byte MILLIS = 12;
    static final DurationFieldType MILLIS_TYPE;
    static final byte MINUTES = 10;
    static final DurationFieldType MINUTES_TYPE;
    static final byte MONTHS = 5;
    static final DurationFieldType MONTHS_TYPE;
    static final byte SECONDS = 11;
    static final DurationFieldType SECONDS_TYPE;
    static final byte WEEKS = 6;
    static final DurationFieldType WEEKS_TYPE;
    static final byte WEEKYEARS = 3;
    static final DurationFieldType WEEKYEARS_TYPE;
    static final byte YEARS = 4;
    static final DurationFieldType YEARS_TYPE;
    private static final long serialVersionUID = 8765135187319L;
    private final String iName;

    static {
        ERAS_TYPE = new StandardDurationFieldType("eras", 1);
        CENTURIES_TYPE = new StandardDurationFieldType("centuries", 2);
        WEEKYEARS_TYPE = new StandardDurationFieldType("weekyears", 3);
        YEARS_TYPE = new StandardDurationFieldType("years", 4);
        MONTHS_TYPE = new StandardDurationFieldType("months", 5);
        WEEKS_TYPE = new StandardDurationFieldType("weeks", 6);
        DAYS_TYPE = new StandardDurationFieldType("days", 7);
        HALFDAYS_TYPE = new StandardDurationFieldType("halfdays", 8);
        HOURS_TYPE = new StandardDurationFieldType("hours", 9);
        MINUTES_TYPE = new StandardDurationFieldType("minutes", 10);
        SECONDS_TYPE = new StandardDurationFieldType("seconds", 11);
        MILLIS_TYPE = new StandardDurationFieldType("millis", 12);
    }

    protected DurationFieldType(String string2) {
        this.iName = string2;
    }

    public static DurationFieldType centuries() {
        return CENTURIES_TYPE;
    }

    public static DurationFieldType days() {
        return DAYS_TYPE;
    }

    public static DurationFieldType eras() {
        return ERAS_TYPE;
    }

    public static DurationFieldType halfdays() {
        return HALFDAYS_TYPE;
    }

    public static DurationFieldType hours() {
        return HOURS_TYPE;
    }

    public static DurationFieldType millis() {
        return MILLIS_TYPE;
    }

    public static DurationFieldType minutes() {
        return MINUTES_TYPE;
    }

    public static DurationFieldType months() {
        return MONTHS_TYPE;
    }

    public static DurationFieldType seconds() {
        return SECONDS_TYPE;
    }

    public static DurationFieldType weeks() {
        return WEEKS_TYPE;
    }

    public static DurationFieldType weekyears() {
        return WEEKYEARS_TYPE;
    }

    public static DurationFieldType years() {
        return YEARS_TYPE;
    }

    public abstract DurationField getField(Chronology var1);

    public String getName() {
        return this.iName;
    }

    public boolean isSupported(Chronology chronology) {
        return this.getField(chronology).isSupported();
    }

    public String toString() {
        return this.getName();
    }

    private static class StandardDurationFieldType
    extends DurationFieldType {
        private static final long serialVersionUID = 31156755687123L;
        private final byte iOrdinal;

        StandardDurationFieldType(String string2, byte by2) {
            super(string2);
            this.iOrdinal = by2;
        }

        private Object readResolve() {
            switch (this.iOrdinal) {
                default: {
                    return this;
                }
                case 1: {
                    return ERAS_TYPE;
                }
                case 2: {
                    return CENTURIES_TYPE;
                }
                case 3: {
                    return WEEKYEARS_TYPE;
                }
                case 4: {
                    return YEARS_TYPE;
                }
                case 5: {
                    return MONTHS_TYPE;
                }
                case 6: {
                    return WEEKS_TYPE;
                }
                case 7: {
                    return DAYS_TYPE;
                }
                case 8: {
                    return HALFDAYS_TYPE;
                }
                case 9: {
                    return HOURS_TYPE;
                }
                case 10: {
                    return MINUTES_TYPE;
                }
                case 11: {
                    return SECONDS_TYPE;
                }
                case 12: 
            }
            return MILLIS_TYPE;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof StandardDurationFieldType)) {
                        return false;
                    }
                    if (this.iOrdinal != ((StandardDurationFieldType)object).iOrdinal) break block5;
                }
                return true;
            }
            return false;
        }

        @Override
        public DurationField getField(Chronology chronology) {
            Chronology chronology2 = DateTimeUtils.getChronology(chronology);
            switch (this.iOrdinal) {
                default: {
                    throw new InternalError();
                }
                case 1: {
                    return chronology2.eras();
                }
                case 2: {
                    return chronology2.centuries();
                }
                case 3: {
                    return chronology2.weekyears();
                }
                case 4: {
                    return chronology2.years();
                }
                case 5: {
                    return chronology2.months();
                }
                case 6: {
                    return chronology2.weeks();
                }
                case 7: {
                    return chronology2.days();
                }
                case 8: {
                    return chronology2.halfdays();
                }
                case 9: {
                    return chronology2.hours();
                }
                case 10: {
                    return chronology2.minutes();
                }
                case 11: {
                    return chronology2.seconds();
                }
                case 12: 
            }
            return chronology2.millis();
        }

        public int hashCode() {
            return 1 << this.iOrdinal;
        }
    }
}

