/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import org.joda.convert.FromString;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.base.BaseDuration;
import org.joda.time.field.FieldUtils;

public final class Duration
extends BaseDuration
implements ReadableDuration,
Serializable {
    public static final Duration ZERO = new Duration(0L);
    private static final long serialVersionUID = 2471658376918L;

    public Duration(long l2) {
        super(l2);
    }

    public Duration(long l2, long l3) {
        super(l2, l3);
    }

    public Duration(Object object) {
        super(object);
    }

    public Duration(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        super(readableInstant, readableInstant2);
    }

    public static Duration millis(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(l2);
    }

    @FromString
    public static Duration parse(String string2) {
        return new Duration(string2);
    }

    public static Duration standardDays(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 86400000));
    }

    public static Duration standardHours(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 3600000));
    }

    public static Duration standardMinutes(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 60000));
    }

    public static Duration standardSeconds(long l2) {
        if (l2 == 0L) {
            return ZERO;
        }
        return new Duration(FieldUtils.safeMultiply(l2, 1000));
    }

    public long getStandardDays() {
        return this.getMillis() / 86400000L;
    }

    public long getStandardHours() {
        return this.getMillis() / 3600000L;
    }

    public long getStandardMinutes() {
        return this.getMillis() / 60000L;
    }

    public long getStandardSeconds() {
        return this.getMillis() / 1000L;
    }

    public Duration minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public Duration minus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), -1);
    }

    public Duration plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public Duration plus(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), 1);
    }

    @Override
    public Duration toDuration() {
        return this;
    }

    public Days toStandardDays() {
        return Days.days(FieldUtils.safeToInt(this.getStandardDays()));
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeToInt(this.getStandardHours()));
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeToInt(this.getStandardMinutes()));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeToInt(this.getStandardSeconds()));
    }

    public Duration withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        long l3 = FieldUtils.safeMultiply(l2, n2);
        return new Duration(FieldUtils.safeAdd(this.getMillis(), l3));
    }

    public Duration withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public Duration withMillis(long l2) {
        if (l2 == this.getMillis()) {
            return this;
        }
        return new Duration(l2);
    }
}

